/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.stress;

import java.io.IOException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.io.pagecache.stress.StressTestRecord;

public class ChecksumVerifier {
    private final int recordsPerPage;
    private final int countersPerRecord;

    public ChecksumVerifier(int recordsPerPage, int countersPerRecord) {
        this.recordsPerPage = recordsPerPage;
        this.countersPerRecord = countersPerRecord;
    }

    public void verifyChecksums(PagedFile pagedFile) throws Exception {
        try (PageCursor cursor = pagedFile.io(0L, 1);){
            while (cursor.next()) {
                for (int recordNumber = 0; recordNumber < this.recordsPerPage; ++recordNumber) {
                    this.verifyChecksum(cursor, recordNumber);
                }
            }
        }
    }

    public void verifyChecksum(PageCursor cursor, int recordNumber) throws IOException {
        long checksum;
        long actualChecksum = 0L;
        do {
            cursor.setOffset(recordNumber * (this.countersPerRecord + 1) * StressTestRecord.SizeOfCounter);
            for (int i = 0; i < this.countersPerRecord; ++i) {
                long count = cursor.getLong();
                actualChecksum += count;
            }
            checksum = cursor.getLong();
        } while (cursor.shouldRetry());
        Assert.assertThat((Object)actualChecksum, (Matcher)CoreMatchers.is((Object)checksum));
    }
}

