/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.stress;

import java.util.concurrent.TimeUnit;
import org.neo4j.io.pagecache.monitoring.PageCacheMonitor;
import org.neo4j.io.pagecache.stress.Condition;

public class Conditions {
    public static Condition numberOfEvictions(final PageCacheMonitor monitor, final long desiredNumberOfEvictions) {
        return new Condition(){

            @Override
            public boolean fulfilled() {
                return monitor.countEvictions() > desiredNumberOfEvictions;
            }
        };
    }

    public static Condition timePeriod(int duration, TimeUnit timeUnit) {
        final long endTimeInMilliseconds = System.currentTimeMillis() + timeUnit.toMillis(duration);
        return new Condition(){

            @Override
            public boolean fulfilled() {
                return System.currentTimeMillis() > endTimeInMilliseconds;
            }
        };
    }
}

