/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helpers;

import org.neo4j.helpers.Function;
import org.neo4j.helpers.Specification;
import org.neo4j.helpers.collection.Iterables;

public class Specifications {
    public static <T> Specification<T> TRUE() {
        return new Specification<T>(){

            @Override
            public boolean satisfiedBy(T instance) {
                return true;
            }
        };
    }

    public static <T> Specification<T> not(final Specification<T> specification) {
        return new Specification<T>(){

            @Override
            public boolean satisfiedBy(T instance) {
                return !specification.satisfiedBy(instance);
            }
        };
    }

    public static <T> AndSpecification<T> and(Specification<T> ... specifications) {
        return Specifications.and(Iterables.iterable(specifications));
    }

    public static <T> AndSpecification<T> and(Iterable<Specification<T>> specifications) {
        return new AndSpecification(specifications);
    }

    public static <T> OrSpecification<T> or(Specification<T> ... specifications) {
        return Specifications.or(Iterables.iterable(specifications));
    }

    public static <T> OrSpecification<T> or(Iterable<Specification<T>> specifications) {
        return new OrSpecification(specifications);
    }

    public static <T> Specification<T> in(T ... allowed) {
        return Specifications.in(Iterables.iterable(allowed));
    }

    public static <T> Specification<T> in(final Iterable<T> allowed) {
        return new Specification<T>(){

            @Override
            public boolean satisfiedBy(T item) {
                for (Object allow : allowed) {
                    if (!allow.equals(item)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static <T> Specification<T> notNull() {
        return new Specification<T>(){

            @Override
            public boolean satisfiedBy(T item) {
                return item != null;
            }
        };
    }

    public static <FROM, TO> Specification<FROM> translate(final Function<FROM, TO> function, final Specification<? super TO> specification) {
        return new Specification<FROM>(){

            @Override
            public boolean satisfiedBy(FROM item) {
                return specification.satisfiedBy(function.map(item));
            }
        };
    }

    public static class OrSpecification<T>
    implements Specification<T> {
        private final Iterable<Specification<T>> specifications;

        private OrSpecification(Iterable<Specification<T>> specifications) {
            this.specifications = specifications;
        }

        @Override
        public boolean satisfiedBy(T instance) {
            for (Specification<T> specification : this.specifications) {
                if (!specification.satisfiedBy(instance)) continue;
                return true;
            }
            return false;
        }

        public AndSpecification<T> and(Specification<T> ... specifications) {
            return Specifications.and(Iterables.prepend(this, Iterables.iterable(specifications)));
        }

        public OrSpecification<T> or(Specification<T> ... specifications) {
            Iterable iterable = Iterables.iterable(specifications);
            Iterable flatten = Iterables.flatten((Iterable[])new Iterable[]{this.specifications, iterable});
            return Specifications.or(flatten);
        }
    }

    public static class AndSpecification<T>
    implements Specification<T> {
        private final Iterable<Specification<T>> specifications;

        private AndSpecification(Iterable<Specification<T>> specifications) {
            this.specifications = specifications;
        }

        @Override
        public boolean satisfiedBy(T instance) {
            for (Specification<T> specification : this.specifications) {
                if (specification.satisfiedBy(instance)) continue;
                return false;
            }
            return true;
        }

        public AndSpecification<T> and(Specification<T> ... specifications) {
            Iterable iterable = Iterables.iterable(specifications);
            Iterable flatten = Iterables.flatten((Iterable[])new Iterable[]{this.specifications, iterable});
            return Specifications.and(flatten);
        }

        public OrSpecification<T> or(Specification<T> ... specifications) {
            return Specifications.or(Iterables.prepend(this, Iterables.iterable(specifications)));
        }
    }
}

