/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helpers.progress;

import java.io.PrintWriter;
import org.neo4j.helpers.progress.ProgressMonitorFactory;

public abstract class Indicator {
    static final Indicator NONE = new Indicator(1){

        @Override
        protected void progress(int from, int to) {
        }
    };
    private final int reportResolution;

    public Indicator(int reportResolution) {
        this.reportResolution = reportResolution;
    }

    protected abstract void progress(int var1, int var2);

    int reportResolution() {
        return this.reportResolution;
    }

    public void startProcess(long totalCount) {
    }

    public void startPart(String part, long totalCount) {
    }

    public void completePart(String part) {
    }

    public void completeProcess() {
    }

    public void failure(Throwable cause) {
    }

    static class Textual
    extends Indicator {
        private final String process;
        private final PrintWriter out;

        Textual(String process, PrintWriter out) {
            super(200);
            this.process = process;
            this.out = out;
        }

        @Override
        public void startProcess(long totalCount) {
            this.out.println(this.process);
            this.out.flush();
        }

        @Override
        protected void progress(int from, int to) {
            int i = from;
            while (i < to) {
                this.printProgress(++i);
            }
            this.out.flush();
        }

        @Override
        public void failure(Throwable cause) {
            cause.printStackTrace(this.out);
        }

        private void printProgress(int progress) {
            this.out.print('.');
            if (progress % 20 == 0) {
                this.out.printf(" %3d%%%n", progress / 2);
            }
        }
    }

    public static abstract class Decorator
    extends Indicator {
        private final Indicator indicator;

        public Decorator(ProgressMonitorFactory factory, String process) {
            this(factory.newIndicator(process));
        }

        public Decorator(Indicator indicator) {
            super(indicator.reportResolution());
            this.indicator = indicator;
        }

        @Override
        public void startProcess(long totalCount) {
            this.indicator.startProcess(totalCount);
        }

        @Override
        public void startPart(String part, long totalCount) {
            this.indicator.startPart(part, totalCount);
        }

        @Override
        public void completePart(String part) {
            this.indicator.completePart(part);
        }

        @Override
        public void completeProcess() {
            this.indicator.completeProcess();
        }

        @Override
        protected void progress(int from, int to) {
            this.indicator.progress(from, to);
        }

        @Override
        public void failure(Throwable cause) {
            this.indicator.failure(cause);
        }
    }
}

