/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.factory.GraphDatabaseSetting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.KernelExtension;
import org.neo4j.kernel.Version;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.util.StringLogger;

public abstract class KernelData {
    public static final GraphDatabaseSetting<String> forced_id = GraphDatabaseSettings.forced_kernel_id;
    private static final Map<String, KernelData> instances = new HashMap<String, KernelData>();
    private final String instanceId;
    private final Config configuration;
    private final Map<KernelExtension<?>, Object> state = new HashMap();

    private static synchronized String newInstance(KernelData instance) {
        String instanceId = instance.configuration.get(forced_id);
        if (instanceId == null) {
            instanceId = "";
        }
        if ((instanceId = instanceId.trim()).equals("")) {
            for (int i = 0; i < instances.size() + 1 && instances.containsKey(instanceId = Integer.toString(i)); ++i) {
            }
        }
        if (instances.containsKey(instanceId)) {
            throw new IllegalStateException("There is already a kernel started with " + forced_id.name() + "='" + instanceId + "'.");
        }
        instances.put(instanceId, instance);
        return instanceId;
    }

    private static synchronized Collection<KernelData> kernels() {
        return new ArrayList<KernelData>(instances.values());
    }

    private static synchronized void removeInstance(String instanceId) {
        instances.remove(instanceId);
    }

    static void visitAll(KernelExtension<?> extension, Object param) {
        for (KernelData kernel : KernelData.kernels()) {
            try {
                kernel.accept(extension, param);
            }
            catch (Throwable cause) {
                System.err.println("Agent visit failure: " + cause);
            }
        }
    }

    <S> void accept(KernelExtension<S> extension, Object param) {
        Object state = this.state.get(extension);
        if (state != null) {
            extension.agentVisit(this, state, param);
        } else {
            state = extension.agentLoad(this, param);
            if (state != null) {
                this.setState(extension, state);
            }
        }
    }

    KernelData(Config configuration) {
        this.configuration = configuration;
        this.instanceId = KernelData.newInstance(this);
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final int hashCode() {
        return this.instanceId.hashCode();
    }

    public final boolean equals(Object obj) {
        return obj instanceof KernelData && this.instanceId.equals(((KernelData)obj).instanceId);
    }

    public abstract Version version();

    public Config getConfig() {
        return this.configuration;
    }

    public abstract GraphDatabaseAPI graphDatabase();

    Collection<KernelExtension<?>> loadExtensionConfigurations(StringLogger msgLog, Iterable<KernelExtension> kernelExtensions) {
        ArrayList loadedExtensions = new ArrayList();
        for (KernelExtension extension : kernelExtensions) {
            try {
                extension.loadConfiguration(this);
                loadedExtensions.add(extension);
            }
            catch (Throwable t) {
                msgLog.logMessage("Failed to init extension " + extension, t, true);
            }
        }
        return loadedExtensions;
    }

    void loadExtensions(Collection<KernelExtension<?>> loadedExtensions, StringLogger msgLog) {
        for (KernelExtension<?> extension : loadedExtensions) {
            try {
                Object state = extension.load(this);
                if (state != null) {
                    this.setState(extension, state);
                }
                msgLog.logMessage("Extension " + extension + " loaded ok", true);
            }
            catch (Throwable cause) {
                msgLog.logMessage("Failed to load extension " + extension, cause, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void shutdown(StringLogger msgLog) {
        try {
            for (Map.Entry<KernelExtension<?>, Object> loaded : this.state.entrySet()) {
                try {
                    this.unload(loaded.getKey(), loaded.getValue());
                }
                catch (Throwable cause) {
                    msgLog.logMessage("Error unloading " + loaded, cause, true);
                }
            }
        }
        finally {
            this.state.clear();
            KernelData.removeInstance(this.instanceId);
        }
    }

    private <S> void unload(KernelExtension<S> extension, Object state) {
        extension.unload(state);
    }

    final <S> S getState(KernelExtension<S> extension) {
        return (S)this.state.get(extension);
    }

    private Object setState(KernelExtension<?> extension, Object value) {
        if (value == null) {
            return this.state.remove(extension);
        }
        return this.state.put(extension, value);
    }

    @Deprecated
    public final Object getParam(String key) {
        return this.getConfig().getParams().get(key);
    }

    public PropertyContainer properties() {
        return this.graphDatabase().getNodeManager().getGraphProperties();
    }
}

