/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb;

import java.util.Arrays;
import java.util.Collections;
import org.neo4j.graphdb.FacadeMethod;
import org.neo4j.graphdb.index.IndexManager;

public class IndexManagerFacadeMethods {
    private static final FacadeMethod<IndexManager> EXISTS_FOR_NODES = new FacadeMethod<IndexManager>("boolean existsForNodes( String indexName )"){

        @Override
        public void call(IndexManager indexManager) {
            indexManager.existsForNodes("foo");
        }
    };
    private static final FacadeMethod<IndexManager> FOR_NODES = new FacadeMethod<IndexManager>("Index<Node> forNodes( String indexName )"){

        @Override
        public void call(IndexManager indexManager) {
            indexManager.forNodes("foo");
        }
    };
    private static final FacadeMethod<IndexManager> FOR_NODES_WITH_CONFIGURATION = new FacadeMethod<IndexManager>("Index<Node> forNodes( String indexName, Map<String, String> customConfiguration )"){

        @Override
        public void call(IndexManager indexManager) {
            indexManager.forNodes("foo", null);
        }
    };
    private static final FacadeMethod<IndexManager> NODE_INDEX_NAMES = new FacadeMethod<IndexManager>("String[] nodeIndexNames()"){

        @Override
        public void call(IndexManager indexManager) {
            for (String indexName : indexManager.nodeIndexNames()) {
            }
        }
    };
    private static final FacadeMethod<IndexManager> EXISTS_FOR_RELATIONSHIPS = new FacadeMethod<IndexManager>("boolean existsForRelationships( String indexName )"){

        @Override
        public void call(IndexManager indexManager) {
            indexManager.existsForRelationships("foo");
        }
    };
    private static final FacadeMethod<IndexManager> FOR_RELATIONSHIPS = new FacadeMethod<IndexManager>("RelationshipIndex forRelationships( String indexName )"){

        @Override
        public void call(IndexManager indexManager) {
            indexManager.forRelationships("foo");
        }
    };
    private static final FacadeMethod<IndexManager> FOR_RELATIONSHIPS_WITH_CONFIGURATION = new FacadeMethod<IndexManager>("RelationshipIndex forRelationships( String indexName, Map<String, String> customConfiguration )"){

        @Override
        public void call(IndexManager indexManager) {
            indexManager.forRelationships("foo", null);
        }
    };
    private static final FacadeMethod<IndexManager> RELATIONSHIP_INDEX_NAMES = new FacadeMethod<IndexManager>("String[] relationshipIndexNames()"){

        @Override
        public void call(IndexManager indexManager) {
            for (String indexName : indexManager.relationshipIndexNames()) {
            }
        }
    };
    static final Iterable<FacadeMethod<IndexManager>> ALL_INDEX_MANAGER_FACADE_METHODS = Collections.unmodifiableCollection(Arrays.asList(EXISTS_FOR_NODES, FOR_NODES, FOR_NODES_WITH_CONFIGURATION, NODE_INDEX_NAMES, EXISTS_FOR_RELATIONSHIPS, FOR_RELATIONSHIPS, FOR_RELATIONSHIPS_WITH_CONFIGURATION, RELATIONSHIP_INDEX_NAMES));
}

