/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.DynamicLabel;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.impl.api.index.ControlledPopulationSchemaIndexProvider;
import org.neo4j.kernel.impl.api.index.SchemaIndexTestHelper;
import org.neo4j.test.DoubleLatch;
import org.neo4j.test.ImpermanentDatabaseRule;

public class SchemaIndexWaitingAcceptanceTest {
    private final ControlledPopulationSchemaIndexProvider provider = new ControlledPopulationSchemaIndexProvider();
    @Rule
    public ImpermanentDatabaseRule rule = new ImpermanentDatabaseRule(){

        @Override
        protected void configure(GraphDatabaseFactory databaseFactory) {
            List<KernelExtensionFactory> extensions = Arrays.asList(SchemaIndexTestHelper.singleInstanceSchemaIndexProviderFactory("test", SchemaIndexWaitingAcceptanceTest.this.provider));
            databaseFactory.addKernelExtensions(extensions);
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldTimeoutWatingForIndexToComeOnline() throws Exception {
        GraphDatabaseService db = this.rule.getGraphDatabaseService();
        DoubleLatch latch = this.provider.installPopulationJobCompletionLatch();
        Transaction tx = db.beginTx();
        IndexDefinition index = db.schema().indexFor(DynamicLabel.label((String)"Person")).on("name").create();
        tx.success();
        tx.finish();
        latch.awaitStart();
        tx = db.beginTx();
        try {
            db.schema().awaitIndexOnline(index, 1L, TimeUnit.MILLISECONDS);
            Assert.fail((String)"Expected IllegalStateException to be thrown");
        }
        catch (IllegalStateException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"come online"));
        }
        finally {
            tx.finish();
            latch.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldTimeoutWatingForAllIndexesToComeOnline() throws Exception {
        GraphDatabaseService db = this.rule.getGraphDatabaseService();
        DoubleLatch latch = this.provider.installPopulationJobCompletionLatch();
        Transaction tx = db.beginTx();
        db.schema().indexFor(DynamicLabel.label((String)"Person")).on("name").create();
        tx.success();
        tx.finish();
        latch.awaitStart();
        tx = db.beginTx();
        try {
            db.schema().awaitIndexesOnline(1L, TimeUnit.MILLISECONDS);
            Assert.fail((String)"Expected IllegalStateException to be thrown");
        }
        catch (IllegalStateException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"come online"));
        }
        finally {
            latch.finish();
            tx.finish();
        }
    }
}

