/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.util.concurrent.atomic.AtomicBoolean;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.helpers.Clock;
import org.neo4j.helpers.TickingClock;
import org.neo4j.kernel.AvailabilityGuard;

public class AvailabilityGuardTest {
    private final AvailabilityGuard.AvailabilityRequirement REQUIREMENT = new AvailabilityGuard.AvailabilityRequirement(){

        public String description() {
            return "Thing";
        }
    };

    @Test
    public void givenAccessGuardWith2ConditionsWhenAwaitThenTimeoutAndReturnFalse() throws Exception {
        TickingClock clock = new TickingClock(0L, 100L);
        AvailabilityGuard availabilityGuard = new AvailabilityGuard((Clock)clock, 2);
        boolean result = availabilityGuard.isAvailable(1000L);
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.equalTo((Object)false));
    }

    @Test
    public void givenAccessGuardWith2ConditionsWhenAwaitThenActuallyWaitGivenTimeout() throws Exception {
        TickingClock clock = new TickingClock(0L, 100L);
        AvailabilityGuard availabilityGuard = new AvailabilityGuard((Clock)clock, 2);
        long start = clock.currentTimeMillis();
        boolean result = availabilityGuard.isAvailable(1000L);
        long end = clock.currentTimeMillis();
        long waitTime = end - start;
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.equalTo((Object)false));
        Assert.assertThat((Object)waitTime, (Matcher)CoreMatchers.equalTo((Object)1200L));
    }

    @Test
    public void givenAccessGuardWith2ConditionsWhenGrantOnceAndAwaitThenTimeoutAndReturnFalse() throws Exception {
        TickingClock clock = new TickingClock(0L, 100L);
        AvailabilityGuard availabilityGuard = new AvailabilityGuard((Clock)clock, 2);
        long start = clock.currentTimeMillis();
        availabilityGuard.grant(this.REQUIREMENT);
        boolean result = availabilityGuard.isAvailable(1000L);
        long end = clock.currentTimeMillis();
        long waitTime = end - start;
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.equalTo((Object)false));
        Assert.assertThat((Object)waitTime, (Matcher)CoreMatchers.equalTo((Object)1200L));
    }

    @Test
    public void givenAccessGuardWith2ConditionsWhenGrantTwiceAndAwaitThenTrue() throws Exception {
        TickingClock clock = new TickingClock(0L, 100L);
        AvailabilityGuard availabilityGuard = new AvailabilityGuard((Clock)clock, 2);
        availabilityGuard.grant(this.REQUIREMENT);
        availabilityGuard.grant(this.REQUIREMENT);
        long start = clock.currentTimeMillis();
        boolean result = availabilityGuard.isAvailable(1000L);
        long end = clock.currentTimeMillis();
        long waitTime = end - start;
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.equalTo((Object)true));
        Assert.assertThat((Object)waitTime, (Matcher)CoreMatchers.equalTo((Object)100L));
    }

    @Test
    public void givenAccessGuardWith2ConditionsWhenGrantTwiceAndDenyOnceAndAwaitThenTimeoutAndReturnFalse() throws Exception {
        TickingClock clock = new TickingClock(0L, 100L);
        AvailabilityGuard availabilityGuard = new AvailabilityGuard((Clock)clock, 2);
        availabilityGuard.grant(this.REQUIREMENT);
        availabilityGuard.grant(this.REQUIREMENT);
        availabilityGuard.deny(this.REQUIREMENT);
        long start = clock.currentTimeMillis();
        boolean result = availabilityGuard.isAvailable(1000L);
        long end = clock.currentTimeMillis();
        long waitTime = end - start;
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.equalTo((Object)false));
        Assert.assertThat((Object)waitTime, (Matcher)CoreMatchers.equalTo((Object)1200L));
    }

    @Test
    public void givenAccessGuardWith2ConditionsWhenGrantOnceAndAwaitAndGrantAgainDuringAwaitThenReturnTrue() throws Exception {
        TickingClock clock = new TickingClock(0L, 100L);
        final AvailabilityGuard availabilityGuard = new AvailabilityGuard((Clock)clock, 2);
        clock.at(500L, new Runnable(){

            @Override
            public void run() {
                availabilityGuard.grant(AvailabilityGuardTest.this.REQUIREMENT);
            }
        });
        availabilityGuard.grant(this.REQUIREMENT);
        long start = clock.currentTimeMillis();
        boolean result = availabilityGuard.isAvailable(1000L);
        long end = clock.currentTimeMillis();
        long waitTime = end - start;
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.equalTo((Object)true));
        Assert.assertThat((Object)waitTime, (Matcher)CoreMatchers.equalTo((Object)600L));
    }

    @Test
    public void givenAccessGuardWithConditionWhenGrantThenNotifyListeners() throws Exception {
        TickingClock clock = new TickingClock(0L, 100L);
        AvailabilityGuard availabilityGuard = new AvailabilityGuard((Clock)clock, 1);
        final AtomicBoolean notified = new AtomicBoolean();
        AvailabilityGuard.AvailabilityListener availabilityListener = new AvailabilityGuard.AvailabilityListener(){

            public void available() {
                notified.set(true);
            }

            public void unavailable() {
            }
        };
        availabilityGuard.addListener(availabilityListener);
        availabilityGuard.grant(this.REQUIREMENT);
        Assert.assertThat((Object)notified.get(), (Matcher)CoreMatchers.equalTo((Object)true));
    }

    @Test
    public void givenAccessGuardWithConditionWhenGrantAndDenyThenNotifyListeners() throws Exception {
        TickingClock clock = new TickingClock(0L, 100L);
        AvailabilityGuard availabilityGuard = new AvailabilityGuard((Clock)clock, 1);
        final AtomicBoolean notified = new AtomicBoolean();
        AvailabilityGuard.AvailabilityListener availabilityListener = new AvailabilityGuard.AvailabilityListener(){

            public void available() {
            }

            public void unavailable() {
                notified.set(true);
            }
        };
        availabilityGuard.addListener(availabilityListener);
        availabilityGuard.grant(this.REQUIREMENT);
        availabilityGuard.deny(this.REQUIREMENT);
        Assert.assertThat((Object)notified.get(), (Matcher)CoreMatchers.equalTo((Object)true));
    }

    @Test
    public void givenAccessGuardWithConditionWhenShutdownThenInstantlyDenyAccess() throws Exception {
        TickingClock clock = new TickingClock(0L, 100L);
        AvailabilityGuard availabilityGuard = new AvailabilityGuard((Clock)clock, 1);
        availabilityGuard.shutdown();
        boolean result = availabilityGuard.isAvailable(1000L);
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.equalTo((Object)false));
        Assert.assertThat((Object)clock.currentTimeMillis(), (Matcher)CoreMatchers.equalTo((Object)0L));
    }

    @Test
    public void shouldExplainWhoIsBlockingAccess() throws Exception {
        TickingClock clock = new TickingClock(0L, 100L);
        AvailabilityGuard availabilityGuard = new AvailabilityGuard((Clock)clock, 0);
        availabilityGuard.deny(this.REQUIREMENT);
        availabilityGuard.deny(this.REQUIREMENT);
        Assert.assertThat((Object)availabilityGuard.describeWhoIsBlocking(), (Matcher)CoreMatchers.equalTo((Object)"2 reasons for blocking: Thing, Thing."));
    }
}

