/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.neo4j.helpers.Exceptions;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.AvailabilityGuard;
import org.neo4j.kernel.InternalAbstractGraphDatabase;
import org.neo4j.test.TargetDirectory;

public class InternalAbstractGraphDatabaseTest {
    @Rule
    public final TargetDirectory.TestDirectory dir = TargetDirectory.testDirForTest(this.getClass());

    @Test
    public void shouldThrowAppropriateExceptionIfStartFails() {
        RuntimeException startupError = new RuntimeException();
        InternalAbstractGraphDatabase db = this.newFaultyInternalAbstractGraphDatabase(startupError, null);
        try {
            db.run();
            Assert.fail((String)("Should have thrown " + RuntimeException.class));
        }
        catch (RuntimeException exception) {
            Assert.assertEquals((Object)startupError, (Object)Exceptions.rootCause((Throwable)exception));
        }
    }

    @Test
    public void shouldThrowAppropriateExceptionIfBothStartAndShutdownFail() {
        RuntimeException startupError = new RuntimeException();
        RuntimeException shutdownError = new RuntimeException();
        InternalAbstractGraphDatabase db = this.newFaultyInternalAbstractGraphDatabase(startupError, shutdownError);
        try {
            db.run();
            Assert.fail((String)("Should have thrown " + RuntimeException.class));
        }
        catch (RuntimeException exception) {
            Assert.assertEquals((Object)shutdownError, (Object)exception);
            Assert.assertEquals((Object)startupError, (Object)Exceptions.rootCause((Throwable)exception.getSuppressed()[0]));
        }
    }

    private InternalAbstractGraphDatabase newFaultyInternalAbstractGraphDatabase(final RuntimeException startupError, final RuntimeException shutdownError) {
        InternalAbstractGraphDatabase.Dependencies mockedDependencies = (InternalAbstractGraphDatabase.Dependencies)Mockito.mock(InternalAbstractGraphDatabase.Dependencies.class, (Answer)Mockito.RETURNS_MOCKS);
        return new InternalAbstractGraphDatabase(this.dir.absolutePath(), MapUtil.stringMap((String[])new String[0]), mockedDependencies){

            protected void create() {
                this.availabilityGuard = (AvailabilityGuard)Mockito.mock(AvailabilityGuard.class);
            }

            protected void registerRecovery() {
                if (startupError != null) {
                    throw startupError;
                }
            }

            public void shutdown() {
                if (shutdownError != null) {
                    throw shutdownError;
                }
            }
        };
    }
}

