/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api;

import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.neo4j.collection.pool.Pool;
import org.neo4j.helpers.Clock;
import org.neo4j.helpers.FakeClock;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.api.txstate.LegacyIndexTransactionState;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.api.RecordStateForCacheAccessor;
import org.neo4j.kernel.impl.api.TransactionApplicationMode;
import org.neo4j.kernel.impl.api.TransactionCommitProcess;
import org.neo4j.kernel.impl.api.TransactionHeaderInformation;
import org.neo4j.kernel.impl.api.TransactionHooks;
import org.neo4j.kernel.impl.locking.LockGroup;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.NoOpClient;
import org.neo4j.kernel.impl.store.NeoStore;
import org.neo4j.kernel.impl.transaction.TransactionHeaderInformationFactory;
import org.neo4j.kernel.impl.transaction.TransactionMonitor;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.state.TransactionRecordState;
import org.neo4j.kernel.impl.transaction.tracing.CommitEvent;
import org.neo4j.kernel.impl.transaction.tracing.TransactionTracer;
import org.neo4j.test.DoubleLatch;

public class KernelTransactionImplementationTest {
    private final NeoStore neoStore = (NeoStore)Mockito.mock(NeoStore.class);
    private final TransactionHooks hooks = new TransactionHooks();
    private final TransactionRecordState recordState = (TransactionRecordState)Mockito.mock(TransactionRecordState.class);
    private final RecordStateForCacheAccessor recordStateAccessor = (RecordStateForCacheAccessor)Mockito.mock(RecordStateForCacheAccessor.class);
    private final LegacyIndexTransactionState legacyIndexState = (LegacyIndexTransactionState)Mockito.mock(LegacyIndexTransactionState.class);
    private final TransactionMonitor transactionMonitor = (TransactionMonitor)Mockito.mock(TransactionMonitor.class);
    private final CapturingCommitProcess commitProcess = new CapturingCommitProcess();
    private final TransactionHeaderInformation headerInformation = (TransactionHeaderInformation)Mockito.mock(TransactionHeaderInformation.class);
    private final TransactionHeaderInformationFactory headerInformationFactory = (TransactionHeaderInformationFactory)Mockito.mock(TransactionHeaderInformationFactory.class);
    private final FakeClock clock = new FakeClock();

    @Test
    public void shouldCommitSuccessfulTransaction() throws Exception {
        try (KernelTransactionImplementation transaction = this.newTransaction();){
            transaction.success();
        }
        ((TransactionMonitor)Mockito.verify((Object)this.transactionMonitor, (VerificationMode)Mockito.times((int)1))).transactionFinished(true);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.transactionMonitor});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldRollbackUnsuccessfulTransaction() throws Exception {
        KernelTransactionImplementation transaction = this.newTransaction();
        Throwable throwable = null;
        if (transaction != null) {
            if (throwable != null) {
                try {
                    transaction.close();
                }
                catch (Throwable x2) {
                    throwable.addSuppressed(x2);
                }
            } else {
                transaction.close();
            }
        }
        ((TransactionMonitor)Mockito.verify((Object)this.transactionMonitor, (VerificationMode)Mockito.times((int)1))).transactionFinished(false);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.transactionMonitor});
    }

    @Test
    public void shouldRollbackFailedTransaction() throws Exception {
        try (KernelTransactionImplementation transaction = this.newTransaction();){
            transaction.failure();
        }
        ((TransactionMonitor)Mockito.verify((Object)this.transactionMonitor, (VerificationMode)Mockito.times((int)1))).transactionFinished(false);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.transactionMonitor});
    }

    @Test
    public void shouldRollbackAndThrowOnFailedAndSuccess() throws Exception {
        boolean exceptionReceived = false;
        try (KernelTransactionImplementation transaction = this.newTransaction();){
            transaction.failure();
            transaction.success();
        }
        catch (TransactionFailureException e) {
            exceptionReceived = true;
        }
        Assert.assertTrue((boolean)exceptionReceived);
        ((TransactionMonitor)Mockito.verify((Object)this.transactionMonitor, (VerificationMode)Mockito.times((int)1))).transactionFinished(false);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.transactionMonitor});
    }

    @Test
    public void shouldRollbackOnClosingTerminatedTransaction() throws Exception {
        boolean exceptionReceived = false;
        try (KernelTransactionImplementation transaction = this.newTransaction();){
            transaction.success();
            transaction.markForTermination();
        }
        catch (TransactionFailureException e) {
            exceptionReceived = true;
        }
        Assert.assertTrue((boolean)exceptionReceived);
        ((TransactionMonitor)Mockito.verify((Object)this.transactionMonitor, (VerificationMode)Mockito.times((int)1))).transactionFinished(false);
        ((TransactionMonitor)Mockito.verify((Object)this.transactionMonitor, (VerificationMode)Mockito.times((int)1))).transactionTerminated();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.transactionMonitor});
    }

    @Test
    public void shouldRollbackOnClosingSuccessfulButTerminatedTransaction() throws Exception {
        try (KernelTransactionImplementation transaction = this.newTransaction();){
            transaction.markForTermination();
            Assert.assertTrue((boolean)transaction.shouldBeTerminated());
        }
        ((TransactionMonitor)Mockito.verify((Object)this.transactionMonitor, (VerificationMode)Mockito.times((int)1))).transactionFinished(false);
        ((TransactionMonitor)Mockito.verify((Object)this.transactionMonitor, (VerificationMode)Mockito.times((int)1))).transactionTerminated();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.transactionMonitor});
    }

    @Test
    public void shouldRollbackOnClosingTerminatedButSuccessfulTransaction() throws Exception {
        boolean exceptionReceived = false;
        try (KernelTransactionImplementation transaction = this.newTransaction();){
            transaction.markForTermination();
            transaction.success();
            Assert.assertTrue((boolean)transaction.shouldBeTerminated());
        }
        catch (TransactionFailureException e) {
            exceptionReceived = true;
        }
        Assert.assertTrue((boolean)exceptionReceived);
        ((TransactionMonitor)Mockito.verify((Object)this.transactionMonitor, (VerificationMode)Mockito.times((int)1))).transactionFinished(false);
        ((TransactionMonitor)Mockito.verify((Object)this.transactionMonitor, (VerificationMode)Mockito.times((int)1))).transactionTerminated();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.transactionMonitor});
    }

    @Test
    public void shouldNotDowngradeFailureState() throws Exception {
        try (KernelTransactionImplementation transaction = this.newTransaction();){
            transaction.markForTermination();
            transaction.failure();
            Assert.assertTrue((boolean)transaction.shouldBeTerminated());
        }
        ((TransactionMonitor)Mockito.verify((Object)this.transactionMonitor, (VerificationMode)Mockito.times((int)1))).transactionFinished(false);
        ((TransactionMonitor)Mockito.verify((Object)this.transactionMonitor, (VerificationMode)Mockito.times((int)1))).transactionTerminated();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.transactionMonitor});
    }

    @Test
    public void shouldIgnoreTerminateAfterCommit() throws Exception {
        KernelTransactionImplementation transaction = this.newTransaction();
        transaction.success();
        transaction.close();
        transaction.markForTermination();
        ((TransactionMonitor)Mockito.verify((Object)this.transactionMonitor, (VerificationMode)Mockito.times((int)1))).transactionFinished(true);
        ((TransactionMonitor)Mockito.verify((Object)this.transactionMonitor, (VerificationMode)Mockito.times((int)1))).transactionTerminated();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.transactionMonitor});
    }

    @Test
    public void shouldIgnoreTerminateAfterRollback() throws Exception {
        KernelTransactionImplementation transaction = this.newTransaction();
        transaction.close();
        transaction.markForTermination();
        ((TransactionMonitor)Mockito.verify((Object)this.transactionMonitor, (VerificationMode)Mockito.times((int)1))).transactionFinished(false);
        ((TransactionMonitor)Mockito.verify((Object)this.transactionMonitor, (VerificationMode)Mockito.times((int)1))).transactionTerminated();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.transactionMonitor});
    }

    @Test(expected=TransactionFailureException.class)
    public void shouldThrowOnTerminationInCommit() throws Exception {
        KernelTransactionImplementation transaction = this.newTransaction();
        transaction.success();
        transaction.markForTermination();
        transaction.close();
    }

    @Test
    public void shouldIgnoreTerminationDuringRollback() throws Exception {
        KernelTransactionImplementation transaction = this.newTransaction();
        transaction.markForTermination();
        transaction.close();
        ((TransactionMonitor)Mockito.verify((Object)this.transactionMonitor, (VerificationMode)Mockito.times((int)1))).transactionFinished(false);
        ((TransactionMonitor)Mockito.verify((Object)this.transactionMonitor, (VerificationMode)Mockito.times((int)1))).transactionTerminated();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.transactionMonitor});
    }

    @Test
    public void shouldAllowTerminatingFromADifferentThread() throws Exception {
        ChildException childException = new ChildException();
        final DoubleLatch latch = new DoubleLatch(1);
        KernelTransactionImplementation transaction = this.newTransaction();
        Thread thread = new Thread(new Runnable((KernelTransaction)transaction, childException){
            final /* synthetic */ KernelTransaction val$transaction;
            final /* synthetic */ ChildException val$childException;
            {
                this.val$transaction = kernelTransaction;
                this.val$childException = childException;
            }

            @Override
            public void run() {
                try {
                    latch.awaitStart();
                    this.val$transaction.markForTermination();
                    latch.finish();
                }
                catch (Exception e) {
                    this.val$childException.exception = e;
                }
            }
        });
        thread.start();
        transaction.success();
        latch.startAndAwaitFinish();
        if (childException.exception != null) {
            throw childException.exception;
        }
        boolean exceptionReceived = false;
        try {
            transaction.close();
        }
        catch (TransactionFailureException e) {
            exceptionReceived = true;
        }
        Assert.assertTrue((boolean)exceptionReceived);
        ((TransactionMonitor)Mockito.verify((Object)this.transactionMonitor, (VerificationMode)Mockito.times((int)1))).transactionFinished(false);
        ((TransactionMonitor)Mockito.verify((Object)this.transactionMonitor, (VerificationMode)Mockito.times((int)1))).transactionTerminated();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.transactionMonitor});
    }

    @Test
    public void shouldUseStartTimeAndTxIdFromWhenStartingTxAsHeader() throws Exception {
        long startingTime = this.clock.currentTimeMillis();
        Mockito.when((Object)this.recordState.hasChanges()).thenReturn((Object)true);
        ((TransactionRecordState)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocationOnMock) throws Throwable {
                Collection commands = (Collection)invocationOnMock.getArguments()[0];
                commands.add(new Command.NodeCommand());
                return null;
            }
        }).when((Object)this.recordState)).extractCommands((Collection)Matchers.anyListOf(Command.class));
        try (KernelTransactionImplementation transaction = this.newTransaction();){
            transaction.initialize(5L);
            this.clock.forward(5L, TimeUnit.MILLISECONDS);
            Mockito.when((Object)this.neoStore.getLastCommittedTransactionId()).thenReturn((Object)7L);
            transaction.success();
        }
        Assert.assertEquals((long)5L, (long)this.commitProcess.transaction.getLatestCommittedTxWhenStarted());
        Assert.assertEquals((long)startingTime, (long)this.commitProcess.transaction.getTimeStarted());
        Assert.assertEquals((long)(startingTime + 5L), (long)this.commitProcess.transaction.getTimeCommitted());
    }

    @Before
    public void before() {
        Mockito.when((Object)this.headerInformation.getAdditionalHeader()).thenReturn((Object)new byte[0]);
        Mockito.when((Object)this.headerInformationFactory.create()).thenReturn((Object)this.headerInformation);
    }

    private KernelTransactionImplementation newTransaction() {
        KernelTransactionImplementation transaction = new KernelTransactionImplementation(null, null, null, null, null, this.recordState, this.recordStateAccessor, null, this.neoStore, (Locks.Client)new NoOpClient(), this.hooks, null, this.headerInformationFactory, (TransactionCommitProcess)this.commitProcess, this.transactionMonitor, null, null, this.legacyIndexState, (Pool)Mockito.mock(Pool.class), (Clock)this.clock, TransactionTracer.NULL);
        transaction.initialize(0L);
        return transaction;
    }

    public class CapturingCommitProcess
    implements TransactionCommitProcess {
        private long txId = 1L;
        private TransactionRepresentation transaction;

        public long commit(TransactionRepresentation representation, LockGroup locks, CommitEvent commitEvent, TransactionApplicationMode mode) throws TransactionFailureException {
            assert (this.transaction == null) : "Designed to only allow one transaction";
            this.transaction = representation;
            return this.txId++;
        }
    }

    class ChildException {
        public Exception exception = null;

        ChildException() {
        }
    }
}

