/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.index;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.kernel.DefaultFileSystemAbstraction;
import org.neo4j.kernel.api.index.ProviderMeta;
import org.neo4j.kernel.impl.store.InvalidRecordException;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.test.TargetDirectory;

public class ProviderMetaTest {
    @Rule
    public final TargetDirectory.TestDirectory directory = TargetDirectory.testDirForTest(this.getClass());
    private final LifeSupport life = new LifeSupport();
    private final FileSystemAbstraction fs = new DefaultFileSystemAbstraction();
    private File metaFile;
    private ProviderMeta meta;

    @Test
    public void shouldThrowInvalidRecordOnNonExistentRecord() throws Exception {
        try {
            this.meta.getRecord(10L);
            Assert.fail((String)"Should throw exception");
        }
        catch (InvalidRecordException invalidRecordException) {
            // empty catch block
        }
    }

    @Test
    public void shouldUpdateRecordAndThenReadIt() throws Exception {
        long id = 3L;
        long value = 12345L;
        ProviderMeta.Record record = new ProviderMeta.Record(id, value);
        record.setInUse(true);
        this.meta.updateRecord(record);
        ProviderMeta.Record readRecord = this.meta.getRecord(id);
        Assert.assertEquals((Object)record, (Object)readRecord);
        Assert.assertEquals((long)value, (long)readRecord.getValue());
        Assert.assertTrue((boolean)readRecord.inUse());
    }

    @Test
    public void shouldUpdateNotInUseRecordAndThenGetInvalidRecordWhenReadingIt() throws Exception {
        long id = 3L;
        long value = 12345L;
        ProviderMeta.Record record = new ProviderMeta.Record(id, value);
        record.setInUse(false);
        this.meta.updateRecord(record);
        try {
            this.meta.getRecord(id);
            Assert.fail((String)"Should throw invalid record exception");
        }
        catch (InvalidRecordException e) {
            // empty catch block
        }
    }

    @Test
    public void shouldDeferUpdateRecordToFileIfAnyActiveSnapshot() throws Exception {
        this.meta.updateRecord(new ProviderMeta.Record(3L, 5L));
        this.meta.force();
        try (ProviderMeta.Snapshot snapshot = this.meta.snapshot();){
            this.meta.updateRecord(new ProviderMeta.Record(3L, 2L));
            this.meta.force();
            Assert.assertEquals((long)2L, (long)this.meta.getRecord(3L).getValue());
            Assert.assertEquals((long)5L, (long)this.readRecordFromFile(3L));
        }
        this.meta.force();
        Assert.assertEquals((long)2L, (long)this.readRecordFromFile(3L));
    }

    private long readRecordFromFile(long id) throws IOException {
        try (StoreChannel channel = this.fs.open(this.metaFile, "r");){
            channel.position(9L * id);
            ByteBuffer buffer = ByteBuffer.allocate(9);
            Assert.assertEquals((long)9L, (long)channel.read(buffer));
            buffer.flip();
            buffer.get();
            long l = buffer.getLong();
            return l;
        }
    }

    @Before
    public void before() {
        this.metaFile = new File(this.directory.directory(), "meta");
        this.meta = (ProviderMeta)this.life.add((Object)new ProviderMeta(this.fs, this.metaFile));
        this.life.start();
    }

    @After
    public void after() {
        this.life.shutdown();
    }
}

