/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index.sampling;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.impl.api.index.sampling.NonUniqueIndexSampler;
import org.neo4j.register.Register;
import org.neo4j.register.Registers;

public class NonUniqueIndexSamplerTest {
    private final String value = "aaa";

    @Test
    public void shouldSampleNothing() {
        NonUniqueIndexSampler sampler = new NonUniqueIndexSampler(10);
        this.assertSampledValues(sampler, 0L, 0L, 0L);
    }

    @Test
    public void shouldSampleASingleValue() {
        NonUniqueIndexSampler sampler = new NonUniqueIndexSampler(10);
        sampler.include("aaa");
        this.assertSampledValues(sampler, 1L, 1L, 1L);
    }

    @Test
    public void shouldSampleDuplicateValues() {
        NonUniqueIndexSampler sampler = new NonUniqueIndexSampler(10);
        sampler.include("aaa");
        sampler.include("aaa");
        sampler.include("bbb");
        this.assertSampledValues(sampler, 3L, 2L, 3L);
    }

    @Test
    public void shouldDivideTheSamplingInStepsNotBiggerThanBatchSize() {
        NonUniqueIndexSampler sampler = new NonUniqueIndexSampler(1);
        sampler.include("aaa");
        sampler.include("aaa");
        sampler.include("bbb");
        this.assertSampledValues(sampler, 3L, 1L, 1L);
    }

    @Test
    public void shouldExcludeValuesFromTheCurrentSampling() {
        NonUniqueIndexSampler sampler = new NonUniqueIndexSampler(10);
        sampler.include("aaa");
        sampler.include("aaa");
        sampler.include("bbb");
        sampler.exclude("aaa");
        this.assertSampledValues(sampler, 2L, 2L, 2L);
    }

    @Test
    public void shouldDoNothingWhenExcludingAValueInAnEmptySample() {
        NonUniqueIndexSampler sampler = new NonUniqueIndexSampler(10);
        sampler.exclude("aaa");
        sampler.include("aaa");
        this.assertSampledValues(sampler, 1L, 1L, 1L);
    }

    private void assertSampledValues(NonUniqueIndexSampler sampler, long expectedIndexSize, long expectedUniqueValues, long expectedSampledSize) {
        Register.DoubleLongRegister register = Registers.newDoubleLongRegister();
        long indexSize = sampler.result((Register.DoubleLong.Out)register);
        Assert.assertEquals((long)expectedUniqueValues, (long)register.readFirst());
        Assert.assertEquals((long)expectedSampledSize, (long)register.readSecond());
        Assert.assertEquals((long)expectedIndexSize, (long)indexSize);
    }
}

