/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.integrationtest;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.DynamicLabel;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.graphdb.schema.Schema;
import org.neo4j.helpers.Function;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.api.ReadOperations;
import org.neo4j.kernel.api.SchemaWriteOperations;
import org.neo4j.kernel.api.constraints.UniquenessConstraint;
import org.neo4j.kernel.api.exceptions.KernelException;
import org.neo4j.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.api.exceptions.schema.AlreadyConstrainedException;
import org.neo4j.kernel.api.exceptions.schema.DropConstraintFailureException;
import org.neo4j.kernel.api.exceptions.schema.NoSuchConstraintException;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.impl.api.integrationtest.KernelIntegrationTest;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.SchemaStorage;
import org.neo4j.kernel.impl.store.UniquenessConstraintRule;
import org.neo4j.kernel.impl.store.record.IndexRule;

public class ConstraintsCreationIT
extends KernelIntegrationTest {
    private int labelId;
    private int propertyKeyId;

    @Test
    public void shouldBeAbleToStoreAndRetrieveUniquenessConstraintRule() throws Exception {
        SchemaWriteOperations statement = this.schemaWriteOperationsInNewTransaction();
        UniquenessConstraint constraint = statement.uniquenessConstraintCreate(this.labelId, this.propertyKeyId);
        Assert.assertEquals((Object)constraint, (Object)IteratorUtil.single((Iterator)statement.constraintsGetForLabelAndPropertyKey(this.labelId, this.propertyKeyId)));
        Assert.assertEquals((Object)constraint, (Object)IteratorUtil.single((Iterator)statement.constraintsGetForLabel(this.labelId)));
        this.commit();
        statement = this.schemaWriteOperationsInNewTransaction();
        Iterator constraints = statement.constraintsGetForLabelAndPropertyKey(this.labelId, this.propertyKeyId);
        Assert.assertEquals((Object)constraint, (Object)IteratorUtil.single((Iterator)constraints));
    }

    @Test
    public void shouldNotPersistUniquenessConstraintsCreatedInAbortedTransaction() throws Exception {
        SchemaWriteOperations statement = this.schemaWriteOperationsInNewTransaction();
        statement.uniquenessConstraintCreate(this.labelId, this.propertyKeyId);
        this.rollback();
        statement = this.schemaWriteOperationsInNewTransaction();
        Iterator constraints = statement.constraintsGetForLabelAndPropertyKey(this.labelId, this.propertyKeyId);
        Assert.assertFalse((String)"should not have any constraints", (boolean)constraints.hasNext());
    }

    @Test
    public void shouldNotStoreUniquenessConstraintThatIsRemovedInTheSameTransaction() throws Exception {
        SchemaWriteOperations statement = this.schemaWriteOperationsInNewTransaction();
        UniquenessConstraint constraint = statement.uniquenessConstraintCreate(this.labelId, this.propertyKeyId);
        statement.constraintDrop(constraint);
        Assert.assertFalse((String)"should not have any constraints", (boolean)statement.constraintsGetForLabelAndPropertyKey(this.labelId, this.propertyKeyId).hasNext());
        this.commit();
        statement = this.schemaWriteOperationsInNewTransaction();
        Assert.assertFalse((String)"should not have any constraints", (boolean)statement.constraintsGetForLabelAndPropertyKey(this.labelId, this.propertyKeyId).hasNext());
    }

    @Test
    public void shouldNotCreateUniquenessConstraintThatAlreadyExists() throws Exception {
        SchemaWriteOperations statement = this.schemaWriteOperationsInNewTransaction();
        statement.uniquenessConstraintCreate(this.labelId, this.propertyKeyId);
        this.commit();
        try {
            statement = this.schemaWriteOperationsInNewTransaction();
            statement.uniquenessConstraintCreate(this.labelId, this.propertyKeyId);
            Assert.fail((String)"Should not have validated");
        }
        catch (AlreadyConstrainedException alreadyConstrainedException) {
            // empty catch block
        }
    }

    @Test
    public void shouldNotRemoveConstraintThatGetsReAdded() throws Exception {
        SchemaWriteOperations statement = this.schemaWriteOperationsInNewTransaction();
        UniquenessConstraint constraint = statement.uniquenessConstraintCreate(this.labelId, this.propertyKeyId);
        this.commit();
        SchemaStateCheck schemaState = new SchemaStateCheck().setUp();
        SchemaWriteOperations statement2 = this.schemaWriteOperationsInNewTransaction();
        statement2.constraintDrop(constraint);
        statement2.uniquenessConstraintCreate(this.labelId, this.propertyKeyId);
        this.commit();
        statement2 = this.schemaWriteOperationsInNewTransaction();
        Assert.assertEquals(Collections.singletonList(constraint), (Object)IteratorUtil.asCollection((Iterator)statement2.constraintsGetForLabelAndPropertyKey(this.labelId, this.propertyKeyId)));
        schemaState.assertNotCleared();
    }

    @Test
    public void shouldClearSchemaStateWhenConstraintIsCreated() throws Exception {
        SchemaStateCheck schemaState = new SchemaStateCheck().setUp();
        SchemaWriteOperations statement = this.schemaWriteOperationsInNewTransaction();
        statement.uniquenessConstraintCreate(this.labelId, this.propertyKeyId);
        this.commit();
        this.schemaWriteOperationsInNewTransaction();
        schemaState.assertCleared();
    }

    @Test
    public void shouldClearSchemaStateWhenConstraintIsDropped() throws Exception {
        SchemaWriteOperations statement = this.schemaWriteOperationsInNewTransaction();
        UniquenessConstraint constraint = statement.uniquenessConstraintCreate(this.labelId, this.propertyKeyId);
        this.commit();
        SchemaStateCheck schemaState = new SchemaStateCheck().setUp();
        statement = this.schemaWriteOperationsInNewTransaction();
        statement.constraintDrop(constraint);
        this.commit();
        this.schemaWriteOperationsInNewTransaction();
        schemaState.assertCleared();
    }

    @Test
    public void shouldCreateAnIndexToGoAlongWithAUniquenessConstraint() throws Exception {
        SchemaWriteOperations statement = this.schemaWriteOperationsInNewTransaction();
        statement.uniquenessConstraintCreate(this.labelId, this.propertyKeyId);
        this.commit();
        statement = this.schemaWriteOperationsInNewTransaction();
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new IndexDescriptor[]{new IndexDescriptor(this.labelId, this.propertyKeyId)}), (Object)IteratorUtil.asSet((Iterator)statement.uniqueIndexesGetAll()));
    }

    @Test
    public void shouldDropCreatedConstraintIndexWhenRollingBackConstraintCreation() throws Exception {
        SchemaWriteOperations statement = this.schemaWriteOperationsInNewTransaction();
        statement.uniquenessConstraintCreate(this.labelId, this.propertyKeyId);
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new IndexDescriptor[]{new IndexDescriptor(this.labelId, this.propertyKeyId)}), (Object)IteratorUtil.asSet((Iterator)statement.uniqueIndexesGetAll()));
        this.rollback();
        statement = this.schemaWriteOperationsInNewTransaction();
        Assert.assertEquals((Object)IteratorUtil.emptySetOf(IndexDescriptor.class), (Object)IteratorUtil.asSet((Iterator)statement.uniqueIndexesGetAll()));
        this.commit();
    }

    @Test
    public void shouldDropConstraintIndexWhenDroppingConstraint() throws Exception {
        SchemaWriteOperations statement = this.schemaWriteOperationsInNewTransaction();
        UniquenessConstraint constraint = statement.uniquenessConstraintCreate(this.labelId, this.propertyKeyId);
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new IndexDescriptor[]{new IndexDescriptor(this.labelId, this.propertyKeyId)}), (Object)IteratorUtil.asSet((Iterator)statement.uniqueIndexesGetAll()));
        this.commit();
        statement = this.schemaWriteOperationsInNewTransaction();
        statement.constraintDrop(constraint);
        this.commit();
        statement = this.schemaWriteOperationsInNewTransaction();
        Assert.assertEquals((Object)IteratorUtil.emptySetOf(IndexDescriptor.class), (Object)IteratorUtil.asSet((Iterator)statement.uniqueIndexesGetAll()));
        this.commit();
    }

    @Test
    public void shouldNotDropConstraintThatDoesNotExist() throws Exception {
        SchemaWriteOperations statement = this.schemaWriteOperationsInNewTransaction();
        try {
            statement.constraintDrop(new UniquenessConstraint(this.labelId, this.propertyKeyId));
            Assert.fail((String)"Should not have dropped constraint");
        }
        catch (DropConstraintFailureException e) {
            Assert.assertThat((Object)e.getCause(), (Matcher)CoreMatchers.instanceOf(NoSuchConstraintException.class));
        }
        this.commit();
        statement = this.schemaWriteOperationsInNewTransaction();
        Assert.assertEquals((Object)IteratorUtil.emptySetOf(IndexDescriptor.class), (Object)IteratorUtil.asSet((Iterator)statement.uniqueIndexesGetAll()));
        this.commit();
    }

    @Test
    public void committedConstraintRuleShouldCrossReferenceTheCorrespondingIndexRule() throws Exception {
        SchemaWriteOperations statement = this.schemaWriteOperationsInNewTransaction();
        statement.uniquenessConstraintCreate(this.labelId, this.propertyKeyId);
        this.commit();
        SchemaStorage schema = new SchemaStorage((RecordStore)this.neoStore().getSchemaStore());
        IndexRule indexRule = schema.indexRule(this.labelId, this.propertyKeyId);
        UniquenessConstraintRule constraintRule = schema.uniquenessConstraint(this.labelId, this.propertyKeyId);
        Assert.assertEquals((long)constraintRule.getId(), (long)indexRule.getOwningConstraint());
        Assert.assertEquals((long)indexRule.getId(), (long)constraintRule.getOwnedIndex());
    }

    @Test
    public void shouldNotLeaveAnyStateBehindAfterFailingToCreateConstraint() throws Exception {
        try (Transaction tx = this.db.beginTx();){
            Assert.assertEquals(Collections.emptyList(), (Object)IteratorUtil.asList((Iterable)this.db.schema().getConstraints()));
            Assert.assertEquals(Collections.emptyMap(), ConstraintsCreationIT.indexesWithState(this.db.schema()));
            this.db.createNode(new Label[]{DynamicLabel.label((String)"Foo")}).setProperty("bar", (Object)"baz");
            this.db.createNode(new Label[]{DynamicLabel.label((String)"Foo")}).setProperty("bar", (Object)"baz");
            tx.success();
        }
        try {
            tx = this.db.beginTx();
            var2_3 = null;
            try {
                this.db.schema().constraintFor(DynamicLabel.label((String)"Foo")).assertPropertyIsUnique("bar").create();
                tx.success();
                Assert.fail((String)"expected failure");
            }
            catch (Throwable x2) {
                var2_3 = x2;
                throw x2;
            }
            finally {
                if (tx != null) {
                    if (var2_3 != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable x2) {
                            var2_3.addSuppressed(x2);
                        }
                    } else {
                        tx.close();
                    }
                }
            }
        }
        catch (ConstraintViolationException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("Unable to create CONSTRAINT"));
        }
        tx = this.db.beginTx();
        var2_3 = null;
        try {
            Assert.assertEquals(Collections.emptyList(), (Object)IteratorUtil.asList((Iterable)this.db.schema().getConstraints()));
            Assert.assertEquals(Collections.emptyMap(), ConstraintsCreationIT.indexesWithState(this.db.schema()));
            tx.success();
        }
        catch (Throwable throwable) {
            var2_3 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var2_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable x2) {
                        var2_3.addSuppressed(x2);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void shouldBeAbleToResolveConflictsAndRecreateConstraintAfterFailingToCreateConstraintDueToConflict() throws Exception {
        Node node2;
        Node node1;
        try (Transaction tx = this.db.beginTx();){
            Assert.assertEquals(Collections.emptyList(), (Object)IteratorUtil.asList((Iterable)this.db.schema().getConstraints()));
            Assert.assertEquals(Collections.emptyMap(), ConstraintsCreationIT.indexesWithState(this.db.schema()));
            node1 = this.db.createNode(new Label[]{DynamicLabel.label((String)"Foo")});
            node1.setProperty("bar", (Object)"baz");
            node2 = this.db.createNode(new Label[]{DynamicLabel.label((String)"Foo")});
            node2.setProperty("bar", (Object)"baz");
            tx.success();
        }
        try {
            tx = this.db.beginTx();
            var4_3 = null;
            try {
                this.db.schema().constraintFor(DynamicLabel.label((String)"Foo")).assertPropertyIsUnique("bar").create();
                tx.success();
                Assert.fail((String)"expected failure");
            }
            catch (Throwable x2) {
                var4_3 = x2;
                throw x2;
            }
            finally {
                if (tx != null) {
                    if (var4_3 != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable x2) {
                            var4_3.addSuppressed(x2);
                        }
                    } else {
                        tx.close();
                    }
                }
            }
        }
        catch (ConstraintViolationException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("Unable to create CONSTRAINT"));
        }
        tx = this.db.beginTx();
        var4_3 = null;
        try {
            node1.delete();
            node2.delete();
            tx.success();
        }
        catch (Throwable x2) {
            var4_3 = x2;
            throw x2;
        }
        finally {
            if (tx != null) {
                if (var4_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable x2) {
                        var4_3.addSuppressed(x2);
                    }
                } else {
                    tx.close();
                }
            }
        }
        tx = this.db.beginTx();
        var4_3 = null;
        try {
            this.db.schema().constraintFor(DynamicLabel.label((String)"Foo")).assertPropertyIsUnique("bar").create();
            tx.success();
        }
        catch (Throwable throwable) {
            var4_3 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var4_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable x2) {
                        var4_3.addSuppressed(x2);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    private static Map<IndexDefinition, Schema.IndexState> indexesWithState(Schema schema) {
        HashMap<IndexDefinition, Schema.IndexState> result = new HashMap<IndexDefinition, Schema.IndexState>();
        for (IndexDefinition definition : schema.getIndexes()) {
            result.put(definition, schema.getIndexState(definition));
        }
        return result;
    }

    @Before
    public void createKeys() throws KernelException {
        SchemaWriteOperations statement = this.schemaWriteOperationsInNewTransaction();
        this.labelId = statement.labelGetOrCreateForName("Foo");
        this.propertyKeyId = statement.propertyKeyGetOrCreateForName("bar");
        this.commit();
    }

    private class SchemaStateCheck
    implements Function<String, Integer> {
        int invocationCount;
        private ReadOperations readOperations;

        private SchemaStateCheck() {
        }

        public Integer apply(String s) {
            ++this.invocationCount;
            return Integer.parseInt(s);
        }

        public SchemaStateCheck setUp() throws TransactionFailureException {
            this.readOperations = ConstraintsCreationIT.this.readOperationsInNewTransaction();
            this.checkState();
            ConstraintsCreationIT.this.commit();
            return this;
        }

        public void assertCleared() {
            int count = this.invocationCount;
            this.checkState();
            Assert.assertEquals((String)"schema state should have been cleared.", (long)(count + 1), (long)this.invocationCount);
        }

        public void assertNotCleared() {
            int count = this.invocationCount;
            this.checkState();
            Assert.assertEquals((String)"schema state should not have been cleared.", (long)count, (long)this.invocationCount);
        }

        private SchemaStateCheck checkState() {
            Assert.assertEquals((Object)7, (Object)this.readOperations.schemaStateGetOrCreate((Object)"7", (Function)this));
            return this;
        }
    }
}

