/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.integrationtest;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.kernel.api.DataWriteOperations;
import org.neo4j.kernel.api.ReadOperations;
import org.neo4j.kernel.api.StatementTokenNameLookup;
import org.neo4j.kernel.api.TokenNameLookup;
import org.neo4j.kernel.api.exceptions.KernelException;
import org.neo4j.kernel.api.exceptions.schema.UniqueConstraintViolationKernelException;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.impl.api.integrationtest.KernelIntegrationTest;

public class UniquenessConstraintValidationIT
extends KernelIntegrationTest {
    @Test
    public void shouldEnforceUniquenessConstraintOnSetProperty() throws Exception {
        this.constrainedNode("Label1", "key1", "value1");
        DataWriteOperations statement = this.dataWriteOperationsInNewTransaction();
        long node = this.createLabeledNode(statement, "Label1");
        try {
            statement.nodeSetProperty(node, Property.property((int)statement.propertyKeyGetOrCreateForName("key1"), (Object)"value1"));
            Assert.fail((String)"should have thrown exception");
        }
        catch (UniqueConstraintViolationKernelException e) {
            Assert.assertThat((Object)e.getUserMessage(this.tokenLookup(statement)), (Matcher)CoreMatchers.containsString((String)"\"key1\"=[value1]"));
        }
    }

    @Test
    public void roundingErrorsFromLongToDoubleShouldNotPreventTxFromCommitting() throws Exception {
        long propertyValue = 285414114323346805L;
        long firstNode = this.constrainedNode("label1", "key1", propertyValue);
        DataWriteOperations statement = this.dataWriteOperationsInNewTransaction();
        long node = this.createLabeledNode(statement, "label1");
        Assert.assertNotEquals((long)firstNode, (long)node);
        statement.nodeSetProperty(node, Property.property((int)statement.propertyKeyGetOrCreateForName("key1"), (Object)(++propertyValue)));
        this.commit();
    }

    @Test
    public void shouldEnforceUniquenessConstraintOnAddLabel() throws Exception {
        this.constrainedNode("Label1", "key1", "value1");
        DataWriteOperations statement = this.dataWriteOperationsInNewTransaction();
        long node = this.createNode(statement, "key1", "value1");
        try {
            statement.nodeAddLabel(node, statement.labelGetOrCreateForName("Label1"));
            Assert.fail((String)"should have thrown exception");
        }
        catch (UniqueConstraintViolationKernelException e) {
            Assert.assertThat((Object)e.getUserMessage(this.tokenLookup(statement)), (Matcher)CoreMatchers.containsString((String)"\"key1\"=[value1]"));
        }
    }

    @Test
    public void shouldAllowRemoveAndAddConflictingDataInOneTransaction_DeleteNode() throws Exception {
        long node = this.constrainedNode("Label1", "key1", "value1");
        DataWriteOperations statement = this.dataWriteOperationsInNewTransaction();
        statement.nodeDelete(node);
        this.createLabeledNode(statement, "Label1", "key1", "value1");
        this.commit();
    }

    private long createLabeledNode(DataWriteOperations statement, String label) throws KernelException {
        long node = statement.nodeCreate();
        statement.nodeAddLabel(node, statement.labelGetOrCreateForName(label));
        return node;
    }

    private long createNode(DataWriteOperations statement, String key, Object value) throws KernelException {
        long node = statement.nodeCreate();
        statement.nodeSetProperty(node, Property.property((int)statement.propertyKeyGetOrCreateForName(key), (Object)value));
        return node;
    }

    private long createLabeledNode(DataWriteOperations statement, String label, String key, Object value) throws KernelException {
        long node = this.createLabeledNode(statement, label);
        statement.nodeSetProperty(node, Property.property((int)statement.propertyKeyGetOrCreateForName(key), (Object)value));
        return node;
    }

    @Test
    public void shouldAllowRemoveAndAddConflictingDataInOneTransaction_RemoveLabel() throws Exception {
        long node = this.constrainedNode("Label1", "key1", "value1");
        DataWriteOperations statement = this.dataWriteOperationsInNewTransaction();
        statement.nodeRemoveLabel(node, statement.labelGetOrCreateForName("Label1"));
        this.createLabeledNode(statement, "Label1", "key1", "value1");
        this.commit();
    }

    @Test
    public void shouldAllowRemoveAndAddConflictingDataInOneTransaction_RemoveProperty() throws Exception {
        long node = this.constrainedNode("Label1", "key1", "value1");
        DataWriteOperations statement = this.dataWriteOperationsInNewTransaction();
        statement.nodeRemoveProperty(node, statement.propertyKeyGetForName("key1"));
        this.createLabeledNode(statement, "Label1", "key1", "value1");
        this.commit();
    }

    @Test
    public void shouldAllowRemoveAndAddConflictingDataInOneTransaction_ChangeProperty() throws Exception {
        long node = this.constrainedNode("Label1", "key1", "value1");
        DataWriteOperations statement = this.dataWriteOperationsInNewTransaction();
        statement.nodeSetProperty(node, Property.property((int)statement.propertyKeyGetOrCreateForName("key1"), (Object)"value2"));
        this.createLabeledNode(statement, "Label1", "key1", "value1");
        this.commit();
    }

    @Test
    public void shouldPreventConflictingDataInSameTransaction() throws Exception {
        this.constrainedNode("Label1", "key1", "value1");
        DataWriteOperations statement = this.dataWriteOperationsInNewTransaction();
        this.createLabeledNode(statement, "Label1", "key1", "value2");
        try {
            this.createLabeledNode(statement, "Label1", "key1", "value2");
            Assert.fail((String)"expected exception");
        }
        catch (UniqueConstraintViolationKernelException e) {
            Assert.assertThat((Object)e.getUserMessage(this.tokenLookup(statement)), (Matcher)CoreMatchers.containsString((String)"\"key1\"=[value2]"));
        }
    }

    private TokenNameLookup tokenLookup(DataWriteOperations statement) {
        return new StatementTokenNameLookup((ReadOperations)statement);
    }

    @Test
    public void shouldAllowNoopPropertyUpdate() throws KernelException {
        long node = this.constrainedNode("Label1", "key1", "value1");
        DataWriteOperations statement = this.dataWriteOperationsInNewTransaction();
        statement.nodeSetProperty(node, Property.property((int)statement.propertyKeyGetOrCreateForName("key1"), (Object)"value1"));
    }

    @Test
    public void shouldAllowNoopLabelUpdate() throws KernelException {
        long node = this.constrainedNode("Label1", "key1", "value1");
        DataWriteOperations statement = this.dataWriteOperationsInNewTransaction();
        statement.nodeAddLabel(node, statement.labelGetOrCreateForName("Label1"));
    }

    @Test
    public void shouldAllowCreationOfNonConflictingData() throws Exception {
        this.constrainedNode("Label1", "key1", "value1");
        DataWriteOperations statement = this.dataWriteOperationsInNewTransaction();
        this.createNode(statement, "key1", "value1");
        this.createLabeledNode(statement, "Label2", "key1", "value1");
        this.createLabeledNode(statement, "Label1", "key1", "value2");
        this.createLabeledNode(statement, "Label1", "key2", "value1");
        this.commit();
        statement = this.dataWriteOperationsInNewTransaction();
        Assert.assertEquals((String)"number of nodes", (long)5L, (long)PrimitiveLongCollections.count((PrimitiveLongIterator)statement.nodesGetAll()));
        this.rollback();
    }

    @Test
    public void unrelatedNodesWithSamePropertyShouldNotInterfereWithUniquenessCheck() throws Exception {
        this.createConstraint("Person", "id");
        DataWriteOperations statement = this.dataWriteOperationsInNewTransaction();
        long ourNode = this.createLabeledNode(statement, "Person", "id", 1);
        this.createLabeledNode(statement, "Item", "id", 2);
        this.commit();
        statement = this.dataWriteOperationsInNewTransaction();
        IndexDescriptor idx = statement.uniqueIndexGetForLabelAndPropertyKey(statement.labelGetForName("Person"), statement.propertyKeyGetForName("id"));
        this.createLabeledNode(statement, "Item", "id", 2);
        Assert.assertThat((Object)statement.nodeGetUniqueFromIndexLookup(idx, (Object)1), (Matcher)Matchers.equalTo((Object)ourNode));
    }

    @Test
    public void addingUniqueNodeWithUnrelatedValueShouldNotAffectLookup() throws Exception {
        this.createConstraint("Person", "id");
        DataWriteOperations statement = this.dataWriteOperationsInNewTransaction();
        long ourNode = this.createLabeledNode(statement, "Person", "id", 1);
        this.commit();
        statement = this.dataWriteOperationsInNewTransaction();
        IndexDescriptor idx = statement.uniqueIndexGetForLabelAndPropertyKey(statement.labelGetForName("Person"), statement.propertyKeyGetForName("id"));
        this.createLabeledNode(statement, "Person", "id", 2);
        Assert.assertThat((Object)statement.nodeGetUniqueFromIndexLookup(idx, (Object)1), (Matcher)Matchers.equalTo((Object)ourNode));
    }

    private long constrainedNode(String labelName, String propertyKey, Object propertyValue) throws KernelException {
        DataWriteOperations dataStatement = this.dataWriteOperationsInNewTransaction();
        int label = dataStatement.labelGetOrCreateForName(labelName);
        long node = dataStatement.nodeCreate();
        dataStatement.nodeAddLabel(node, label);
        int key = dataStatement.propertyKeyGetOrCreateForName(propertyKey);
        dataStatement.nodeSetProperty(node, Property.property((int)key, (Object)propertyValue));
        this.commit();
        this.createConstraint(labelName, propertyKey);
        return node;
    }

    private void createConstraint(String label, String propertyKey) throws KernelException {
        DataWriteOperations statement = this.dataWriteOperationsInNewTransaction();
        int labelId = statement.labelGetOrCreateForName(label);
        int propertyKeyId = statement.propertyKeyGetOrCreateForName(propertyKey);
        this.commit();
        statement = this.schemaWriteOperationsInNewTransaction();
        statement.uniquenessConstraintCreate(labelId, propertyKeyId);
        this.commit();
    }
}

