/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.cache;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.locks.LockSupport;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.Exceptions;
import org.neo4j.helpers.Function;
import org.neo4j.helpers.Pair;
import org.neo4j.helpers.Predicate;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.impl.api.store.PersistenceCache;
import org.neo4j.kernel.impl.cache.Cache;
import org.neo4j.kernel.impl.cache.CacheProvider;
import org.neo4j.kernel.impl.cache.CustomCacheProvider;
import org.neo4j.kernel.impl.cache.StrongReferenceCache;
import org.neo4j.kernel.impl.core.NodeImpl;
import org.neo4j.kernel.impl.core.RelationshipImpl;
import org.neo4j.kernel.impl.store.NeoStore;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.transaction.state.NeoStoreProvider;
import org.neo4j.test.Barrier;
import org.neo4j.test.DatabaseRule;
import org.neo4j.test.ImpermanentDatabaseRule;
import org.neo4j.test.NamedFunction;
import org.neo4j.test.RepeatRule;
import org.neo4j.test.ThreadingRule;
import org.neo4j.tooling.GlobalGraphOperations;

public class CacheRaceTest {
    private static final Predicate<StackTraceElement[]> PersistenceCache_apply = new Predicate<StackTraceElement[]>(){

        public boolean accept(StackTraceElement[] trace) {
            for (StackTraceElement element : trace) {
                if (!"apply".equals(element.getMethodName()) || !PersistenceCache.class.getName().equals(element.getClassName())) continue;
                return true;
            }
            return false;
        }
    };
    private final NodeCache nodeCache = new NodeCache();
    private final long seed = System.currentTimeMillis();
    private final Random random = new Random(this.seed);
    @Rule
    public final DatabaseRule db = new ImpermanentDatabaseRule(){

        @Override
        protected void configure(GraphDatabaseFactory factory) {
            factory.setCacheProviders(Arrays.asList(this.cacheProvider()));
        }

        @Override
        protected void configure(GraphDatabaseBuilder builder) {
            builder.setConfig(GraphDatabaseSettings.cache_type, "strong");
        }

        private CacheProvider cacheProvider() {
            return new CustomCacheProvider("strong", new Callable<Cache<NodeImpl>>(){

                @Override
                public Cache<NodeImpl> call() throws Exception {
                    return CacheRaceTest.this.nodeCache;
                }
            }, new Callable<Cache<RelationshipImpl>>(){

                @Override
                public Cache<RelationshipImpl> call() throws Exception {
                    return new StrongReferenceCache("RelationshipCache");
                }
            });
        }
    };
    @Rule
    public final ThreadingRule threading = new ThreadingRule();
    @Rule
    public final RepeatRule repeater = new RepeatRule();

    @Test
    public void shouldNotGetDuplicateRelationshipsForNewNode() throws Exception {
        GraphDatabaseService graphDb = this.db.getGraphDatabaseService();
        Barrier.Control committing = new Barrier.Control();
        Future node = this.threading.execute(this.createNode(committing), graphDb);
        committing.await();
        Barrier.Control updateCache = this.nodeCache.blockThread("create-node", PersistenceCache_apply);
        this.threading.threadBlockMonitor(Thread.currentThread(), new Release(updateCache));
        committing.release();
        updateCache.await();
        this.nodeCache.clear();
        List<String> before = CacheRaceTest.countRelationshipsOfAllNodes(graphDb);
        updateCache.release();
        node.get();
        List<String> after = CacheRaceTest.countRelationshipsOfAllNodes(graphDb);
        Assert.assertEquals((String)CacheRaceTest.join("\n\t", after), (long)before.size(), (long)after.size());
    }

    @Test
    public void shouldNotGetDuplicateRelationshipsForUpdatedNode() throws Exception {
        GraphDatabaseService graphDb = this.db.getGraphDatabaseService();
        Node node = (Node)this.createNode(Barrier.NONE).apply((Object)graphDb);
        Barrier.Control committing = new Barrier.Control();
        Future rel = this.threading.execute(this.addRelationship(committing), node);
        committing.await();
        Barrier.Control updateCache = this.nodeCache.blockThread("add-relationship", PersistenceCache_apply);
        this.threading.threadBlockMonitor(Thread.currentThread(), new Release(updateCache));
        committing.release();
        updateCache.await();
        this.nodeCache.clear();
        List<String> before = CacheRaceTest.countRelationshipsOfAllNodes(graphDb);
        updateCache.release();
        rel.get();
        List<String> after = CacheRaceTest.countRelationshipsOfAllNodes(graphDb);
        Assert.assertEquals((String)CacheRaceTest.join("\n\t", after), (long)before.size(), (long)after.size());
    }

    @RepeatRule.Repeat(times=10)
    @Test
    public void shouldNotCacheDuplicateRelationshipsStressTest() throws Exception {
        final GraphDatabaseAPI graphDb = this.db.getGraphDatabaseAPI();
        CountDownLatch prepareLatch = new CountDownLatch(2);
        CountDownLatch startSignal = new CountDownLatch(1);
        final Node node = this.createNode((GraphDatabaseService)graphDb);
        Object[] initialRels = this.createRelationships(graphDb, node, 1000, null);
        this.db.clearCache();
        ControlledThread reader = new ControlledThread("Reader", prepareLatch, startSignal, this.seed + 1L){

            @Override
            protected void perform() {
                try (Transaction tx = graphDb.beginTx();){
                    IteratorUtil.count((Iterable)node.getRelationships());
                    tx.success();
                }
                catch (NotFoundException notFoundException) {
                    // empty catch block
                }
            }
        };
        ControlledThread evictor = new ControlledThread("Evictor", prepareLatch, startSignal, this.seed + 2L){

            @Override
            protected void perform() {
                CacheRaceTest.this.db.clearCache();
            }
        };
        prepareLatch.await();
        Pair<Relationship[], Relationship[]> modification = this.modifyRelationships(graphDb, node, 100, startSignal);
        Object[] additionalRels = (Relationship[])modification.first();
        Object[] removedRels = (Relationship[])modification.other();
        reader.awaitCompletion();
        evictor.awaitCompletion();
        Object[] rels = null;
        try (Transaction tx = graphDb.beginTx();){
            try {
                rels = this.duplicateSafeCountRelationships(node);
                if (rels.length != initialRels.length + additionalRels.length - removedRels.length) {
                    throw new IllegalStateException("Relationship count mismatch");
                }
                tx.success();
            }
            catch (IllegalStateException e) {
                Assert.fail((String)(e.getMessage() + ":\n" + "  initial:    " + Arrays.toString(initialRels) + "\n" + "  additional: " + Arrays.toString(additionalRels) + "\n" + "  removed:    " + Arrays.toString(removedRels) + "\n" + (rels != null ? "  rels:       " + Arrays.toString(rels) + "\n" : "") + (rels != null ? "  missing:    " + Arrays.toString(this.missingRels((Relationship[])initialRels, (Relationship[])additionalRels, (Relationship[])removedRels, (Relationship[])rels)) + "\n" : "") + "  on-disk:\n" + this.onDiskChain(graphDb, node.getId()) + "\n" + "  seed:       " + this.seed));
            }
        }
    }

    private Relationship[] missingRels(Relationship[] initialRels, Relationship[] additionalRels, Relationship[] removedRels, Relationship[] rels) {
        HashSet<Relationship> set = new HashSet<Relationship>();
        set.addAll(Arrays.asList(initialRels));
        set.addAll(Arrays.asList(additionalRels));
        set.removeAll(Arrays.asList(removedRels));
        set.removeAll(Arrays.asList(rels));
        return set.toArray(new Relationship[set.size()]);
    }

    private String onDiskChain(GraphDatabaseAPI graphDb, long nodeId) {
        StringBuilder builder = new StringBuilder();
        NeoStore neoStore = (NeoStore)((NeoStoreProvider)graphDb.getDependencyResolver().resolveDependency(NeoStoreProvider.class)).evaluate();
        NodeRecord node = neoStore.getNodeStore().getRecord(nodeId);
        if (node.isDense()) {
            RelationshipGroupRecord group = neoStore.getRelationshipGroupStore().getRecord(node.getNextRel());
            do {
                builder.append("group " + group);
                builder.append("out:\n");
                this.printRelChain(builder, neoStore, nodeId, group.getFirstOut());
                builder.append("in:\n");
                this.printRelChain(builder, neoStore, nodeId, group.getFirstIn());
                builder.append("loop:\n");
                this.printRelChain(builder, neoStore, nodeId, group.getFirstLoop());
            } while ((group = group.getNext() != -1L ? neoStore.getRelationshipGroupStore().getRecord(group.getNext()) : null) != null);
        } else {
            this.printRelChain(builder, neoStore, nodeId, node.getNextRel());
        }
        return builder.toString();
    }

    private void printRelChain(StringBuilder builder, NeoStore access, long nodeId, long firstRelId) {
        long rel = firstRelId;
        while (rel != (long)Record.NO_NEXT_RELATIONSHIP.intValue()) {
            RelationshipRecord record = access.getRelationshipStore().getRecord(rel);
            builder.append(rel + "\t" + record + "\n");
            if (record.getFirstNode() == nodeId) {
                rel = record.getFirstNextRel();
                continue;
            }
            rel = record.getSecondNextRel();
        }
    }

    private Relationship[] duplicateSafeCountRelationships(Node node) {
        HashSet<Relationship> relationships = new HashSet<Relationship>();
        ArrayList<Relationship> result = new ArrayList<Relationship>();
        for (Relationship relationship : node.getRelationships()) {
            if (!relationships.add(relationship)) {
                throw new IllegalStateException("Spotted duplication relationship " + relationship);
            }
            result.add(relationship);
        }
        return result.toArray(new Relationship[result.size()]);
    }

    private Node createNode(GraphDatabaseService db) {
        try (Transaction tx = db.beginTx();){
            Node node = db.createNode();
            tx.success();
            Node node2 = node;
            return node2;
        }
    }

    private Relationship[] createRelationships(GraphDatabaseAPI graphDb, Node node, int relsBound, CountDownLatch startLatch) {
        try (Transaction tx = graphDb.beginTx();){
            Node other = graphDb.createNode();
            int nbrRels = this.random.nextInt(relsBound);
            Relationship[] result = new Relationship[nbrRels];
            for (int i = 0; i < nbrRels; ++i) {
                result[i] = this.createRandomRelationship(node, other);
            }
            tx.success();
            if (startLatch != null) {
                startLatch.countDown();
            }
            Relationship[] relationshipArray = result;
            return relationshipArray;
        }
    }

    private Relationship createRandomRelationship(Node node, Node other) {
        int dir = this.random.nextInt(3);
        DynamicRelationshipType type = DynamicRelationshipType.withName((String)("TYPE_" + this.random.nextInt(4)));
        Relationship rel = dir == 0 ? node.createRelationshipTo(other, (RelationshipType)type) : (dir == 1 ? other.createRelationshipTo(node, (RelationshipType)type) : node.createRelationshipTo(node, (RelationshipType)type));
        return rel;
    }

    private Pair<Relationship[], Relationship[]> modifyRelationships(GraphDatabaseAPI graphDb, Node node, int maxNumberOfChanges, CountDownLatch startLatch) {
        try (Transaction tx = graphDb.beginTx();){
            ArrayList<Relationship> createdRelationships = new ArrayList<Relationship>();
            ArrayList<Relationship> deletedRelationships = new ArrayList<Relationship>();
            Node other = graphDb.createNode();
            int changes = this.random.nextInt(maxNumberOfChanges);
            for (int i = 0; i < changes; ++i) {
                if (this.random.nextFloat() < 0.8f) {
                    createdRelationships.add(this.createRandomRelationship(node, other));
                    continue;
                }
                Relationship deletedRelationship = this.deleteRandomRelationship(node);
                if (deletedRelationship == null) continue;
                deletedRelationships.add(deletedRelationship);
            }
            tx.success();
            if (startLatch != null) {
                startLatch.countDown();
            }
            Pair pair = Pair.of((Object)createdRelationships.toArray(new Relationship[createdRelationships.size()]), (Object)deletedRelationships.toArray(new Relationship[deletedRelationships.size()]));
            return pair;
        }
    }

    private Relationship deleteRandomRelationship(Node node) {
        List rels = Iterables.toList((Iterable)node.getRelationships());
        if (!rels.isEmpty()) {
            Relationship relationship = (Relationship)rels.get(this.random.nextInt(rels.size()));
            relationship.delete();
            return relationship;
        }
        return null;
    }

    private Function<GraphDatabaseService, Node> createNode(final Barrier done) {
        return new NamedFunction<GraphDatabaseService, Node>("create-node"){

            public Node apply(GraphDatabaseService graphDb) {
                try (Transaction tx = graphDb.beginTx();){
                    Node node = graphDb.createNode();
                    node.createRelationshipTo(graphDb.createNode(), (RelationshipType)DynamicRelationshipType.withName((String)"FOO"));
                    tx.success();
                    done.reached();
                    Node node2 = node;
                    return node2;
                }
            }
        };
    }

    private Function<Node, Relationship> addRelationship(final Barrier done) {
        return new NamedFunction<Node, Relationship>("add-relationship"){

            public Relationship apply(Node node) {
                GraphDatabaseService graphDb = node.getGraphDatabase();
                try (Transaction tx = graphDb.beginTx();){
                    Relationship rel = node.createRelationshipTo(graphDb.createNode(), (RelationshipType)DynamicRelationshipType.withName((String)"FOO"));
                    tx.success();
                    done.reached();
                    Relationship relationship = rel;
                    return relationship;
                }
            }
        };
    }

    private static List<String> countRelationshipsOfAllNodes(GraphDatabaseService graphDb) {
        try (Transaction tx = graphDb.beginTx();){
            ArrayList<String> relationships = new ArrayList<String>();
            for (Node node : GlobalGraphOperations.at((GraphDatabaseService)graphDb).getAllNodes()) {
                for (Relationship relationship : node.getRelationships()) {
                    relationships.add(String.format("(%d)%s[%d]%s(%d)", node.getId(), node.equals(relationship.getStartNode()) ? "-" : "<-", relationship.getId(), node.equals(relationship.getEndNode()) ? "-" : "->", relationship.getOtherNode(node).getId()));
                }
            }
            tx.success();
            ArrayList<String> arrayList = relationships;
            return arrayList;
        }
    }

    private static String join(String sep, Collection<?> items) {
        StringBuilder result = new StringBuilder();
        for (Object item : items) {
            result.append(sep).append(item);
        }
        return result.toString();
    }

    private static class Conditional<CONDITION, VALUE>
    implements Function<CONDITION, VALUE> {
        private final Predicate<CONDITION> predicate;
        private final VALUE value;

        public Conditional(Predicate<CONDITION> predicate, VALUE value) {
            this.predicate = predicate;
            this.value = value;
        }

        public VALUE apply(CONDITION condition) {
            return this.predicate.accept(condition) ? (VALUE)this.value : null;
        }
    }

    private static class NodeCache
    extends StrongReferenceCache<NodeImpl> {
        private final Map<String, Function<StackTraceElement[], Barrier>> barriers = new ConcurrentHashMap<String, Function<StackTraceElement[], Barrier>>();

        public NodeCache() {
            super("NodeCache");
        }

        public Barrier.Control blockThread(String threadName, Predicate<StackTraceElement[]> tracePredicate) {
            Barrier.Control barrier = new Barrier.Control();
            this.barriers.put(threadName, new Conditional<StackTraceElement[], Barrier.Control>(tracePredicate, barrier));
            return barrier;
        }

        public NodeImpl get(long key) {
            Barrier barrier = this.barrierFor(Thread.currentThread());
            if (barrier != null) {
                barrier.reached();
            }
            return (NodeImpl)super.get(key);
        }

        private Barrier barrierFor(Thread thread) {
            Function<StackTraceElement[], Barrier> conditional = this.barriers.get(thread.getName());
            return conditional == null ? null : (Barrier)conditional.apply((Object)thread.getStackTrace());
        }
    }

    private static class Release
    implements Runnable {
        private final Barrier.Control barrierControl;

        public Release(Barrier.Control barrierControl) {
            this.barrierControl = barrierControl;
        }

        @Override
        public void run() {
            this.barrierControl.release();
        }
    }

    private static abstract class ControlledThread
    extends Thread {
        private final Random random;
        private final CountDownLatch prepareLatch;
        private final CountDownLatch startSignal;
        private volatile Exception error;

        ControlledThread(String name, CountDownLatch prepareLatch, CountDownLatch startSignal, long seed) {
            super(name);
            this.random = new Random(seed);
            this.prepareLatch = prepareLatch;
            this.startSignal = startSignal;
            this.start();
        }

        @Override
        public void run() {
            try {
                this.prepareLatch.countDown();
                this.startSignal.await();
                LockSupport.parkNanos(this.random.nextInt(20000000));
                this.perform();
            }
            catch (Exception e) {
                this.error = e;
                throw Exceptions.launderedException((Throwable)e);
            }
        }

        protected abstract void perform();

        protected void awaitCompletion() throws Exception {
            this.join();
            if (this.error != null) {
                throw this.error;
            }
        }
    }
}

