/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.cache;

import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.impl.MyRelTypes;
import org.neo4j.test.DatabaseRule;
import org.neo4j.test.ImpermanentDatabaseRule;
import org.neo4j.test.RepeatRule;

public class RelationshipChainPositionPoisoningTest {
    @Rule
    public final RepeatRule repeater = new RepeatRule();
    @Rule
    public final DatabaseRule db = new ImpermanentDatabaseRule(){

        @Override
        protected void configure(GraphDatabaseBuilder builder) {
            builder.setConfig(GraphDatabaseSettings.cache_type, "strong");
            builder.setConfig(GraphDatabaseSettings.relationship_grab_size, "2");
        }
    };

    @RepeatRule.Repeat(times=10)
    @Test
    public void shouldPatchNodeCacheWithCorrectRelationshipAfterTwoDeleted() throws Exception {
        Node node = this.createNode();
        Relationship[] rels = new Relationship[5];
        for (int i = 0; i < rels.length; ++i) {
            rels[i] = this.createRelationship(node);
        }
        this.db.clearCache();
        try (Transaction tx = this.db.beginTx();){
            node.getRelationships().iterator().next();
            rels[2].delete();
            rels[1].delete();
            tx.success();
        }
        tx = this.db.beginTx();
        var4_5 = null;
        try {
            Assert.assertEquals((long)3L, (long)IteratorUtil.count((Iterable)node.getRelationships()));
        }
        catch (Throwable throwable) {
            var4_5 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var4_5 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable x2) {
                        var4_5.addSuppressed(x2);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    private Relationship createRelationship(Node node) {
        try (Transaction tx = this.db.beginTx();){
            Relationship relationship = node.createRelationshipTo(this.db.createNode(), (RelationshipType)MyRelTypes.TEST);
            tx.success();
            Relationship relationship2 = relationship;
            return relationship2;
        }
    }

    private Node createNode() {
        try (Transaction tx = this.db.beginTx();){
            Node node = this.db.createNode();
            tx.success();
            Node node2 = node;
            return node2;
        }
    }
}

