/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.io.IOException;
import java.lang.reflect.Field;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.test.CleanupRule;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.impl.StaticLoggerBinder;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={StaticLoggerBinder.class})
public class LoggerFactoryIT {
    private final TemporaryFolder graphDbFolder = new TemporaryFolder();
    @Rule
    public final CleanupRule cleanup = new CleanupRule();

    @Before
    public void setupTempFolder() throws IOException {
        this.cleanup.add(new AutoCloseable(){

            @Override
            public void close() throws Exception {
                LoggerFactoryIT.this.graphDbFolder.delete();
            }
        });
        this.graphDbFolder.create();
    }

    @Test
    public void shouldFallbackToClassicLoggingServiceIfCustomStaticLoggerBinder() throws Exception {
        StaticLoggerBinder mockedInstance = (StaticLoggerBinder)PowerMockito.spy((Object)StaticLoggerBinder.getSingleton());
        PowerMockito.when((Object)mockedInstance.getLoggerFactory()).thenReturn((Object)new DummyLoggerFactory());
        PowerMockito.mockStatic(StaticLoggerBinder.class, (Class[])new Class[0]);
        PowerMockito.when((Object)StaticLoggerBinder.getSingleton()).thenReturn((Object)mockedInstance);
        GraphDatabaseService graphDatabaseService = this.cleanup.add(new TestGraphDatabaseFactory().newEmbeddedDatabase(this.graphDbFolder.getRoot().getAbsolutePath()));
        this.assertGraphDatabaseLoggingMatches("org.neo4j.kernel.logging.ClassicLoggingService", graphDatabaseService);
    }

    @Test
    public void shouldUseLogbackServiceWithStandardStaticLoggerBinder() throws Exception {
        GraphDatabaseService graphDatabaseService = this.cleanup.add(new TestGraphDatabaseFactory().newEmbeddedDatabase(this.graphDbFolder.getRoot().getAbsolutePath()));
        this.assertGraphDatabaseLoggingMatches("org.neo4j.kernel.logging.LogbackService", graphDatabaseService);
    }

    private void assertGraphDatabaseLoggingMatches(String expectedLoggingClassname, Object graphDatabaseService) {
        MatcherAssert.assertThat((Object)graphDatabaseService, (Matcher)Matchers.notNullValue());
        Object logging = this.getFieldValueByReflection(graphDatabaseService, "logging");
        MatcherAssert.assertThat((Object)logging, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((String)("gds.logging is not a " + expectedLoggingClassname + " instance"), (Object)logging.getClass().getName(), (Matcher)Matchers.is((Object)expectedLoggingClassname));
    }

    private Object getFieldValueByReflection(Object instance, String fieldName) {
        Field field = this.findFieldRecursively(instance.getClass(), fieldName);
        if (field == null) {
            throw new IllegalArgumentException("found no field '" + fieldName + "' in class " + instance.getClass() + " or its superclasses.");
        }
        try {
            field.setAccessible(true);
            return field.get(instance);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private Field findFieldRecursively(Class<? extends Object> clazz, String fieldName) {
        try {
            return clazz.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            return this.findFieldRecursively(clazz.getSuperclass(), fieldName);
        }
    }

    static class DummyLoggerFactory
    implements ILoggerFactory {
        DummyLoggerFactory() {
        }

        public Logger getLogger(String name) {
            return null;
        }
    }
}

