/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.neo4j.cursor.Cursor;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.kernel.api.ReadOperations;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.impl.api.RelationshipVisitor;
import org.neo4j.kernel.impl.core.NodeProxy;
import org.neo4j.kernel.impl.core.RelationshipProxy;

public class NodeProxySingleRelationshipTest {
    private static final long REL_ID = 1L;
    private static final RelationshipType loves = DynamicRelationshipType.withName((String)"LOVES");

    @Test
    public void shouldQuietlyIgnoreSingleDuplicateEntryWhenGetSingleRelationshipCalled() throws Exception {
        NodeProxy nodeImpl = this.mockNodeWithRels(1L, 1L);
        Relationship singleRelationship = nodeImpl.getSingleRelationship(loves, Direction.OUTGOING);
        junit.framework.Assert.assertNotNull((Object)singleRelationship);
    }

    @Test
    public void shouldThrowExceptionIfMultipleDifferentEntries() throws Exception {
        NodeProxy node = this.mockNodeWithRels(1L, 2L);
        try {
            node.getSingleRelationship(loves, Direction.OUTGOING);
            Assert.fail((String)"expected exception");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    @Test
    public void shouldThrowExceptionIfMultipleDifferentEntriesWithTwoOfThemBeingIdentical() throws Exception {
        NodeProxy node = this.mockNodeWithRels(1L, 1L, 2L, 2L);
        try {
            node.getSingleRelationship(loves, Direction.OUTGOING);
            Assert.fail();
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    private NodeProxy mockNodeWithRels(final long ... relIds) throws EntityNotFoundException {
        NodeProxy.NodeActions nodeActions = (NodeProxy.NodeActions)Mockito.mock(NodeProxy.NodeActions.class);
        final RelationshipProxy.RelationshipActions relActions = (RelationshipProxy.RelationshipActions)Mockito.mock(RelationshipProxy.RelationshipActions.class);
        Mockito.when((Object)nodeActions.newRelationshipProxy(Matchers.anyLong())).thenAnswer((Answer)new Answer<RelationshipProxy>(){

            public RelationshipProxy answer(InvocationOnMock invocation) throws Throwable {
                return new RelationshipProxy(relActions, ((Long)invocation.getArguments()[0]).longValue());
            }
        });
        Mockito.when((Object)nodeActions.newRelationshipProxy(Matchers.anyLong(), Matchers.anyLong(), Matchers.anyInt(), Matchers.anyLong())).then((Answer)new Answer<Relationship>(){

            public Relationship answer(InvocationOnMock invocation) throws Throwable {
                Long id = (Long)invocation.getArguments()[0];
                Long startNode = (Long)invocation.getArguments()[1];
                Integer type = (Integer)invocation.getArguments()[2];
                Long endNode = (Long)invocation.getArguments()[3];
                return new RelationshipProxy(relActions, id.longValue(), startNode.longValue(), type.intValue(), endNode.longValue());
            }
        });
        GraphDatabaseService gds = (GraphDatabaseService)Mockito.mock(GraphDatabaseService.class);
        Mockito.when((Object)gds.getRelationshipById(1L)).thenReturn(Mockito.mock(Relationship.class));
        Mockito.when((Object)gds.getRelationshipById(2L)).thenReturn(Mockito.mock(Relationship.class));
        Mockito.when((Object)nodeActions.getGraphDatabase()).thenReturn((Object)gds);
        NodeProxy nodeImpl = new NodeProxy(nodeActions, 1L);
        Statement stmt = (Statement)Mockito.mock(Statement.class);
        ReadOperations readOps = (ReadOperations)Mockito.mock(ReadOperations.class);
        Mockito.when((Object)stmt.readOperations()).thenReturn((Object)readOps);
        Mockito.when((Object)nodeActions.statement()).thenReturn((Object)stmt);
        Mockito.when((Object)readOps.relationshipTypeGetForName(loves.name())).thenReturn((Object)2);
        Mockito.when((Object)readOps.nodeGetRelationships(Matchers.eq((long)1L), (Direction)Matchers.eq((Object)Direction.OUTGOING), (int[])Matchers.eq((Object)new int[]{2}), (RelationshipVisitor)Matchers.any(RelationshipVisitor.class))).thenAnswer((Answer)new Answer<Cursor>(){

            public Cursor answer(InvocationOnMock invocation) throws Throwable {
                Object[] arguments = invocation.getArguments();
                final RelationshipVisitor visitor = (RelationshipVisitor)arguments[arguments.length - 1];
                return new Cursor(){
                    int pos;

                    public boolean next() {
                        if (this.pos < relIds.length) {
                            long relId = relIds[this.pos++];
                            visitor.visit(relId, 2, 1L, 10L * relId + 2L);
                            return true;
                        }
                        return false;
                    }

                    public void reset() {
                        throw new UnsupportedOperationException("not implemented");
                    }

                    public void close() {
                    }
                };
            }
        });
        return nodeImpl;
    }
}

