/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.neo4j.helpers.Pair;
import org.neo4j.helpers.Triplet;
import org.neo4j.kernel.impl.cache.Cache;
import org.neo4j.kernel.impl.core.NodeImpl;
import org.neo4j.kernel.impl.core.RelationshipImpl;
import org.neo4j.kernel.impl.core.RelationshipLoader;
import org.neo4j.kernel.impl.core.RelationshipLoadingPosition;
import org.neo4j.kernel.impl.core.SingleChainPosition;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.transaction.state.RelationshipChainLoader;
import org.neo4j.kernel.impl.util.RelIdArray;

public class RelationshipLoaderTest {
    @Test
    public void shouldPopulateCacheIfLoadedRelIsNotInCache() throws Exception {
        long fromDiskRelId = 12L;
        Cache relCache = (Cache)Mockito.mock(Cache.class);
        NodeImpl node = new NodeImpl(1337L);
        HashMap<RelIdArray.DirectionWrapper, List<Object>> relsFromDisk = new HashMap<RelIdArray.DirectionWrapper, List<Object>>();
        relsFromDisk.put(RelIdArray.DirectionWrapper.OUTGOING, Arrays.asList(new RelationshipRecord(fromDiskRelId)));
        relsFromDisk.put(RelIdArray.DirectionWrapper.INCOMING, Collections.emptyList());
        Pair moreRelationships = Pair.of(relsFromDisk, (Object)new SingleChainPosition(1L));
        RelationshipChainLoader chainLoader = (RelationshipChainLoader)Mockito.mock(RelationshipChainLoader.class);
        Mockito.when((Object)chainLoader.getMoreRelationships(Matchers.eq((long)1337L), (RelationshipLoadingPosition)Matchers.any(RelationshipLoadingPosition.class), (RelIdArray.DirectionWrapper)Matchers.any(RelIdArray.DirectionWrapper.class), (int[])Matchers.any(int[].class))).thenReturn((Object)moreRelationships);
        RelationshipLoader loader = new RelationshipLoader(relCache, chainLoader);
        Triplet result = loader.getMoreRelationships(node, RelIdArray.DirectionWrapper.BOTH, new int[0]);
        List relsThatWereNotInCache = (List)result.second();
        Assert.assertThat((Object)relsThatWereNotInCache.size(), (Matcher)org.hamcrest.Matchers.equalTo((Object)1));
        Assert.assertThat((Object)((RelationshipImpl)relsThatWereNotInCache.get(0)).getId(), (Matcher)org.hamcrest.Matchers.equalTo((Object)fromDiskRelId));
    }
}

