/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.Arrays;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.graphdb.DatabaseShutdownException;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.NotInTransactionException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.impl.MyRelTypes;
import org.neo4j.test.TestGraphDatabaseFactory;

public class TestNeo4jApiExceptions {
    private Transaction tx;
    private GraphDatabaseService graph;

    @Test
    public void testNotInTransactionException() {
        Node node1 = this.graph.createNode();
        node1.setProperty("test", (Object)1);
        Node node2 = this.graph.createNode();
        Node node3 = this.graph.createNode();
        Relationship rel = node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST);
        rel.setProperty("test", (Object)11);
        this.commit();
        try {
            this.graph.createNode();
            Assert.fail((String)"Create node with no transaction should throw exception");
        }
        catch (NotInTransactionException e) {
            // empty catch block
        }
        try {
            node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST);
            Assert.fail((String)"Create relationship with no transaction should throw exception");
        }
        catch (NotInTransactionException e) {
            // empty catch block
        }
        try {
            node1.setProperty("test", (Object)2);
            Assert.fail((String)"Set property with no transaction should throw exception");
        }
        catch (NotInTransactionException e) {
            // empty catch block
        }
        try {
            rel.setProperty("test", (Object)22);
            Assert.fail((String)"Set property with no transaction should throw exception");
        }
        catch (NotInTransactionException e) {
            // empty catch block
        }
        try {
            node3.delete();
            Assert.fail((String)"Delete node with no transaction should throw exception");
        }
        catch (NotInTransactionException e) {
            // empty catch block
        }
        try {
            rel.delete();
            Assert.fail((String)"Delete relationship with no transaction should throw exception");
        }
        catch (NotInTransactionException e) {
            // empty catch block
        }
        this.newTransaction();
        Assert.assertEquals((Object)node1.getProperty("test"), (Object)1);
        Assert.assertEquals((Object)rel.getProperty("test"), (Object)11);
        Assert.assertEquals((Object)rel, (Object)node1.getSingleRelationship((RelationshipType)MyRelTypes.TEST, Direction.OUTGOING));
        node1.delete();
        node2.delete();
        rel.delete();
        node3.delete();
        this.rollback();
    }

    @Test
    public void testNotFoundException() {
        Node node1 = this.graph.createNode();
        Node node2 = this.graph.createNode();
        Relationship rel = node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST);
        long nodeId = node1.getId();
        long relId = rel.getId();
        rel.delete();
        node2.delete();
        node1.delete();
        this.newTransaction();
        try {
            this.graph.getNodeById(nodeId);
            Assert.fail((String)"Get node by id on deleted node should throw exception");
        }
        catch (NotFoundException e) {
            // empty catch block
        }
        try {
            this.graph.getRelationshipById(relId);
            Assert.fail((String)"Get relationship by id on deleted node should throw exception");
        }
        catch (NotFoundException e) {
            // empty catch block
        }
        this.rollback();
    }

    @Test
    public void shouldGiveNiceErrorWhenShutdownKernelApi() {
        GraphDatabaseService graphDb = this.graph;
        Node node = graphDb.createNode();
        this.commit();
        graphDb.shutdown();
        try {
            Arrays.asList(node.getLabels().iterator());
            Assert.fail((String)"Did not get a nice exception");
        }
        catch (DatabaseShutdownException databaseShutdownException) {
            // empty catch block
        }
    }

    @Test
    public void shouldGiveNiceErrorWhenShutdownLegacy() {
        GraphDatabaseService graphDb = this.graph;
        Node node = graphDb.createNode();
        this.commit();
        graphDb.shutdown();
        try {
            node.getRelationships();
            Assert.fail((String)"Did not get a nice exception");
        }
        catch (DatabaseShutdownException e) {
            // empty catch block
        }
        try {
            graphDb.createNode();
            Assert.fail((String)"Create node did not produce expected error");
        }
        catch (DatabaseShutdownException databaseShutdownException) {
            // empty catch block
        }
    }

    private void newTransaction() {
        if (this.tx != null) {
            this.tx.success();
            this.tx.close();
        }
        this.tx = this.graph.beginTx();
    }

    public void commit() {
        if (this.tx != null) {
            this.tx.success();
            this.tx.close();
            this.tx = null;
        }
    }

    public void rollback() {
        if (this.tx != null) {
            this.tx.close();
            this.tx = null;
        }
    }

    @Before
    public void init() {
        this.graph = new TestGraphDatabaseFactory().newImpermanentDatabase();
        this.newTransaction();
    }

    @After
    public void cleanUp() {
        this.rollback();
        this.graph.shutdown();
    }
}

