/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.lang.reflect.Array;
import java.util.Arrays;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.graphdb.Node;
import org.neo4j.helpers.ArrayUtil;
import org.neo4j.helpers.ObjectUtil;
import org.neo4j.kernel.impl.AbstractNeo4jTestCase;

public class TestPropertyTypes
extends AbstractNeo4jTestCase {
    private Node node1 = null;

    @Before
    public void createInitialNode() {
        this.node1 = this.getGraphDb().createNode();
    }

    @After
    public void deleteInitialNode() {
        this.node1.delete();
    }

    @Test
    public void testDoubleType() {
        Double dValue = new Double(45.678);
        String key = "testdouble";
        this.node1.setProperty(key, (Object)dValue);
        this.newTransaction();
        this.clearCache();
        Double propertyValue = null;
        propertyValue = (Double)this.node1.getProperty(key);
        Assert.assertEquals((Object)dValue, (Object)propertyValue);
        dValue = new Double(56784.3243);
        this.node1.setProperty(key, (Object)dValue);
        this.newTransaction();
        this.clearCache();
        propertyValue = (Double)this.node1.getProperty(key);
        Assert.assertEquals((Object)dValue, (Object)propertyValue);
        this.node1.removeProperty(key);
        this.newTransaction();
        this.clearCache();
        Assert.assertTrue((!this.node1.hasProperty(key) ? 1 : 0) != 0);
    }

    @Test
    public void testFloatType() {
        Float fValue = new Float(45.678f);
        String key = "testfloat";
        this.node1.setProperty(key, (Object)fValue);
        this.newTransaction();
        this.clearCache();
        Float propertyValue = null;
        propertyValue = (Float)this.node1.getProperty(key);
        Assert.assertEquals((Object)fValue, (Object)propertyValue);
        fValue = new Float(5684.324f);
        this.node1.setProperty(key, (Object)fValue);
        this.newTransaction();
        this.clearCache();
        propertyValue = (Float)this.node1.getProperty(key);
        Assert.assertEquals((Object)fValue, (Object)propertyValue);
        this.node1.removeProperty(key);
        this.newTransaction();
        this.clearCache();
        Assert.assertTrue((!this.node1.hasProperty(key) ? 1 : 0) != 0);
    }

    @Test
    public void testLongType() {
        long time = System.currentTimeMillis();
        Long lValue = new Long(time);
        String key = "testlong";
        this.node1.setProperty(key, (Object)lValue);
        this.newTransaction();
        this.clearCache();
        Long propertyValue = null;
        propertyValue = (Long)this.node1.getProperty(key);
        Assert.assertEquals((Object)lValue, (Object)propertyValue);
        lValue = new Long(System.currentTimeMillis());
        this.node1.setProperty(key, (Object)lValue);
        this.newTransaction();
        this.clearCache();
        propertyValue = (Long)this.node1.getProperty(key);
        Assert.assertEquals((Object)lValue, (Object)propertyValue);
        this.node1.removeProperty(key);
        this.newTransaction();
        this.clearCache();
        Assert.assertTrue((!this.node1.hasProperty(key) ? 1 : 0) != 0);
        this.node1.setProperty("other", (Object)123L);
        Assert.assertEquals((Object)123L, (Object)this.node1.getProperty("other"));
        this.newTransaction();
        this.clearCache();
        Assert.assertEquals((Object)123L, (Object)this.node1.getProperty("other"));
    }

    @Test
    public void testIntType() {
        int time = (int)System.currentTimeMillis();
        Integer iValue = new Integer(time);
        String key = "testing";
        this.node1.setProperty(key, (Object)iValue);
        this.newTransaction();
        this.clearCache();
        Integer propertyValue = null;
        propertyValue = (Integer)this.node1.getProperty(key);
        Assert.assertEquals((Object)iValue, (Object)propertyValue);
        iValue = new Integer((int)System.currentTimeMillis());
        this.node1.setProperty(key, (Object)iValue);
        this.newTransaction();
        this.clearCache();
        propertyValue = (Integer)this.node1.getProperty(key);
        Assert.assertEquals((Object)iValue, (Object)propertyValue);
        this.node1.removeProperty(key);
        this.newTransaction();
        this.clearCache();
        Assert.assertTrue((!this.node1.hasProperty(key) ? 1 : 0) != 0);
        this.node1.setProperty("other", (Object)123L);
        Assert.assertEquals((Object)123L, (Object)this.node1.getProperty("other"));
        this.newTransaction();
        this.clearCache();
        Assert.assertEquals((Object)123L, (Object)this.node1.getProperty("other"));
    }

    @Test
    public void testByteType() {
        byte b = -79;
        Byte bValue = new Byte(b);
        String key = "testbyte";
        this.node1.setProperty(key, (Object)bValue);
        this.newTransaction();
        this.clearCache();
        Byte propertyValue = null;
        propertyValue = (Byte)this.node1.getProperty(key);
        Assert.assertEquals((Object)bValue, (Object)propertyValue);
        bValue = new Byte(-56);
        this.node1.setProperty(key, (Object)bValue);
        this.newTransaction();
        this.clearCache();
        propertyValue = (Byte)this.node1.getProperty(key);
        Assert.assertEquals((Object)bValue, (Object)propertyValue);
        this.node1.removeProperty(key);
        this.newTransaction();
        this.clearCache();
        Assert.assertTrue((!this.node1.hasProperty(key) ? 1 : 0) != 0);
    }

    @Test
    public void testShortType() {
        short value = 453;
        Short sValue = new Short(value);
        String key = "testshort";
        this.node1.setProperty(key, (Object)sValue);
        this.newTransaction();
        this.clearCache();
        Short propertyValue = null;
        propertyValue = (Short)this.node1.getProperty(key);
        Assert.assertEquals((Object)sValue, (Object)propertyValue);
        sValue = new Short(5335);
        this.node1.setProperty(key, (Object)sValue);
        this.newTransaction();
        this.clearCache();
        propertyValue = (Short)this.node1.getProperty(key);
        Assert.assertEquals((Object)sValue, (Object)propertyValue);
        this.node1.removeProperty(key);
        this.newTransaction();
        this.clearCache();
        Assert.assertTrue((!this.node1.hasProperty(key) ? 1 : 0) != 0);
    }

    @Test
    public void testCharType() {
        char c = 'c';
        Character cValue = new Character(c);
        String key = "testchar";
        this.node1.setProperty(key, (Object)cValue);
        this.newTransaction();
        this.clearCache();
        Character propertyValue = null;
        propertyValue = (Character)this.node1.getProperty(key);
        Assert.assertEquals((Object)cValue, (Object)propertyValue);
        cValue = new Character('d');
        this.node1.setProperty(key, (Object)cValue);
        this.newTransaction();
        this.clearCache();
        propertyValue = (Character)this.node1.getProperty(key);
        Assert.assertEquals((Object)cValue, (Object)propertyValue);
        this.node1.removeProperty(key);
        this.newTransaction();
        this.clearCache();
        Assert.assertTrue((!this.node1.hasProperty(key) ? 1 : 0) != 0);
    }

    @Test
    public void testBooleanType() {
        boolean value = true;
        Boolean bValue = new Boolean(value);
        String key = "testbool";
        this.node1.setProperty(key, (Object)bValue);
        this.newTransaction();
        this.clearCache();
        Boolean propertyValue = null;
        propertyValue = (Boolean)this.node1.getProperty(key);
        Assert.assertEquals((Object)bValue, (Object)propertyValue);
        bValue = new Boolean(false);
        this.node1.setProperty(key, (Object)bValue);
        this.newTransaction();
        this.clearCache();
        propertyValue = (Boolean)this.node1.getProperty(key);
        Assert.assertEquals((Object)bValue, (Object)propertyValue);
        this.node1.removeProperty(key);
        this.newTransaction();
        this.clearCache();
        Assert.assertTrue((!this.node1.hasProperty(key) ? 1 : 0) != 0);
    }

    @Test
    public void testIntArray() {
        int i;
        int[] array1 = new int[]{1, 2, 3, 4, 5};
        Integer[] array2 = new Integer[]{6, 7, 8};
        String key = "testintarray";
        this.node1.setProperty(key, (Object)array1);
        this.newTransaction();
        this.clearCache();
        int[] propertyValue = null;
        propertyValue = (int[])this.node1.getProperty(key);
        Assert.assertEquals((long)array1.length, (long)propertyValue.length);
        for (i = 0; i < array1.length; ++i) {
            Assert.assertEquals((long)array1[i], (long)propertyValue[i]);
        }
        this.node1.setProperty(key, (Object)array2);
        this.newTransaction();
        this.clearCache();
        propertyValue = (int[])this.node1.getProperty(key);
        Assert.assertEquals((long)array2.length, (long)propertyValue.length);
        for (i = 0; i < array2.length; ++i) {
            Assert.assertEquals((Object)array2[i], (Object)new Integer(propertyValue[i]));
        }
        this.node1.removeProperty(key);
        this.newTransaction();
        this.clearCache();
        Assert.assertTrue((!this.node1.hasProperty(key) ? 1 : 0) != 0);
    }

    @Test
    public void testShortArray() {
        int i;
        short[] array1 = new short[]{1, 2, 3, 4, 5};
        Short[] array2 = new Short[]{(short)6, (short)7, (short)8};
        String key = "testintarray";
        this.node1.setProperty(key, (Object)array1);
        this.newTransaction();
        this.clearCache();
        short[] propertyValue = null;
        propertyValue = (short[])this.node1.getProperty(key);
        Assert.assertEquals((long)array1.length, (long)propertyValue.length);
        for (i = 0; i < array1.length; ++i) {
            Assert.assertEquals((long)array1[i], (long)propertyValue[i]);
        }
        this.node1.setProperty(key, (Object)array2);
        this.newTransaction();
        this.clearCache();
        propertyValue = (short[])this.node1.getProperty(key);
        Assert.assertEquals((long)array2.length, (long)propertyValue.length);
        for (i = 0; i < array2.length; ++i) {
            Assert.assertEquals((Object)array2[i], (Object)new Short(propertyValue[i]));
        }
        this.node1.removeProperty(key);
        this.newTransaction();
        this.clearCache();
        Assert.assertTrue((!this.node1.hasProperty(key) ? 1 : 0) != 0);
    }

    @Test
    public void testStringArray() {
        int i;
        String[] array1 = new String[]{"a", "b", "c", "d", "e"};
        String[] array2 = new String[]{"ff", "gg", "hh"};
        String key = "teststringarray";
        this.node1.setProperty(key, (Object)array1);
        this.newTransaction();
        this.clearCache();
        String[] propertyValue = null;
        propertyValue = (String[])this.node1.getProperty(key);
        Assert.assertEquals((long)array1.length, (long)propertyValue.length);
        for (i = 0; i < array1.length; ++i) {
            Assert.assertEquals((Object)array1[i], (Object)propertyValue[i]);
        }
        this.node1.setProperty(key, (Object)array2);
        this.newTransaction();
        this.clearCache();
        propertyValue = (String[])this.node1.getProperty(key);
        Assert.assertEquals((long)array2.length, (long)propertyValue.length);
        for (i = 0; i < array2.length; ++i) {
            Assert.assertEquals((Object)array2[i], (Object)propertyValue[i]);
        }
        this.node1.removeProperty(key);
        this.newTransaction();
        this.clearCache();
        Assert.assertTrue((!this.node1.hasProperty(key) ? 1 : 0) != 0);
    }

    @Test
    public void testBooleanArray() {
        int i;
        boolean[] array1 = new boolean[]{true, false, true, false, true};
        Boolean[] array2 = new Boolean[]{false, true, false};
        String key = "testboolarray";
        this.node1.setProperty(key, (Object)array1);
        this.newTransaction();
        this.clearCache();
        boolean[] propertyValue = null;
        propertyValue = (boolean[])this.node1.getProperty(key);
        Assert.assertEquals((long)array1.length, (long)propertyValue.length);
        for (i = 0; i < array1.length; ++i) {
            Assert.assertEquals((Object)array1[i], (Object)propertyValue[i]);
        }
        this.node1.setProperty(key, (Object)array2);
        this.newTransaction();
        this.clearCache();
        propertyValue = (boolean[])this.node1.getProperty(key);
        Assert.assertEquals((long)array2.length, (long)propertyValue.length);
        for (i = 0; i < array2.length; ++i) {
            Assert.assertEquals((Object)array2[i], (Object)new Boolean(propertyValue[i]));
        }
        this.node1.removeProperty(key);
        this.newTransaction();
        this.clearCache();
        Assert.assertTrue((!this.node1.hasProperty(key) ? 1 : 0) != 0);
    }

    @Test
    public void testDoubleArray() {
        int i;
        double[] array1 = new double[]{1.0, 2.0, 3.0, 4.0, 5.0};
        Double[] array2 = new Double[]{6.0, 7.0, 8.0};
        String key = "testdoublearray";
        this.node1.setProperty(key, (Object)array1);
        this.newTransaction();
        this.clearCache();
        double[] propertyValue = null;
        propertyValue = (double[])this.node1.getProperty(key);
        Assert.assertEquals((long)array1.length, (long)propertyValue.length);
        for (i = 0; i < array1.length; ++i) {
            Assert.assertEquals((double)array1[i], (double)propertyValue[i], (double)0.0);
        }
        this.node1.setProperty(key, (Object)array2);
        this.newTransaction();
        this.clearCache();
        propertyValue = (double[])this.node1.getProperty(key);
        Assert.assertEquals((long)array2.length, (long)propertyValue.length);
        for (i = 0; i < array2.length; ++i) {
            Assert.assertEquals((Object)array2[i], (Object)new Double(propertyValue[i]));
        }
        this.node1.removeProperty(key);
        this.newTransaction();
        this.clearCache();
        Assert.assertTrue((!this.node1.hasProperty(key) ? 1 : 0) != 0);
    }

    @Test
    public void testFloatArray() {
        int i;
        float[] array1 = new float[]{1.0f, 2.0f, 3.0f, 4.0f, 5.0f};
        Float[] array2 = new Float[]{Float.valueOf(6.0f), Float.valueOf(7.0f), Float.valueOf(8.0f)};
        String key = "testfloatarray";
        this.node1.setProperty(key, (Object)array1);
        this.newTransaction();
        this.clearCache();
        float[] propertyValue = null;
        propertyValue = (float[])this.node1.getProperty(key);
        Assert.assertEquals((long)array1.length, (long)propertyValue.length);
        for (i = 0; i < array1.length; ++i) {
            Assert.assertEquals((double)array1[i], (double)propertyValue[i], (double)0.0);
        }
        this.node1.setProperty(key, (Object)array2);
        this.newTransaction();
        this.clearCache();
        propertyValue = (float[])this.node1.getProperty(key);
        Assert.assertEquals((long)array2.length, (long)propertyValue.length);
        for (i = 0; i < array2.length; ++i) {
            Assert.assertEquals((Object)array2[i], (Object)new Float(propertyValue[i]));
        }
        this.node1.removeProperty(key);
        this.newTransaction();
        this.clearCache();
        Assert.assertTrue((!this.node1.hasProperty(key) ? 1 : 0) != 0);
    }

    @Test
    public void testLongArray() {
        int i;
        long[] array1 = new long[]{1L, 2L, 3L, 4L, 5L};
        Long[] array2 = new Long[]{6L, 7L, 8L};
        String key = "testlongarray";
        this.node1.setProperty(key, (Object)array1);
        this.newTransaction();
        this.clearCache();
        long[] propertyValue = null;
        propertyValue = (long[])this.node1.getProperty(key);
        Assert.assertEquals((long)array1.length, (long)propertyValue.length);
        for (i = 0; i < array1.length; ++i) {
            Assert.assertEquals((long)array1[i], (long)propertyValue[i]);
        }
        this.node1.setProperty(key, (Object)array2);
        this.newTransaction();
        this.clearCache();
        propertyValue = (long[])this.node1.getProperty(key);
        Assert.assertEquals((long)array2.length, (long)propertyValue.length);
        for (i = 0; i < array2.length; ++i) {
            Assert.assertEquals((Object)array2[i], (Object)new Long(propertyValue[i]));
        }
        this.node1.removeProperty(key);
        this.newTransaction();
        this.clearCache();
        Assert.assertTrue((!this.node1.hasProperty(key) ? 1 : 0) != 0);
    }

    @Test
    public void testByteArray() {
        int i;
        byte[] array1 = new byte[]{1, 2, 3, 4, 5};
        Byte[] array2 = new Byte[]{(byte)6, (byte)7, (byte)8};
        String key = "testbytearray";
        this.node1.setProperty(key, (Object)array1);
        this.newTransaction();
        this.clearCache();
        byte[] propertyValue = null;
        propertyValue = (byte[])this.node1.getProperty(key);
        Assert.assertEquals((long)array1.length, (long)propertyValue.length);
        for (i = 0; i < array1.length; ++i) {
            Assert.assertEquals((long)array1[i], (long)propertyValue[i]);
        }
        this.node1.setProperty(key, (Object)array2);
        this.newTransaction();
        this.clearCache();
        propertyValue = (byte[])this.node1.getProperty(key);
        Assert.assertEquals((long)array2.length, (long)propertyValue.length);
        for (i = 0; i < array2.length; ++i) {
            Assert.assertEquals((Object)array2[i], (Object)new Byte(propertyValue[i]));
        }
        this.node1.removeProperty(key);
        this.newTransaction();
        this.clearCache();
        Assert.assertTrue((!this.node1.hasProperty(key) ? 1 : 0) != 0);
    }

    @Test
    public void testCharArray() {
        int i;
        char[] array1 = new char[]{'1', '2', '3', '4', '5'};
        Character[] array2 = new Character[]{Character.valueOf('6'), Character.valueOf('7'), Character.valueOf('8')};
        String key = "testchararray";
        this.node1.setProperty(key, (Object)array1);
        this.newTransaction();
        this.clearCache();
        char[] propertyValue = null;
        propertyValue = (char[])this.node1.getProperty(key);
        Assert.assertEquals((long)array1.length, (long)propertyValue.length);
        for (i = 0; i < array1.length; ++i) {
            Assert.assertEquals((long)array1[i], (long)propertyValue[i]);
        }
        this.node1.setProperty(key, (Object)array2);
        this.newTransaction();
        this.clearCache();
        propertyValue = (char[])this.node1.getProperty(key);
        Assert.assertEquals((long)array2.length, (long)propertyValue.length);
        for (i = 0; i < array2.length; ++i) {
            Assert.assertEquals((Object)array2[i], (Object)new Character(propertyValue[i]));
        }
        this.node1.removeProperty(key);
        this.newTransaction();
        this.clearCache();
        Assert.assertTrue((!this.node1.hasProperty(key) ? 1 : 0) != 0);
    }

    @Test
    public void testEmptyString() throws Exception {
        Node node = this.getGraphDb().createNode();
        node.setProperty("1", (Object)2);
        node.setProperty("2", (Object)"");
        node.setProperty("3", (Object)"");
        this.newTransaction();
        this.clearCache();
        Assert.assertEquals((Object)2, (Object)node.getProperty("1"));
        Assert.assertEquals((Object)"", (Object)node.getProperty("2"));
        Assert.assertEquals((Object)"", (Object)node.getProperty("3"));
    }

    @Test
    public void shouldNotBeAbleToPoisonBooleanArrayProperty() throws Exception {
        this.shouldNotBeAbleToPoisonArrayProperty(new boolean[]{false, false, false}, true);
    }

    @Test
    public void shouldNotBeAbleToPoisonByteArrayProperty() throws Exception {
        this.shouldNotBeAbleToPoisonArrayProperty(new byte[]{0, 0, 0}, (byte)1);
    }

    @Test
    public void shouldNotBeAbleToPoisonShortArrayProperty() throws Exception {
        this.shouldNotBeAbleToPoisonArrayProperty(new short[]{0, 0, 0}, (short)1);
    }

    @Test
    public void shouldNotBeAbleToPoisonIntArrayProperty() throws Exception {
        this.shouldNotBeAbleToPoisonArrayProperty(new int[]{0, 0, 0}, 1);
    }

    @Test
    public void shouldNotBeAbleToPoisonLongArrayProperty() throws Exception {
        this.shouldNotBeAbleToPoisonArrayProperty(new long[]{0L, 0L, 0L}, 1L);
    }

    @Test
    public void shouldNotBeAbleToPoisonFloatArrayProperty() throws Exception {
        this.shouldNotBeAbleToPoisonArrayProperty(new float[]{0.0f, 0.0f, 0.0f}, Float.valueOf(1.0f));
    }

    @Test
    public void shouldNotBeAbleToPoisonDoubleArrayProperty() throws Exception {
        this.shouldNotBeAbleToPoisonArrayProperty(new double[]{0.0, 0.0, 0.0}, 1.0);
    }

    @Test
    public void shouldNotBeAbleToPoisonCharArrayProperty() throws Exception {
        this.shouldNotBeAbleToPoisonArrayProperty(new char[]{'0', '0', '0'}, Character.valueOf('1'));
    }

    @Test
    public void shouldNotBeAbleToPoisonStringArrayProperty() throws Exception {
        this.shouldNotBeAbleToPoisonArrayProperty(new String[]{"zero", "zero", "zero"}, "one");
    }

    private Object veryLongArray(Class<?> type) {
        Object array = Array.newInstance(type, 1000);
        return array;
    }

    private String[] veryLongStringArray() {
        Object[] array = new String[100];
        Arrays.fill(array, "zero");
        return array;
    }

    @Test
    public void shouldNotBeAbleToPoisonVeryLongBooleanArrayProperty() throws Exception {
        this.shouldNotBeAbleToPoisonArrayProperty(this.veryLongArray(Boolean.TYPE), true);
    }

    @Test
    public void shouldNotBeAbleToPoisonVeryLongByteArrayProperty() throws Exception {
        this.shouldNotBeAbleToPoisonArrayProperty(this.veryLongArray(Byte.TYPE), (byte)1);
    }

    @Test
    public void shouldNotBeAbleToPoisonVeryLongShortArrayProperty() throws Exception {
        this.shouldNotBeAbleToPoisonArrayProperty(this.veryLongArray(Short.TYPE), (short)1);
    }

    @Test
    public void shouldNotBeAbleToPoisonVeryLongIntArrayProperty() throws Exception {
        this.shouldNotBeAbleToPoisonArrayProperty(this.veryLongArray(Integer.TYPE), 1);
    }

    @Test
    public void shouldNotBeAbleToPoisonVeryLongLongArrayProperty() throws Exception {
        this.shouldNotBeAbleToPoisonArrayProperty(this.veryLongArray(Long.TYPE), 1L);
    }

    @Test
    public void shouldNotBeAbleToPoisonVeryLongFloatArrayProperty() throws Exception {
        this.shouldNotBeAbleToPoisonArrayProperty(this.veryLongArray(Float.TYPE), Float.valueOf(1.0f));
    }

    @Test
    public void shouldNotBeAbleToPoisonVeryLongDoubleArrayProperty() throws Exception {
        this.shouldNotBeAbleToPoisonArrayProperty(this.veryLongArray(Double.TYPE), 1.0);
    }

    @Test
    public void shouldNotBeAbleToPoisonVeryLongCharArrayProperty() throws Exception {
        this.shouldNotBeAbleToPoisonArrayProperty(this.veryLongArray(Character.TYPE), Character.valueOf('1'));
    }

    @Test
    public void shouldNotBeAbleToPoisonVeryLongStringArrayProperty() throws Exception {
        this.shouldNotBeAbleToPoisonArrayProperty(this.veryLongStringArray(), "one");
    }

    private void shouldNotBeAbleToPoisonArrayProperty(Object value, Object poison) {
        this.shouldNotBeAbleToPoisonArrayPropertyInsideTransaction(value, poison);
        this.shouldNotBeAbleToPoisonArrayPropertyOutsideTransaction(value, poison);
    }

    private void shouldNotBeAbleToPoisonArrayPropertyInsideTransaction(Object value, Object poison) {
        String key = "key";
        this.node1.setProperty(key, value);
        Object readValue = this.node1.getProperty(key);
        Array.set(readValue, 0, poison);
        Assert.assertTrue((String)String.format("Expected %s, but was %s", ObjectUtil.toString((Object)value), ObjectUtil.toString((Object)readValue)), (boolean)ArrayUtil.equals((Object)value, (Object)this.node1.getProperty(key)));
    }

    private void shouldNotBeAbleToPoisonArrayPropertyOutsideTransaction(Object value, Object poison) {
        String key = "key";
        this.node1.setProperty(key, value);
        this.newTransaction();
        this.clearCache();
        Object readValue = this.node1.getProperty(key);
        Array.set(readValue, 0, poison);
        Assert.assertTrue((String)String.format("Expected %s, but was %s", ObjectUtil.toString((Object)value), ObjectUtil.toString((Object)readValue)), (boolean)ArrayUtil.equals((Object)value, (Object)this.node1.getProperty(key)));
    }
}

