/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.HashMap;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.kernel.impl.core.Token;
import org.neo4j.kernel.impl.core.TokenCreator;
import org.neo4j.kernel.impl.core.TokenHolder;

public class TokenHolderTest {
    @Test
    public void shouldClearTokensAsPartOfInitialTokenLoading() throws Exception {
        TokenCreator creator = (TokenCreator)Mockito.mock(TokenCreator.class);
        TokenHolder<Token> holder = new TokenHolder<Token>(creator){

            protected Token newToken(String name, int id) {
                return new Token(name, id);
            }
        };
        holder.setInitialTokens(new Token[]{this.token("one", 1), this.token("two", 2)});
        this.assertTokens(holder.getAllTokens(), this.token("one", 1), this.token("two", 2));
        holder.setInitialTokens(new Token[]{this.token("two", 2), this.token("three", 3), this.token("four", 4)});
        this.assertTokens(holder.getAllTokens(), this.token("two", 2), this.token("three", 3), this.token("four", 4));
    }

    private void assertTokens(Iterable<Token> allTokens, Token ... expectedTokens) {
        HashMap<String, Token> existing = new HashMap<String, Token>();
        for (Token token : allTokens) {
            existing.put(token.name(), token);
        }
        HashMap<String, Token> expected = new HashMap<String, Token>();
        for (Token token : expectedTokens) {
            expected.put(token.name(), token);
        }
        Assert.assertEquals(expected, existing);
    }

    private Token token(String name, int id) {
        return new Token(name, id);
    }
}

