/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.event;

import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.event.ErrorState;
import org.neo4j.graphdb.event.KernelEventHandler;
import org.neo4j.kernel.impl.AbstractNeo4jTestCase;
import org.neo4j.test.TestGraphDatabaseFactory;

public class TestKernelEvents {
    private static final String PATH = "target/var/neodb";
    private static final Object RESOURCE1 = new Object();
    private static final Object RESOURCE2 = new Object();

    @BeforeClass
    public static void doBefore() {
        AbstractNeo4jTestCase.deleteFileOrDirectory(PATH);
    }

    @Test
    public void testRegisterUnregisterHandlers() {
        GraphDatabaseService graphDb = new TestGraphDatabaseFactory().newImpermanentDatabase();
        DummyKernelEventHandler handler1 = new DummyKernelEventHandler(RESOURCE1){

            public KernelEventHandler.ExecutionOrder orderComparedTo(KernelEventHandler other) {
                return KernelEventHandler.ExecutionOrder.DOESNT_MATTER;
            }
        };
        DummyKernelEventHandler handler2 = new DummyKernelEventHandler(RESOURCE2){

            public KernelEventHandler.ExecutionOrder orderComparedTo(KernelEventHandler other) {
                return KernelEventHandler.ExecutionOrder.DOESNT_MATTER;
            }
        };
        try {
            graphDb.unregisterKernelEventHandler((KernelEventHandler)handler1);
            Assert.fail((String)"Shouldn't be able to do unregister on a unregistered handler");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        Assert.assertTrue((handler1 == graphDb.registerKernelEventHandler((KernelEventHandler)handler1) ? 1 : 0) != 0);
        Assert.assertTrue((handler1 == graphDb.registerKernelEventHandler((KernelEventHandler)handler1) ? 1 : 0) != 0);
        Assert.assertTrue((handler1 == graphDb.unregisterKernelEventHandler((KernelEventHandler)handler1) ? 1 : 0) != 0);
        try {
            graphDb.unregisterKernelEventHandler((KernelEventHandler)handler1);
            Assert.fail((String)"Shouldn't be able to do unregister on a unregistered handler");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        Assert.assertTrue((handler1 == graphDb.registerKernelEventHandler((KernelEventHandler)handler1) ? 1 : 0) != 0);
        Assert.assertTrue((handler2 == graphDb.registerKernelEventHandler((KernelEventHandler)handler2) ? 1 : 0) != 0);
        Assert.assertTrue((handler1 == graphDb.unregisterKernelEventHandler((KernelEventHandler)handler1) ? 1 : 0) != 0);
        Assert.assertTrue((handler2 == graphDb.unregisterKernelEventHandler((KernelEventHandler)handler2) ? 1 : 0) != 0);
        graphDb.shutdown();
    }

    @Test
    public void testShutdownEvents() {
        GraphDatabaseService graphDb = new TestGraphDatabaseFactory().newImpermanentDatabase();
        DummyKernelEventHandler handler1 = new DummyKernelEventHandler(RESOURCE1){

            public KernelEventHandler.ExecutionOrder orderComparedTo(KernelEventHandler other) {
                if (((DummyKernelEventHandler)other).resource == RESOURCE2) {
                    return KernelEventHandler.ExecutionOrder.AFTER;
                }
                return KernelEventHandler.ExecutionOrder.DOESNT_MATTER;
            }
        };
        DummyKernelEventHandler handler2 = new DummyKernelEventHandler(RESOURCE1){

            public KernelEventHandler.ExecutionOrder orderComparedTo(KernelEventHandler other) {
                if (((DummyKernelEventHandler)other).resource == RESOURCE1) {
                    return KernelEventHandler.ExecutionOrder.BEFORE;
                }
                return KernelEventHandler.ExecutionOrder.DOESNT_MATTER;
            }
        };
        graphDb.registerKernelEventHandler((KernelEventHandler)handler1);
        graphDb.registerKernelEventHandler((KernelEventHandler)handler2);
        graphDb.shutdown();
        Assert.assertEquals((Object)0, (Object)handler2.beforeShutdown);
        Assert.assertEquals((Object)1, (Object)handler1.beforeShutdown);
    }

    private static abstract class DummyKernelEventHandler
    implements KernelEventHandler {
        private static int counter;
        private Integer beforeShutdown;
        private Integer kernelPanic;
        private final Object resource;

        DummyKernelEventHandler(Object resource) {
            this.resource = resource;
        }

        public void beforeShutdown() {
            this.beforeShutdown = counter++;
        }

        public Object getResource() {
            return this.resource;
        }

        public void kernelPanic(ErrorState error) {
            this.kernelPanic = counter++;
        }
    }
}

