/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.DefaultIdGeneratorFactory;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.store.DynamicArrayStore;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.StoreVersionMismatchHandler;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.test.EphemeralFileSystemRule;
import org.neo4j.test.PageCacheRule;

public class TestDynamicStore {
    @ClassRule
    public static PageCacheRule pageCacheRule = new PageCacheRule();
    public static IdGeneratorFactory ID_GENERATOR_FACTORY = new DefaultIdGeneratorFactory();
    private static final Monitors monitors = new Monitors();
    @Rule
    public EphemeralFileSystemRule fs = new EphemeralFileSystemRule();
    private PageCache pageCache;

    @Before
    public void setUp() {
        this.pageCache = pageCacheRule.getPageCache((FileSystemAbstraction)this.fs.get());
    }

    private File path() {
        String path = "dynamicstore";
        File file = new File(path);
        this.fs.get().mkdirs(file);
        return file;
    }

    private File file(String name) {
        return new File(this.path(), name);
    }

    private File dynamicStoreFile() {
        return this.file("testDynamicStore.db");
    }

    private File dynamicStoreIdFile() {
        return this.file("testDynamicStore.db.id");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateStore() {
        try {
            try {
                this.createEmptyStore(null, 1);
                Assert.fail((String)"Null fileName should throw exception");
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
            try {
                this.createEmptyStore(this.dynamicStoreFile(), 0);
                Assert.fail((String)"Illegal blocksize should throw exception");
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
            this.createEmptyStore(this.dynamicStoreFile(), 15);
            try {
                this.createEmptyStore(this.dynamicStoreFile(), 15);
                Assert.fail((String)"Creating existing store should throw exception");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        finally {
            this.deleteBothFiles();
        }
    }

    private void createEmptyStore(File fileName, int blockSize) {
        Config config = this.config();
        new StoreFactory(config, ID_GENERATOR_FACTORY, this.pageCache, (FileSystemAbstraction)this.fs.get(), StringLogger.DEV_NULL, monitors).createDynamicArrayStore(fileName, blockSize);
    }

    private DynamicArrayStore newStore() {
        Config config = this.config();
        return new DynamicArrayStore(this.dynamicStoreFile(), config, IdType.ARRAY_BLOCK, ID_GENERATOR_FACTORY, this.pageCache, (FileSystemAbstraction)this.fs.get(), StringLogger.DEV_NULL, StoreVersionMismatchHandler.FORCE_CURRENT_VERSION, new Monitors());
    }

    private void deleteBothFiles() {
        File file = this.dynamicStoreFile();
        if (file.exists()) {
            Assert.assertTrue((boolean)file.delete());
        }
        if ((file = this.dynamicStoreIdFile()).exists()) {
            Assert.assertTrue((boolean)file.delete());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStickyStore() throws IOException {
        try {
            this.createEmptyStore(this.dynamicStoreFile(), 30);
            StoreChannel fileChannel = this.fs.get().open(this.dynamicStoreFile(), "rw");
            fileChannel.truncate(fileChannel.size() - 2L);
            fileChannel.close();
            DynamicArrayStore store = this.newStore();
            store.makeStoreOk();
            store.close();
        }
        finally {
            this.deleteBothFiles();
        }
    }

    private Config config() {
        return new Config(MapUtil.stringMap((String[])new String[]{"neo_store", this.dynamicStoreFile().getPath(), "store_dir", this.path().getPath()}), new Class[]{GraphDatabaseSettings.class});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testClose() {
        try {
            this.createEmptyStore(this.dynamicStoreFile(), 30);
            DynamicArrayStore store = this.newStore();
            ArrayList records = new ArrayList();
            store.allocateRecordsFromBytes(records, new byte[10]);
            long blockId = ((DynamicRecord)IteratorUtil.first(records)).getId();
            for (DynamicRecord record : records) {
                store.updateRecord(record);
            }
            store.close();
            try {
                store.getArrayFor((Iterable)store.getRecords(blockId));
                Assert.fail((String)"Closed store should throw exception");
            }
            catch (RuntimeException e) {
                // empty catch block
            }
            try {
                store.getLightRecords(0L);
                Assert.fail((String)"Closed store should throw exception");
            }
            catch (RuntimeException e) {
                // empty catch block
            }
        }
        finally {
            this.deleteBothFiles();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStoreGetCharsFromString() {
        try {
            String STR = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
            this.createEmptyStore(this.dynamicStoreFile(), 30);
            DynamicArrayStore store = this.newStore();
            char[] chars = new char["abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".length()];
            "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".getChars(0, "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".length(), chars, 0);
            ArrayList records = new ArrayList();
            store.allocateRecords(records, (Object)chars, (Iterator)IteratorUtil.emptyIterator());
            for (DynamicRecord record : records) {
                store.updateRecord(record);
            }
            store.close();
        }
        finally {
            this.deleteBothFiles();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRandomTest() {
        Random random = new Random(System.currentTimeMillis());
        this.createEmptyStore(this.dynamicStoreFile(), 30);
        DynamicArrayStore store = this.newStore();
        ArrayList<Long> idsTaken = new ArrayList<Long>();
        HashMap<Long, byte[]> byteData = new HashMap<Long, byte[]>();
        float deleteIndex = 0.2f;
        float closeIndex = 0.1f;
        int currentCount = 0;
        int maxCount = 128;
        HashSet<Long> set = new HashSet<Long>();
        try {
            while (currentCount < maxCount) {
                float rIndex = random.nextFloat();
                if (rIndex < deleteIndex && currentCount > 0) {
                    long blockId = (Long)idsTaken.remove(random.nextInt(currentCount));
                    store.getLightRecords(blockId);
                    byte[] bytes = (byte[])store.getArrayFor((Iterable)store.getRecords(blockId));
                    this.validateData(bytes, (byte[])byteData.remove(blockId));
                    Collection records = store.getLightRecords(blockId);
                    for (DynamicRecord record : records) {
                        record.setInUse(false);
                        store.updateRecord(record);
                        set.remove(record.getId());
                    }
                    --currentCount;
                } else {
                    byte[] bytes = this.createRandomBytes(random);
                    ArrayList records = new ArrayList();
                    store.allocateRecords(records, (Object)bytes, (Iterator)IteratorUtil.emptyIterator());
                    for (DynamicRecord record : records) {
                        assert (!set.contains(record.getId()));
                        store.updateRecord(record);
                        set.add(record.getId());
                    }
                    long blockId = ((DynamicRecord)IteratorUtil.first(records)).getId();
                    idsTaken.add(blockId);
                    byteData.put(blockId, bytes);
                    ++currentCount;
                }
                if (!(rIndex > 1.0f - closeIndex) && !(rIndex < closeIndex)) continue;
                store.close();
                store = this.newStore();
            }
        }
        finally {
            store.close();
            this.deleteBothFiles();
        }
    }

    private byte[] createBytes(int length) {
        return new byte[length];
    }

    private byte[] createRandomBytes(Random r) {
        return new byte[r.nextInt(1024)];
    }

    private void validateData(byte[] data1, byte[] data2) {
        Assert.assertEquals((long)data1.length, (long)data2.length);
        for (int i = 0; i < data1.length; ++i) {
            Assert.assertEquals((long)data1[i], (long)data2[i]);
        }
    }

    private long create(DynamicArrayStore store, Object arrayToStore) {
        ArrayList records = new ArrayList();
        store.allocateRecords(records, arrayToStore, (Iterator)IteratorUtil.emptyIterator());
        for (DynamicRecord record : records) {
            store.updateRecord(record);
        }
        return ((DynamicRecord)IteratorUtil.first(records)).getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAddDeleteSequenceEmptyNumberArray() {
        this.createEmptyStore(this.dynamicStoreFile(), 30);
        DynamicArrayStore store = this.newStore();
        try {
            byte[] emptyToWrite = this.createBytes(0);
            long blockId = this.create(store, emptyToWrite);
            store.getLightRecords(blockId);
            byte[] bytes = (byte[])store.getArrayFor((Iterable)store.getRecords(blockId));
            Assert.assertEquals((long)0L, (long)bytes.length);
            Collection records = store.getLightRecords(blockId);
            for (DynamicRecord record : records) {
                record.setInUse(false);
                store.updateRecord(record);
            }
        }
        finally {
            store.close();
            this.deleteBothFiles();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAddDeleteSequenceEmptyStringArray() {
        this.createEmptyStore(this.dynamicStoreFile(), 30);
        DynamicArrayStore store = this.newStore();
        try {
            long blockId = this.create(store, new String[0]);
            store.getLightRecords(blockId);
            String[] readBack = (String[])store.getArrayFor((Iterable)store.getRecords(blockId));
            Assert.assertEquals((long)0L, (long)readBack.length);
            Collection records = store.getLightRecords(blockId);
            for (DynamicRecord record : records) {
                record.setInUse(false);
                store.updateRecord(record);
            }
        }
        finally {
            store.close();
            this.deleteBothFiles();
        }
    }
}

