/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.DefaultIdGeneratorFactory;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.AbstractNeo4jTestCase;
import org.neo4j.kernel.impl.store.DynamicArrayStore;
import org.neo4j.kernel.impl.store.DynamicStringStore;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PropertyType;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.StoreVersionMismatchHandler;
import org.neo4j.kernel.impl.store.id.IdGeneratorImpl;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.test.EphemeralFileSystemRule;
import org.neo4j.test.PageCacheRule;

public class TestIdGeneratorRebuilding {
    @ClassRule
    public static PageCacheRule pageCacheRule = new PageCacheRule();
    @Rule
    public EphemeralFileSystemRule fsRule = new EphemeralFileSystemRule();
    private EphemeralFileSystemAbstraction fs;

    @Before
    public void doBefore() {
        this.fs = this.fsRule.get();
    }

    private File path() {
        String path = AbstractNeo4jTestCase.getStorePath("xatest");
        File file = new File(path);
        this.fs.mkdirs(file);
        return file;
    }

    private File file(String name) {
        return new File(this.path(), name);
    }

    @Test
    public void verifyFixedSizeStoresCanRebuildIdGeneratorSlowly() throws IOException {
        Config config = new Config(MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.rebuild_idgenerators_fast.name(), "false"}));
        File storeFile = this.file("nodes");
        this.fs.create(storeFile);
        IdGeneratorImpl.createGenerator((FileSystemAbstraction)this.fs, (File)this.file("nodes.id"));
        DynamicArrayStore labelStore = (DynamicArrayStore)Mockito.mock(DynamicArrayStore.class);
        NodeStore store = new NodeStore(storeFile, config, (IdGeneratorFactory)new DefaultIdGeneratorFactory(), pageCacheRule.getPageCache((FileSystemAbstraction)this.fs), (FileSystemAbstraction)this.fs, StringLogger.DEV_NULL, labelStore, StoreVersionMismatchHandler.FORCE_CURRENT_VERSION, new Monitors());
        store.makeStoreOk();
        NodeRecord record = new NodeRecord(0L);
        record.setInUse(true);
        int highestId = 50;
        for (int i = 0; i < highestId; ++i) {
            Assert.assertThat((Object)store.nextId(), (Matcher)Matchers.is((Object)i));
            record.setId((long)i);
            store.updateRecord(record);
        }
        store.setHighestPossibleIdInUse((long)highestId);
        Long[] idsToFree = new Long[]{2L, 3L, 5L, 7L};
        record.setInUse(false);
        Long[] arr$ = idsToFree;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            long toDelete = arr$[i$];
            record.setId(toDelete);
            store.updateRecord(record);
        }
        store.rebuildIdGenerator();
        store.closeIdGenerator();
        store.openIdGenerator();
        ArrayList<Long> nextIds = new ArrayList<Long>();
        nextIds.add(store.nextId());
        nextIds.add(store.nextId());
        nextIds.add(store.nextId());
        nextIds.add(store.nextId());
        nextIds.add(store.nextId());
        Assert.assertThat(nextIds, (Matcher)Matchers.contains((Object[])new Long[]{2L, 3L, 5L, 7L, 50L}));
        store.close();
    }

    @Test
    public void verifyDynamicSizedStoresCanRebuildIdGeneratorSlowly() throws Exception {
        Config config = new Config(MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.rebuild_idgenerators_fast.name(), "false"}));
        config = StoreFactory.configForStoreDir((Config)config, (File)this.path());
        File storeFile = this.file("strings");
        StoreFactory storeFactory = new StoreFactory(config, (IdGeneratorFactory)new DefaultIdGeneratorFactory(), pageCacheRule.getPageCache((FileSystemAbstraction)this.fs), (FileSystemAbstraction)this.fs, StringLogger.DEV_NULL, new Monitors());
        storeFactory.createDynamicStringStore(storeFile, 30, IdType.STRING_BLOCK);
        DynamicStringStore store = storeFactory.newDynamicStringStore(storeFile, IdType.STRING_BLOCK);
        DynamicRecord record = new DynamicRecord(1L);
        record.setInUse(true, PropertyType.STRING.intValue());
        int highestId = 50;
        for (int i = 1; i <= highestId; ++i) {
            Assert.assertThat((Object)store.nextId(), (Matcher)Matchers.is((Object)i));
            record.setId((long)i);
            StringBuilder sb = new StringBuilder(i);
            for (int j = 0; j < i; ++j) {
                sb.append('a');
            }
            record.setData(sb.toString().getBytes("UTF-16"));
            store.updateRecord(record);
        }
        store.setHighestPossibleIdInUse((long)highestId);
        Long[] idsToFree = new Long[]{2L, 3L, 5L, 7L};
        record.setInUse(false);
        Long[] arr$ = idsToFree;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            long toDelete = arr$[i$];
            record.setId(toDelete);
            store.updateRecord(record);
        }
        store.rebuildIdGenerator();
        ArrayList<Long> nextIds = new ArrayList<Long>();
        nextIds.add(store.nextId());
        nextIds.add(store.nextId());
        nextIds.add(store.nextId());
        nextIds.add(store.nextId());
        nextIds.add(store.nextId());
        Assert.assertThat(nextIds, (Matcher)Matchers.contains((Object[])new Long[]{2L, 3L, 5L, 7L, 51L}));
        store.close();
    }

    @Test
    public void rebuildingIdGeneratorMustNotMissOutOnFreeRecordsAtEndOfFilePage() throws IOException {
        Config config = new Config(MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.rebuild_idgenerators_fast.name(), "false"}));
        File storeFile = this.file("nodes");
        this.fs.create(storeFile);
        IdGeneratorImpl.createGenerator((FileSystemAbstraction)this.fs, (File)this.file("nodes.id"));
        DynamicArrayStore labelStore = (DynamicArrayStore)Mockito.mock(DynamicArrayStore.class);
        NodeStore store = new NodeStore(storeFile, config, (IdGeneratorFactory)new DefaultIdGeneratorFactory(), pageCacheRule.getPageCache((FileSystemAbstraction)this.fs), (FileSystemAbstraction)this.fs, StringLogger.DEV_NULL, labelStore, StoreVersionMismatchHandler.FORCE_CURRENT_VERSION, new Monitors());
        store.makeStoreOk();
        int recordsPerPage = store.recordsPerPage();
        NodeRecord record = new NodeRecord(0L);
        record.setInUse(true);
        int highestId = recordsPerPage * 3;
        for (int i = 0; i < highestId; ++i) {
            Assert.assertThat((Object)store.nextId(), (Matcher)Matchers.is((Object)i));
            record.setId((long)i);
            store.updateRecord(record);
        }
        store.setHighestPossibleIdInUse((long)highestId);
        Long[] idsToFree = new Long[]{(long)recordsPerPage - 2L, (long)recordsPerPage - 1L};
        record.setInUse(false);
        Long[] arr$ = idsToFree;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            long toDelete = arr$[i$];
            record.setId(toDelete);
            store.updateRecord(record);
        }
        store.rebuildIdGenerator();
        store.closeIdGenerator();
        store.openIdGenerator();
        ArrayList<Long> nextIds = new ArrayList<Long>();
        nextIds.add(store.nextId());
        nextIds.add(store.nextId());
        nextIds.add(store.nextId());
        Assert.assertThat(nextIds, (Matcher)Matchers.contains((Object[])new Long[]{(long)recordsPerPage - 2L, (long)recordsPerPage - 1L, (long)recordsPerPage * 3L}));
        store.close();
    }
}

