/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.format.v2_2;

import java.io.File;
import java.util.Arrays;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.DefaultIdGeneratorFactory;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.store.NeoStore;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.format.v2_2.NodeStoreFormat_v2_2;
import org.neo4j.kernel.impl.store.impl.StoreMatchers;
import org.neo4j.kernel.impl.store.impl.TestStoreIdGenerator;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.standard.StandardStore;
import org.neo4j.kernel.impl.store.standard.StoreFormat;
import org.neo4j.kernel.impl.store.standard.StoreIdGenerator;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.test.EphemeralFileSystemRule;
import org.neo4j.test.PageCacheRule;

public class NodeFormatComplianceTest {
    @Rule
    public EphemeralFileSystemRule fsRule = new EphemeralFileSystemRule();
    @Rule
    public PageCacheRule pageCacheRule = new PageCacheRule();
    private PageCache pageCache;
    private StoreFactory storeFactory;
    private final File storeDir = new File("dir").getAbsoluteFile();

    @Before
    public void setup() {
        this.pageCache = this.pageCacheRule.getPageCache((FileSystemAbstraction)this.fsRule.get());
        this.storeFactory = new StoreFactory(StoreFactory.configForStoreDir((Config)new Config(), (File)this.storeDir), (IdGeneratorFactory)new DefaultIdGeneratorFactory(), this.pageCache, (FileSystemAbstraction)this.fsRule.get(), StringLogger.DEV_NULL, new Monitors());
    }

    @Test
    public void readsRecords() throws Throwable {
        NeoStore neoStore = this.storeFactory.createNeoStore();
        NodeStore nodeStore = neoStore.getNodeStore();
        NodeRecord expectedRecord = new NodeRecord(nodeStore.nextId(), true, false, 1L, 2L, 42L);
        nodeStore.updateRecord(expectedRecord);
        neoStore.close();
        StandardStore store = new StandardStore((StoreFormat)new NodeStoreFormat_v2_2(), new File(this.storeDir, "neostore.nodestore.db"), (StoreIdGenerator)new TestStoreIdGenerator(), this.pageCache, (FileSystemAbstraction)this.fsRule.get(), StringLogger.DEV_NULL);
        store.init();
        store.start();
        Assert.assertThat(StoreMatchers.records(store), (Matcher)CoreMatchers.equalTo(Arrays.asList(expectedRecord)));
        store.stop();
        store.shutdown();
    }

    @Test
    public void writesRecords() throws Throwable {
        this.storeFactory.createNeoStore().close();
        StandardStore store = new StandardStore((StoreFormat)new NodeStoreFormat_v2_2(), new File(this.storeDir, "neostore.nodestore.db"), (StoreIdGenerator)new TestStoreIdGenerator(), this.pageCache, (FileSystemAbstraction)this.fsRule.get(), StringLogger.DEV_NULL);
        store.init();
        store.start();
        NodeRecord expectedRecord = new NodeRecord(store.allocate(), true, false, 1L, 2L, 42L);
        store.write((Object)expectedRecord);
        store.stop();
        store.shutdown();
        NodeStore nodeStore = this.storeFactory.newNodeStore();
        NodeRecord record = nodeStore.getRecord(expectedRecord.getId());
        nodeStore.close();
        Assert.assertThat((Object)record, (Matcher)CoreMatchers.equalTo((Object)expectedRecord));
    }

    @Test
    public void customCursorShouldReadNextRel() throws Throwable {
        long firstRelId;
        StandardStore store = new StandardStore((StoreFormat)new NodeStoreFormat_v2_2(), new File(this.storeDir, "neostore.nodestore.db"), (StoreIdGenerator)new TestStoreIdGenerator(), this.pageCache, (FileSystemAbstraction)this.fsRule.get(), StringLogger.DEV_NULL);
        store.init();
        store.start();
        long nextRel = 1337L;
        NodeRecord record = new NodeRecord(store.allocate(), true, false, nextRel, 2L, 42L);
        store.write((Object)record);
        NodeStoreFormat_v2_2.NodeRecordCursor cursor = (NodeStoreFormat_v2_2.NodeRecordCursor)store.cursor(0);
        cursor.position(record.getId());
        do {
            firstRelId = cursor.firstRelationship();
        } while (cursor.shouldRetry());
        store.stop();
        store.shutdown();
        Assert.assertThat((Object)firstRelId, (Matcher)CoreMatchers.equalTo((Object)nextRel));
    }
}

