/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.impl;

import java.io.File;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.io.fs.FileLock;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.kernel.impl.store.format.TestHeaderlessStoreFormat;
import org.neo4j.kernel.impl.store.standard.IdGeneratorRebuilder;
import org.neo4j.kernel.impl.store.standard.StoreFormat;
import org.neo4j.kernel.impl.store.standard.StoreOpenCloseCycle;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.test.EphemeralFileSystemRule;

public class StoreOpenCloseCycleTest {
    @Rule
    public EphemeralFileSystemRule fsRule = new EphemeralFileSystemRule();

    @Test
    public void shouldLockAndUnlock() throws Exception {
        StoreFormat format = (StoreFormat)Mockito.mock(StoreFormat.class);
        Mockito.when((Object)format.version()).thenReturn((Object)"v1.0.0");
        Mockito.when((Object)format.type()).thenReturn((Object)"SomeFormat");
        File dbFileName = new File("/store");
        StoreChannel channel = (StoreChannel)Mockito.mock(StoreChannel.class);
        FileLock lock = (FileLock)Mockito.mock(FileLock.class);
        FileSystemAbstraction fs = (FileSystemAbstraction)Mockito.mock(FileSystemAbstraction.class);
        Mockito.when((Object)fs.tryLock(dbFileName, channel)).thenReturn((Object)lock);
        StoreOpenCloseCycle logic = new StoreOpenCloseCycle(StringLogger.DEV_NULL, dbFileName, format, fs);
        logic.openStore(channel);
        ((FileSystemAbstraction)Mockito.verify((Object)fs)).tryLock(dbFileName, channel);
        logic.closeStore(channel, 0L);
        ((FileLock)Mockito.verify((Object)lock)).release();
    }

    @Test
    public void shouldReturnTrueIfStoreIsNotClean() throws Exception {
        File storeFile = new File("store");
        EphemeralFileSystemAbstraction fs = this.fsRule.get();
        TestHeaderlessStoreFormat format = new TestHeaderlessStoreFormat();
        StoreOpenCloseCycle cycle = new StoreOpenCloseCycle(StringLogger.DEV_NULL, storeFile, (StoreFormat)format, (FileSystemAbstraction)fs);
        fs.create(storeFile);
        StoreChannel channel = fs.open(storeFile, "rw");
        boolean uncleanShutdown = cycle.openStore(channel);
        Assert.assertTrue((boolean)uncleanShutdown);
    }

    @Test
    public void cleanlyShutdownStoreShouldNotHaveIdGeneratorRebuilt() throws Exception {
        File storeFile = new File("store");
        EphemeralFileSystemAbstraction fs = this.fsRule.get();
        StoreChannel channel = this.newCleanStore(storeFile);
        IdGeneratorRebuilder idGenRebuilder = (IdGeneratorRebuilder)Mockito.mock(IdGeneratorRebuilder.class);
        StoreOpenCloseCycle cycle = new StoreOpenCloseCycle(StringLogger.DEV_NULL, storeFile, (StoreFormat)new TestHeaderlessStoreFormat(), (FileSystemAbstraction)fs);
        boolean uncleanShutdown = cycle.openStore(channel);
        Assert.assertFalse((boolean)uncleanShutdown);
    }

    private StoreChannel newCleanStore(File storeFile) throws IOException {
        EphemeralFileSystemAbstraction fs = this.fsRule.get();
        StoreOpenCloseCycle cycle = new StoreOpenCloseCycle(StringLogger.DEV_NULL, storeFile, (StoreFormat)new TestHeaderlessStoreFormat(), (FileSystemAbstraction)fs);
        fs.create(storeFile);
        StoreChannel channel = fs.open(storeFile, "rw");
        cycle.openStore(channel);
        cycle.closeStore(channel, 1L);
        return channel;
    }
}

