/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.kvstore;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.Pair;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.store.kvstore.BigEndianByteArrayBuffer;
import org.neo4j.kernel.impl.store.kvstore.DataProvider;
import org.neo4j.kernel.impl.store.kvstore.HeaderField;
import org.neo4j.kernel.impl.store.kvstore.Headers;
import org.neo4j.kernel.impl.store.kvstore.KeyValueStoreFile;
import org.neo4j.kernel.impl.store.kvstore.KeyValueStoreFileFormat;
import org.neo4j.kernel.impl.store.kvstore.KeyValueVisitor;
import org.neo4j.kernel.impl.store.kvstore.ReadableBuffer;
import org.neo4j.kernel.impl.store.kvstore.SearchKey;
import org.neo4j.kernel.impl.store.kvstore.StubCollector;
import org.neo4j.kernel.impl.store.kvstore.WritableBuffer;
import org.neo4j.test.EphemeralFileSystemRule;
import org.neo4j.test.PageCacheRule;
import org.neo4j.test.ResourceRule;

public class KeyValueStoreFileFormatTest {
    @Rule
    public final EphemeralFileSystemRule fs = new EphemeralFileSystemRule();
    @Rule
    public final PageCacheRule pages = new PageCacheRule();
    @Rule
    public final ResourceRule<File> storeFile = ResourceRule.testPath();

    @Before
    public void existingStoreDirectory() {
        this.fs.get().mkdirs(this.storeFile.get().getParentFile());
    }

    @Test
    public void shouldCreateAndOpenEmptyStoreWithEmptyHeader() throws Exception {
        Format format = new Format(new String[0]);
        format.createEmpty(KeyValueStoreFileFormatTest.noHeaders());
        try (KeyValueStoreFile file = format.open();){
            Assert.assertTrue((boolean)file.headers().fields().isEmpty());
            KeyValueStoreFileFormatTest.assertEntries(0, file);
        }
    }

    @Test
    public void shouldCreateAndOpenEmptyStoreWithHeader() throws Exception {
        Format format = new Format("foo", "bar");
        HashMap<String, byte[]> headers = new HashMap<String, byte[]>();
        headers.put("foo", new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 102, 111, 111});
        headers.put("bar", new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 98, 97, 114});
        format.createEmpty(headers);
        try (KeyValueStoreFile file = format.open();){
            this.assertDeepEquals(headers, file.headers());
            KeyValueStoreFileFormatTest.assertEntries(0, file);
        }
    }

    @Test
    public void shouldCreateAndOpenStoreWithNoDataAndEmptyHeader() throws Exception {
        Format format = new Format(new String[0]);
        try (KeyValueStoreFile file = format.create(KeyValueStoreFileFormatTest.noHeaders(), KeyValueStoreFileFormatTest.noData());){
            Assert.assertTrue((boolean)file.headers().fields().isEmpty());
            KeyValueStoreFileFormatTest.assertEntries(0, file);
        }
    }

    @Test
    public void shouldCreateAndOpenStoreWithNoDataWithHeader() throws Exception {
        Format format = new Format("abc", "xyz");
        HashMap<String, byte[]> headers = new HashMap<String, byte[]>();
        headers.put("abc", new byte[]{104, 101, 108, 108, 111, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0});
        headers.put("xyz", new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 119, 111, 114, 108, 100});
        try (KeyValueStoreFile file = format.create(headers, KeyValueStoreFileFormatTest.noData());){
            this.assertDeepEquals(headers, file.headers());
            KeyValueStoreFileFormatTest.assertEntries(0, file);
        }
    }

    @Test
    public void shouldCreateAndOpenStoreWithDataAndEmptyHeader() throws Exception {
        Format format = new Format(new String[0]);
        Data data = Data.data(DataEntry.entry(new byte[]{111, 110, 101}, new byte[]{97, 108, 112, 104, 97}), DataEntry.entry(new byte[]{116, 119, 111}, new byte[]{98, 101, 116, 97}), DataEntry.entry(new byte[]{122, 101, 100}, new byte[]{111, 109, 101, 103, 97}));
        try (KeyValueStoreFile file = format.create(KeyValueStoreFileFormatTest.noHeaders(), data);){
            Assert.assertTrue((boolean)file.headers().fields().isEmpty());
            file.scan(KeyValueStoreFileFormatTest.expectData(data));
            Assert.assertEquals((String)"number of entries", (long)3L, (long)data.index);
            KeyValueStoreFileFormatTest.assertEntries(3, file);
        }
    }

    @Test
    public void shouldCreateAndOpenStoreWithDataAndHeader() throws Exception {
        Format format = new Format("abc", "xyz");
        HashMap<String, byte[]> headers = new HashMap<String, byte[]>();
        headers.put("abc", new byte[]{104, 101, 108, 108, 111, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0});
        headers.put("xyz", new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 119, 111, 114, 108, 100});
        Data data = Data.data(DataEntry.entry(new byte[]{111, 110, 101}, new byte[]{97, 108, 112, 104, 97}), DataEntry.entry(new byte[]{116, 119, 111}, new byte[]{98, 101, 116, 97}), DataEntry.entry(new byte[]{122, 101, 100}, new byte[]{111, 109, 101, 103, 97}));
        try (KeyValueStoreFile file = format.create(headers, data);){
            this.assertDeepEquals(headers, file.headers());
            file.scan(KeyValueStoreFileFormatTest.expectData(data));
            Assert.assertEquals((String)"number of entries", (long)3L, (long)data.index);
            KeyValueStoreFileFormatTest.assertEntries(3, file);
        }
    }

    @Test
    public void shouldFindEntriesInFile() throws Exception {
        Format format = new Format("one", "two");
        HashMap<String, byte[]> headers = new HashMap<String, byte[]>();
        headers.put("one", new byte[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1});
        headers.put("two", new byte[]{2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2});
        HashMap<String, String> config = new HashMap<String, String>();
        config.put(GraphDatabaseSettings.pagecache_memory.name(), "8M");
        config.put(GraphDatabaseSettings.mapped_memory_page_size.name(), "256");
        Data data = Data.data(DataEntry.entry(KeyValueStoreFileFormatTest.bytes(17), KeyValueStoreFileFormatTest.bytes(118, 97, 108, 1)), DataEntry.entry(KeyValueStoreFileFormatTest.bytes(22), KeyValueStoreFileFormatTest.bytes(118, 97, 108, 2)), DataEntry.entry(KeyValueStoreFileFormatTest.bytes(22), KeyValueStoreFileFormatTest.bytes(118, 97, 108, 3)), DataEntry.entry(KeyValueStoreFileFormatTest.bytes(25), KeyValueStoreFileFormatTest.bytes(118, 97, 108, 4)), DataEntry.entry(KeyValueStoreFileFormatTest.bytes(27), KeyValueStoreFileFormatTest.bytes(118, 97, 108, 5)), DataEntry.entry(KeyValueStoreFileFormatTest.bytes(27), KeyValueStoreFileFormatTest.bytes(118, 97, 108, 6)), DataEntry.entry(KeyValueStoreFileFormatTest.bytes(31), KeyValueStoreFileFormatTest.bytes(118, 97, 108, 7)), DataEntry.entry(KeyValueStoreFileFormatTest.bytes(63), KeyValueStoreFileFormatTest.bytes(118, 97, 108, 8)), DataEntry.entry(KeyValueStoreFileFormatTest.bytes(127), KeyValueStoreFileFormatTest.bytes(118, 97, 108, 9)), DataEntry.entry(KeyValueStoreFileFormatTest.bytes(255), KeyValueStoreFileFormatTest.bytes(118, 97, 108, 10)), DataEntry.entry(KeyValueStoreFileFormatTest.bytes(511), KeyValueStoreFileFormatTest.bytes(118, 97, 108, 11)), DataEntry.entry(KeyValueStoreFileFormatTest.bytes(1023), KeyValueStoreFileFormatTest.bytes(118, 97, 108, 12)), DataEntry.entry(KeyValueStoreFileFormatTest.bytes(1050), KeyValueStoreFileFormatTest.bytes(118, 97, 108, 13)), DataEntry.entry(KeyValueStoreFileFormatTest.bytes(2000), KeyValueStoreFileFormatTest.bytes(118, 97, 108, 14)));
        try (KeyValueStoreFile file = format.create(config, headers, data);){
            KeyValueStoreFileFormatTest.assertFind(file, 17, 17, true, new Bytes(118, 97, 108, 1));
            KeyValueStoreFileFormatTest.assertFind(file, 22, 22, true, new Bytes(118, 97, 108, 2), new Bytes(118, 97, 108, 3));
            KeyValueStoreFileFormatTest.assertFind(file, 25, 25, true, new Bytes(118, 97, 108, 4));
            KeyValueStoreFileFormatTest.assertFind(file, 27, 27, true, new Bytes(118, 97, 108, 5), new Bytes(118, 97, 108, 6));
            KeyValueStoreFileFormatTest.assertFind(file, 26, 30, false, new Bytes(118, 97, 108, 5), new Bytes(118, 97, 108, 6));
            KeyValueStoreFileFormatTest.assertFind(file, 31, 31, true, new Bytes(118, 97, 108, 7));
            KeyValueStoreFileFormatTest.assertFind(file, 32, 1024, false, new Bytes(118, 97, 108, 8), new Bytes(118, 97, 108, 9), new Bytes(118, 97, 108, 10), new Bytes(118, 97, 108, 11), new Bytes(118, 97, 108, 12));
            KeyValueStoreFileFormatTest.assertFind(file, 1050, 1050, true, new Bytes(118, 97, 108, 13));
            KeyValueStoreFileFormatTest.assertFind(file, 2000, 2000, true, new Bytes(118, 97, 108, 14));
            KeyValueStoreFileFormatTest.assertFind(file, 1500, 8000, false, new Bytes(118, 97, 108, 14));
            KeyValueStoreFileFormatTest.assertFind(file, 1050, 8000, true, new Bytes(118, 97, 108, 13), new Bytes(118, 97, 108, 14));
            KeyValueStoreFileFormatTest.assertFind(file, 2001, Integer.MAX_VALUE, false, new Bytes[0]);
        }
    }

    @Test
    public void shouldNotFindAnythingWhenSearchKeyIsAfterTheLastKey() throws Exception {
        Format format = new Format(new String[0]);
        HashMap<String, byte[]> metadata = new HashMap<String, byte[]>();
        HashMap<String, String> config = new HashMap<String, String>();
        config.put(GraphDatabaseSettings.pagecache_memory.name(), "8M");
        config.put(GraphDatabaseSettings.mapped_memory_page_size.name(), "128");
        Data data = Data.data(DataEntry.entry(KeyValueStoreFileFormatTest.bytes(12), KeyValueStoreFileFormatTest.bytes(118, 97, 108, 1)), DataEntry.entry(KeyValueStoreFileFormatTest.bytes(13), KeyValueStoreFileFormatTest.bytes(118, 97, 108, 2)), DataEntry.entry(KeyValueStoreFileFormatTest.bytes(15), KeyValueStoreFileFormatTest.bytes(118, 97, 108, 3)), DataEntry.entry(KeyValueStoreFileFormatTest.bytes(16), KeyValueStoreFileFormatTest.bytes(118, 97, 108, 4)), DataEntry.entry(KeyValueStoreFileFormatTest.bytes(17), KeyValueStoreFileFormatTest.bytes(118, 97, 108, 5)), DataEntry.entry(KeyValueStoreFileFormatTest.bytes(18), KeyValueStoreFileFormatTest.bytes(118, 97, 108, 6)));
        try (KeyValueStoreFile file = format.create(config, metadata, data);){
            KeyValueStoreFileFormatTest.assertFind(file, 14, 15, false, new Bytes(118, 97, 108, 3));
            KeyValueStoreFileFormatTest.assertFind(file, 19, 25, false, new Bytes[0]);
            KeyValueStoreFileFormatTest.assertFind(file, 18, 25, true, new Bytes(118, 97, 108, 6));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldTruncateTheFile() throws Exception {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put(GraphDatabaseSettings.pagecache_memory.name(), "8M");
        config.put(GraphDatabaseSettings.mapped_memory_page_size.name(), "128");
        Format format = new Format("one", "two");
        HashMap<String, Object> headers = new HashMap<String, byte[]>();
        headers.put("one", new byte[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1});
        headers.put("two", new byte[]{2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2});
        Data data = Data.data(DataEntry.entry(KeyValueStoreFileFormatTest.bytes(12), KeyValueStoreFileFormatTest.bytes(118, 97, 108, 1)), DataEntry.entry(KeyValueStoreFileFormatTest.bytes(13), KeyValueStoreFileFormatTest.bytes(118, 97, 108, 2)), DataEntry.entry(KeyValueStoreFileFormatTest.bytes(15), KeyValueStoreFileFormatTest.bytes(118, 97, 108, 3)), DataEntry.entry(KeyValueStoreFileFormatTest.bytes(16), KeyValueStoreFileFormatTest.bytes(118, 97, 108, 4)), DataEntry.entry(KeyValueStoreFileFormatTest.bytes(17), KeyValueStoreFileFormatTest.bytes(118, 97, 108, 5)), DataEntry.entry(KeyValueStoreFileFormatTest.bytes(18), KeyValueStoreFileFormatTest.bytes(118, 97, 108, 6)));
        KeyValueStoreFile ignored = format.create(config, headers, data);
        Throwable throwable = null;
        if (ignored != null) {
            if (throwable != null) {
                try {
                    ignored.close();
                }
                catch (Throwable x2) {
                    throwable.addSuppressed(x2);
                }
            } else {
                ignored.close();
            }
        }
        format = new Format("three", "four");
        headers = new HashMap();
        headers.put("three", new byte[]{3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3});
        headers.put("four", new byte[]{4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4});
        data = new DataProvider(){

            public void close() throws IOException {
            }

            public boolean visit(WritableBuffer key, WritableBuffer value) throws IOException {
                throw new IOException("boom!");
            }
        };
        try {
            ignored = format.create(config, headers, data);
            throwable = null;
            if (ignored != null) {
                if (throwable != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable x2) {
                        throwable.addSuppressed(x2);
                    }
                } else {
                    ignored.close();
                }
            }
        }
        catch (IOException io) {
            Assert.assertEquals((Object)"boom!", (Object)io.getMessage());
            this.assertFormatSpecifierAndHeadersOnly(headers, (FileSystemAbstraction)this.fs.get(), this.storeFile.get());
        }
    }

    private void assertFormatSpecifierAndHeadersOnly(Map<String, byte[]> headers, FileSystemAbstraction fs, File file) throws IOException {
        Assert.assertTrue((boolean)fs.fileExists(file));
        try (InputStream stream = fs.openAsInputStream(file);){
            int size = 16;
            byte[] readEntry = new byte[size];
            byte[] allZeros = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
            int read = stream.read(readEntry);
            Assert.assertEquals((long)size, (long)read);
            Assert.assertArrayEquals((byte[])allZeros, (byte[])readEntry);
            read = stream.read(readEntry);
            Assert.assertEquals((long)size, (long)read);
            Assert.assertArrayEquals((byte[])new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, (byte[])readEntry);
            for (int i = 0; i < headers.size(); ++i) {
                read = stream.read(readEntry);
                Assert.assertEquals((long)size, (long)read);
                Assert.assertArrayEquals((byte[])allZeros, (byte[])readEntry);
                read = stream.read(readEntry);
                Assert.assertEquals((long)size, (long)read);
                headers.containsValue(readEntry);
            }
            Assert.assertEquals((long)-1L, (long)stream.read());
        }
    }

    @Test
    public void shouldFailToReadFailWithIncorrectTrailer() throws IOException {
        String[] headerNames = new String[]{"abc", "xyz"};
        Format expectedFormat = new Format(headerNames);
        IncorrectTrailerFormat incorrectTrailerFormat = new IncorrectTrailerFormat(headerNames);
        HashMap<String, byte[]> headers = new HashMap<String, byte[]>();
        headers.put("abc", new byte[]{104, 101, 108, 108, 111, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0});
        headers.put("xyz", new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 119, 111, 114, 108, 100});
        Data data = Data.data(DataEntry.entry(new byte[]{111, 110, 101}, new byte[]{97, 108, 112, 104, 97}), DataEntry.entry(new byte[]{116, 119, 111}, new byte[]{98, 101, 116, 97}), DataEntry.entry(new byte[]{122, 101, 100}, new byte[]{111, 109, 101, 103, 97}));
        try (KeyValueStoreFile originalValidFile = incorrectTrailerFormat.create(headers, data);){
            Assert.assertEquals((String)"number of entries", (long)3L, (long)data.index);
            KeyValueStoreFileFormatTest.assertEntries(3, originalValidFile);
        }
        try {
            expectedFormat.open();
            Assert.fail((String)"It should not be possible to open count store file with incorrect trailer.");
        }
        catch (IOException e) {
            Assert.assertEquals((Object)"Invalid file trailer. Expected trailer not found.", (Object)e.getMessage());
        }
    }

    private static void assertFind(KeyValueStoreFile file, int min, int max, boolean exact, Bytes ... expected) throws IOException {
        Pair<Boolean, List<Bytes>> result = KeyValueStoreFileFormatTest.find(file, min, max);
        Assert.assertEquals((String)"exact match", (Object)exact, (Object)result.first());
        Assert.assertEquals((String)String.format("find(min=%d, max=%d)", min, max), Arrays.asList(expected), (Object)result.other());
    }

    private static Pair<Boolean, List<Bytes>> find(KeyValueStoreFile file, final int min, final int max) throws IOException {
        final ArrayList values = new ArrayList();
        boolean result = file.scan(new SearchKey(){

            public void searchKey(WritableBuffer key) {
                key.putInt(key.size() - 4, min);
            }
        }, new KeyValueVisitor(){

            public boolean visit(ReadableBuffer key, ReadableBuffer value) {
                if (key.getInt(key.size() - 4) <= max) {
                    values.add(new Bytes(value.get(0, new byte[value.size()])));
                    return true;
                }
                return false;
            }
        });
        return Pair.of((Object)result, values);
    }

    private static byte[] bytes(int ... data) {
        if (data.length > 4) {
            throw new AssertionError((Object)("Invalid usage; should have <= 4 data items, got: " + data.length));
        }
        byte[] result = new byte[16];
        int d = data.length;
        int r = result.length - 4;
        while (d-- > 0) {
            int value = data[d];
            int i = 4;
            while (i-- > 0) {
                result[r + i] = (byte)(value & 0xFF);
                value >>>= 8;
            }
            r -= 4;
        }
        return result;
    }

    private void assertDeepEquals(Map<String, byte[]> expected, Headers actual) {
        try {
            int size = 0;
            for (HeaderField field : actual.fields()) {
                Assert.assertArrayEquals((String)field.toString(), (byte[])expected.get(field.toString()), (byte[])((byte[])actual.get(field)));
                ++size;
            }
            Assert.assertEquals((String)"number of headers", (long)expected.size(), (long)size);
        }
        catch (AssertionError e) {
            System.out.println(actual);
            throw e;
        }
    }

    static void assertEntries(int expected, KeyValueStoreFile file) throws IOException {
        class Visitor
        implements KeyValueVisitor {
            int visited = 0;
            final /* synthetic */ int val$expected;

            Visitor(int n) {
                this.val$expected = n;
            }

            public boolean visit(ReadableBuffer key, ReadableBuffer value) {
                if (++this.visited > this.val$expected) {
                    Assert.fail((String)("should not have more than " + this.val$expected + " data entries"));
                }
                return true;
            }

            void done() {
                Assert.assertEquals((String)"number of entries", (long)this.val$expected, (long)this.visited);
            }
        }
        Visitor visitor = new Visitor(expected);
        file.scan((KeyValueVisitor)visitor);
        visitor.done();
    }

    static KeyValueVisitor expectData(final Data expected) {
        expected.index = 0;
        return new KeyValueVisitor(){

            public boolean visit(ReadableBuffer key, ReadableBuffer value) {
                byte[] expectedValue;
                byte[] expectedKey = new byte[key.size()];
                if (!expected.visit((WritableBuffer)new BigEndianByteArrayBuffer(expectedKey), (WritableBuffer)new BigEndianByteArrayBuffer(expectedValue = new byte[value.size()]))) {
                    return false;
                }
                KeyValueStoreFileFormatTest.assertEqualContent(expectedKey, key);
                return true;
            }
        };
    }

    static void assertEqualContent(byte[] expected, ReadableBuffer actual) {
        for (int i = 0; i < expected.length; ++i) {
            if (expected[i] == actual.getByte(i)) continue;
            Assert.fail((String)("expected <" + Arrays.toString(expected) + "> but was <" + actual + ">"));
        }
    }

    static void write(byte[] source, WritableBuffer target) {
        for (int i = 0; i < source.length; ++i) {
            target.putByte(i, source[i]);
        }
    }

    static DataProvider noData() {
        return new DataProvider(){

            public boolean visit(WritableBuffer key, WritableBuffer value) {
                return false;
            }

            public void close() throws IOException {
            }
        };
    }

    static Map<String, byte[]> noHeaders() {
        return Collections.emptyMap();
    }

    static class DataEntry {
        final byte[] key;
        final byte[] value;

        static DataEntry entry(byte[] key, byte[] value) {
            return new DataEntry(key, value);
        }

        DataEntry(byte[] key, byte[] value) {
            this.key = key;
            this.value = value;
        }
    }

    static class Data
    implements DataProvider {
        private final DataEntry[] data;
        private int index;

        static Data data(DataEntry ... data) {
            return new Data(data);
        }

        private Data(DataEntry[] data) {
            this.data = data;
        }

        public boolean visit(WritableBuffer key, WritableBuffer value) {
            if (this.index < this.data.length) {
                DataEntry entry = this.data[this.index++];
                KeyValueStoreFileFormatTest.write(entry.key, key);
                KeyValueStoreFileFormatTest.write(entry.value, value);
                return true;
            }
            return false;
        }

        public void close() throws IOException {
        }
    }

    class IncorrectTrailerFormat
    extends Format {
        public IncorrectTrailerFormat(String ... defaultHeaderFields) {
            super(defaultHeaderFields);
        }

        @Override
        protected String fileTrailer() {
            return "incorrect trailer";
        }
    }

    class Format
    extends KeyValueStoreFileFormat {
        private final Map<String, HeaderField<byte[]>> headerFields;

        public Format(String ... defaultHeaderFields) {
            this(StubCollector.headerFields(defaultHeaderFields));
        }

        private Format(HeaderField<byte[]>[] headerFields) {
            super(32, headerFields);
            this.headerFields = new HashMap<String, HeaderField<byte[]>>();
            for (HeaderField<byte[]> headerField : headerFields) {
                this.headerFields.put(headerField.toString(), headerField);
            }
        }

        void createEmpty(Map<String, byte[]> headers) throws IOException {
            this.createEmptyStore((FileSystemAbstraction)KeyValueStoreFileFormatTest.this.fs.get(), KeyValueStoreFileFormatTest.this.storeFile.get(), 16, 16, this.headers(headers));
        }

        KeyValueStoreFile create(Map<String, byte[]> headers, DataProvider data) throws IOException {
            return this.createStore((FileSystemAbstraction)KeyValueStoreFileFormatTest.this.fs.get(), KeyValueStoreFileFormatTest.this.pages.getPageCache((FileSystemAbstraction)KeyValueStoreFileFormatTest.this.fs.get()), KeyValueStoreFileFormatTest.this.storeFile.get(), 16, 16, this.headers(headers), data);
        }

        KeyValueStoreFile create(Map<String, String> config, Map<String, byte[]> headers, DataProvider data) throws IOException {
            return this.createStore((FileSystemAbstraction)KeyValueStoreFileFormatTest.this.fs.get(), KeyValueStoreFileFormatTest.this.pages.getPageCache((FileSystemAbstraction)KeyValueStoreFileFormatTest.this.fs.get(), new Config(config)), KeyValueStoreFileFormatTest.this.storeFile.get(), 16, 16, this.headers(headers), data);
        }

        private Headers headers(Map<String, byte[]> headers) {
            Headers.Builder builder = Headers.headersBuilder();
            for (Map.Entry<String, byte[]> entry : headers.entrySet()) {
                builder.put(this.headerFields.get(entry.getKey()), (Object)entry.getValue());
            }
            return builder.headers();
        }

        KeyValueStoreFile open() throws IOException {
            return this.openStore((FileSystemAbstraction)KeyValueStoreFileFormatTest.this.fs.get(), KeyValueStoreFileFormatTest.this.pages.getPageCache((FileSystemAbstraction)KeyValueStoreFileFormatTest.this.fs.get()), KeyValueStoreFileFormatTest.this.storeFile.get());
        }

        protected void writeFormatSpecifier(WritableBuffer formatSpecifier) {
            for (int i = 0; i < formatSpecifier.size(); ++i) {
                formatSpecifier.putByte(i, (byte)-1);
            }
        }

        protected String fileTrailer() {
            return "That's all folks...";
        }
    }

    static class Bytes {
        final byte[] bytes;

        Bytes(byte[] bytes) {
            this.bytes = bytes;
        }

        Bytes(int ... data) {
            this.bytes = KeyValueStoreFileFormatTest.bytes(data);
        }

        public String toString() {
            return Arrays.toString(this.bytes);
        }

        public boolean equals(Object o) {
            return this == o || o instanceof Bytes && Arrays.equals(this.bytes, ((Bytes)o).bytes);
        }

        public int hashCode() {
            return Arrays.hashCode(this.bytes);
        }
    }
}

