/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexConfiguration;
import org.neo4j.kernel.api.index.IndexReader;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.store.SchemaStore;
import org.neo4j.kernel.impl.store.record.IndexRule;
import org.neo4j.kernel.impl.store.record.SchemaRule;
import org.neo4j.kernel.impl.storemigration.SchemaIndexMigrator;
import org.neo4j.kernel.impl.storemigration.StoreUpgrader;
import org.neo4j.kernel.impl.storemigration.UpgradableDatabase;

public class SchemaIndexMigratorTest {
    private final FileSystemAbstraction fs = (FileSystemAbstraction)Mockito.mock(FileSystemAbstraction.class);
    private final UpgradableDatabase upgradableDatabase = (UpgradableDatabase)Mockito.mock(UpgradableDatabase.class);
    private final SchemaIndexProvider schemaIndexProvider = (SchemaIndexProvider)Mockito.mock(SchemaIndexProvider.class);
    private final SchemaIndexMigrator.SchemaStoreProvider schemaStoreProvider = (SchemaIndexMigrator.SchemaStoreProvider)Mockito.mock(SchemaIndexMigrator.SchemaStoreProvider.class);
    private final PageCache pageCache = (PageCache)Mockito.mock(PageCache.class);
    private final SchemaIndexMigrator migrator = new SchemaIndexMigrator(this.fs, this.upgradableDatabase, this.schemaStoreProvider);
    private final SchemaStore schemaStore = (SchemaStore)Mockito.mock(SchemaStore.class);
    private final IndexAccessor accessor = (IndexAccessor)Mockito.mock(IndexAccessor.class);
    private final IndexReader indexReader = (IndexReader)Mockito.mock(IndexReader.class);
    private final File storeDir = new File("store");
    private final File migrationDir = new File("migration");
    private final IndexConfiguration indexConfig = new IndexConfiguration(false);
    private final IndexSamplingConfig samplingConfig = new IndexSamplingConfig(new Config());
    private final int indexRuleId = 0;

    @Test
    public void shouldNotMigrateFor1_9Version() throws Exception {
        Mockito.when((Object)this.upgradableDatabase.hasCurrentVersion(this.fs, this.storeDir)).thenReturn((Object)false);
        Mockito.when((Object)this.upgradableDatabase.checkUpgradeable(this.storeDir)).thenReturn((Object)"v0.A.0");
        boolean needsMigration = this.migrator.needsMigration(this.storeDir);
        Assert.assertFalse((boolean)needsMigration);
    }

    @Test
    public void shouldMigrateFor2_0Version() throws Exception {
        Mockito.when((Object)this.upgradableDatabase.hasCurrentVersion(this.fs, this.storeDir)).thenReturn((Object)false);
        Mockito.when((Object)this.upgradableDatabase.checkUpgradeable(this.storeDir)).thenReturn((Object)"v0.A.1");
        boolean needsMigration = this.migrator.needsMigration(this.storeDir);
        Assert.assertTrue((boolean)needsMigration);
    }

    @Test
    public void shouldMigrateFor2_1Version() throws Exception {
        Mockito.when((Object)this.upgradableDatabase.hasCurrentVersion(this.fs, this.storeDir)).thenReturn((Object)false);
        Mockito.when((Object)this.upgradableDatabase.checkUpgradeable(this.storeDir)).thenReturn((Object)"v0.A.3");
        boolean needsMigration = this.migrator.needsMigration(this.storeDir);
        Assert.assertTrue((boolean)needsMigration);
    }

    @Test
    public void shouldNotMigrateFor2_2Version() throws Exception {
        Mockito.when((Object)this.upgradableDatabase.hasCurrentVersion(this.fs, this.storeDir)).thenReturn((Object)true);
        Mockito.when((Object)this.upgradableDatabase.checkUpgradeable(this.storeDir)).thenThrow(new Throwable[]{new StoreUpgrader.UnexpectedUpgradingStoreVersionException("neostore", "v0.A.3", "v0.A.5")});
        boolean needsMigration = this.migrator.needsMigration(this.storeDir);
        Assert.assertFalse((boolean)needsMigration);
    }

    @Test
    public void shouldThrowWhenTryingToMigrateAnUnexpectedVersion() throws Exception {
        Mockito.when((Object)this.upgradableDatabase.checkUpgradeable(this.storeDir)).thenReturn((Object)"v0.A.0");
        try {
            this.migrator.migrate(this.storeDir, this.migrationDir, this.schemaIndexProvider, this.pageCache);
            Assert.fail((String)"should have thrown");
        }
        catch (IllegalStateException ex) {
            Assert.assertEquals((Object)"Unknown version to upgrade from: v0.A.0", (Object)ex.getMessage());
        }
    }

    @Test
    public void shouldDeleteTheIndexIfItContainsIndexedArrayValues() throws Exception {
        Mockito.when((Object)this.upgradableDatabase.checkUpgradeable(this.storeDir)).thenReturn((Object)"v0.A.3");
        Mockito.when((Object)this.indexReader.valueTypesInIndex()).thenReturn(this.asSet(String.class, Array.class));
        this.migrator.migrate(this.storeDir, this.migrationDir, this.schemaIndexProvider, this.pageCache);
        ((FileSystemAbstraction)Mockito.verify((Object)this.fs)).deleteRecursively(new File(SchemaIndexProvider.getRootDirectory((File)this.storeDir, (String)this.schemaIndexProvider.getProviderDescriptor().getKey()), "0"));
    }

    @Test
    public void shouldNotDeleteTheIndexIfItDoesNotContainIndexedArrayValues() throws Exception {
        Mockito.when((Object)this.upgradableDatabase.checkUpgradeable(this.storeDir)).thenReturn((Object)"v0.A.3");
        Mockito.when((Object)this.indexReader.valueTypesInIndex()).thenReturn(this.asSet(String.class, Boolean.class));
        this.migrator.migrate(this.storeDir, this.migrationDir, this.schemaIndexProvider, this.pageCache);
        ((FileSystemAbstraction)Mockito.verify((Object)this.fs, (VerificationMode)Mockito.never())).deleteRecursively(new File(SchemaIndexProvider.getRootDirectory((File)this.storeDir, (String)this.schemaIndexProvider.getProviderDescriptor().getKey()), "0"));
    }

    @Test
    public void shouldHandleMixedIndexesContainingOrNotArrayValues() throws Exception {
        int anotherIndexRuleId = 1;
        int otherIndexRuleId = 2;
        int yetAnotherIndexRuleId = 3;
        Mockito.when((Object)this.upgradableDatabase.checkUpgradeable(this.storeDir)).thenReturn((Object)"v0.A.3");
        Iterator<SchemaRule> iterator = Arrays.asList(this.schemaRule(0, 42, 21), this.schemaRule(anotherIndexRuleId, 41, 20), this.schemaRule(otherIndexRuleId, 40, 19), this.schemaRule(yetAnotherIndexRuleId, 40, 19)).iterator();
        Mockito.when((Object)this.schemaStore.loadAllSchemaRules()).thenReturn(iterator);
        Mockito.when((Object)this.schemaIndexProvider.getOnlineAccessor(0L, this.indexConfig, this.samplingConfig)).thenReturn((Object)this.accessor);
        IndexAccessor anotherAccessor = (IndexAccessor)Mockito.mock(IndexAccessor.class);
        Mockito.when((Object)this.schemaIndexProvider.getOnlineAccessor((long)anotherIndexRuleId, this.indexConfig, this.samplingConfig)).thenReturn((Object)anotherAccessor);
        IndexAccessor otherAccessor = (IndexAccessor)Mockito.mock(IndexAccessor.class);
        Mockito.when((Object)this.schemaIndexProvider.getOnlineAccessor((long)otherIndexRuleId, this.indexConfig, this.samplingConfig)).thenReturn((Object)otherAccessor);
        IndexAccessor yetAnotherIndexAccessor = (IndexAccessor)Mockito.mock(IndexAccessor.class);
        Mockito.when((Object)this.schemaIndexProvider.getOnlineAccessor((long)yetAnotherIndexRuleId, this.indexConfig, this.samplingConfig)).thenReturn((Object)yetAnotherIndexAccessor);
        Mockito.when((Object)this.accessor.newReader()).thenReturn((Object)this.indexReader);
        IndexReader anotherIndexReader = (IndexReader)Mockito.mock(IndexReader.class);
        Mockito.when((Object)anotherAccessor.newReader()).thenReturn((Object)anotherIndexReader);
        IndexReader otherIndexReader = (IndexReader)Mockito.mock(IndexReader.class);
        Mockito.when((Object)otherAccessor.newReader()).thenReturn((Object)otherIndexReader);
        IndexReader yetAnotherIndexReader = (IndexReader)Mockito.mock(IndexReader.class);
        Mockito.when((Object)yetAnotherIndexAccessor.newReader()).thenReturn((Object)yetAnotherIndexReader);
        Mockito.when((Object)this.indexReader.valueTypesInIndex()).thenReturn(this.asSet(String.class, Boolean.class));
        Mockito.when((Object)anotherIndexReader.valueTypesInIndex()).thenReturn(this.asSet(Number.class, Array.class));
        Mockito.when((Object)otherIndexReader.valueTypesInIndex()).thenReturn(this.asSet(String.class));
        Mockito.when((Object)yetAnotherIndexReader.valueTypesInIndex()).thenReturn(this.asSet(Array.class));
        this.migrator.migrate(this.storeDir, this.migrationDir, this.schemaIndexProvider, this.pageCache);
        ((FileSystemAbstraction)Mockito.verify((Object)this.fs, (VerificationMode)Mockito.never())).deleteRecursively(new File(SchemaIndexProvider.getRootDirectory((File)this.storeDir, (String)this.schemaIndexProvider.getProviderDescriptor().getKey()), "0"));
        ((FileSystemAbstraction)Mockito.verify((Object)this.fs)).deleteRecursively(new File(SchemaIndexProvider.getRootDirectory((File)this.storeDir, (String)this.schemaIndexProvider.getProviderDescriptor().getKey()), "" + anotherIndexRuleId));
        ((FileSystemAbstraction)Mockito.verify((Object)this.fs, (VerificationMode)Mockito.never())).deleteRecursively(new File(SchemaIndexProvider.getRootDirectory((File)this.storeDir, (String)this.schemaIndexProvider.getProviderDescriptor().getKey()), "" + otherIndexRuleId));
        ((FileSystemAbstraction)Mockito.verify((Object)this.fs)).deleteRecursively(new File(SchemaIndexProvider.getRootDirectory((File)this.storeDir, (String)this.schemaIndexProvider.getProviderDescriptor().getKey()), "" + yetAnotherIndexRuleId));
    }

    private Set<Class> asSet(Class ... classes) {
        return new HashSet<Class>(Arrays.asList(classes));
    }

    private SchemaRule schemaRule(int id, int labelId, int propertyKeyId) {
        return IndexRule.indexRule((long)id, (int)labelId, (int)propertyKeyId, (SchemaIndexProvider.Descriptor)this.schemaIndexProvider.getProviderDescriptor());
    }

    @Before
    public void setup() throws IOException {
        Mockito.when((Object)this.schemaIndexProvider.getProviderDescriptor()).thenReturn((Object)new SchemaIndexProvider.Descriptor("key", "version"));
        Mockito.when((Object)this.schemaStoreProvider.provide(this.storeDir, this.pageCache)).thenReturn((Object)this.schemaStore);
        Iterator<SchemaRule> iterator = Arrays.asList(this.schemaRule(0, 42, 21)).iterator();
        Mockito.when((Object)this.schemaStore.loadAllSchemaRules()).thenReturn(iterator);
        Mockito.when((Object)this.schemaIndexProvider.getOnlineAccessor(0L, this.indexConfig, this.samplingConfig)).thenReturn((Object)this.accessor);
        Mockito.when((Object)this.accessor.newReader()).thenReturn((Object)this.indexReader);
    }
}

