/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration.legacystore.v20;

import java.io.File;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.storemigration.MigrationTestUtils;
import org.neo4j.kernel.impl.storemigration.legacystore.v20.Legacy20NodeStoreReader;
import org.neo4j.test.TargetDirectory;

public class Legacy20NodeStoreReaderTest {
    private final FileSystemAbstraction fs = new DefaultFileSystemAbstraction();

    @Test
    public void shouldReadNodeRecords() throws IOException {
        File storeDir = TargetDirectory.forTest(Legacy20NodeStoreReader.class).makeGraphDbDir();
        MigrationTestUtils.find20FormatStoreDirectory(storeDir);
        Legacy20NodeStoreReader nodeStoreReader = new Legacy20NodeStoreReader(this.fs, new File(storeDir, "neostore.nodestore.db"));
        Assert.assertEquals((long)1003L, (long)nodeStoreReader.getMaxId());
        int nodeCount = 0;
        for (NodeRecord record : nodeStoreReader) {
            if (!record.inUse()) continue;
            ++nodeCount;
        }
        Assert.assertEquals((long)502L, (long)nodeCount);
        nodeStoreReader.close();
    }
}

