/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration.legacystore.v21.propertydeduplication;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.impl.core.Token;
import org.neo4j.kernel.impl.store.NeoStore;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PropertyKeyTokenStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.TokenStore;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PrimitiveRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.storemigration.legacystore.v21.propertydeduplication.DuplicateCluster;
import org.neo4j.kernel.impl.storemigration.legacystore.v21.propertydeduplication.IndexLookupTest;
import org.neo4j.kernel.impl.storemigration.legacystore.v21.propertydeduplication.NonIndexedConflictResolver;
import org.neo4j.kernel.impl.storemigration.legacystore.v21.propertydeduplication.PropertyDeduplicatorTestUtil;
import org.neo4j.kernel.impl.transaction.state.NeoStoreProvider;
import org.neo4j.test.EmbeddedDatabaseRule;

public class NonIndexedConflictResolverTest {
    @Rule
    public EmbeddedDatabaseRule dbRule = new EmbeddedDatabaseRule(IndexLookupTest.class);
    private GraphDatabaseAPI api;
    private PropertyKeyTokenStore propertyKeyTokenStore;
    private PropertyStore propertyStore;
    private Token tokenA;
    private NodeStore nodeStore;
    private long nodeIdA;
    private long nodeIdB;
    private long nodeIdC;

    @Before
    public void setUp() {
        this.api = this.dbRule.getGraphDatabaseAPI();
        String propKeyA = "keyA";
        String propKeyB = "keyB";
        String propKeyC = "keyC";
        String propKeyD = "keyD";
        String propKeyE = "keyE";
        try (Transaction transaction = this.api.beginTx();){
            Node nodeA = this.api.createNode();
            nodeA.setProperty(propKeyA, (Object)"value");
            nodeA.setProperty(propKeyB, (Object)"value");
            this.nodeIdA = nodeA.getId();
            Node nodeB = this.api.createNode();
            nodeB.setProperty(propKeyA, (Object)"value");
            nodeB.setProperty(propKeyB, (Object)"value");
            this.nodeIdB = nodeB.getId();
            Node nodeC = this.api.createNode();
            nodeC.setProperty(propKeyA, (Object)"longer val");
            nodeC.setProperty(propKeyB, (Object)"longer val");
            nodeC.setProperty(propKeyC, (Object)"longer val");
            nodeC.setProperty(propKeyD, (Object)"longer val");
            nodeC.setProperty(propKeyE, (Object)"longer val");
            this.nodeIdC = nodeC.getId();
            transaction.success();
        }
        DependencyResolver resolver = this.api.getDependencyResolver();
        NeoStoreProvider neoStoreProvider = (NeoStoreProvider)resolver.resolveDependency(NeoStoreProvider.class);
        NeoStore neoStore = (NeoStore)neoStoreProvider.evaluate();
        this.nodeStore = neoStore.getNodeStore();
        this.propertyStore = neoStore.getPropertyStore();
        this.propertyKeyTokenStore = neoStore.getPropertyKeyTokenStore();
        this.tokenA = PropertyDeduplicatorTestUtil.findTokenFor((TokenStore)this.propertyKeyTokenStore, propKeyA);
        Token tokenB = PropertyDeduplicatorTestUtil.findTokenFor((TokenStore)this.propertyKeyTokenStore, propKeyB);
        Token tokenC = PropertyDeduplicatorTestUtil.findTokenFor((TokenStore)this.propertyKeyTokenStore, propKeyC);
        Token tokenD = PropertyDeduplicatorTestUtil.findTokenFor((TokenStore)this.propertyKeyTokenStore, propKeyD);
        Token tokenE = PropertyDeduplicatorTestUtil.findTokenFor((TokenStore)this.propertyKeyTokenStore, propKeyE);
        PropertyDeduplicatorTestUtil.replacePropertyKey(this.propertyStore, (PrimitiveRecord)this.nodeStore.getRecord(this.nodeIdA), tokenB, this.tokenA);
        PropertyDeduplicatorTestUtil.replacePropertyKey(this.propertyStore, (PrimitiveRecord)this.nodeStore.getRecord(this.nodeIdB), tokenB, this.tokenA);
        NodeRecord nodeRecordC = this.nodeStore.getRecord(this.nodeIdC);
        PropertyDeduplicatorTestUtil.replacePropertyKey(this.propertyStore, (PrimitiveRecord)nodeRecordC, tokenB, this.tokenA);
        PropertyDeduplicatorTestUtil.replacePropertyKey(this.propertyStore, (PrimitiveRecord)nodeRecordC, tokenC, this.tokenA);
        PropertyDeduplicatorTestUtil.replacePropertyKey(this.propertyStore, (PrimitiveRecord)nodeRecordC, tokenD, this.tokenA);
        PropertyDeduplicatorTestUtil.replacePropertyKey(this.propertyStore, (PrimitiveRecord)nodeRecordC, tokenE, this.tokenA);
    }

    @Test
    public void shouldRenameDuplicatedPropertyKeysOnANode() throws Exception {
        NonIndexedConflictResolver resolver = new NonIndexedConflictResolver(this.propertyKeyTokenStore, this.propertyStore);
        ArrayList<DuplicateCluster> clusters = new ArrayList<DuplicateCluster>();
        long propertyId = this.addDuplicateCluster(this.nodeIdA, clusters);
        resolver.visited(0L, clusters);
        Token duplicateTokenA = PropertyDeduplicatorTestUtil.findTokenFor((TokenStore)this.propertyKeyTokenStore, "__DUPLICATE_keyA_1");
        Assert.assertNotNull((Object)duplicateTokenA);
        Set<Integer> propertyKeyIdsA = this.collectPropertyKeyIds(propertyId);
        Assert.assertThat(propertyKeyIdsA, (Matcher)Matchers.contains((Object[])new Integer[]{this.tokenA.id(), duplicateTokenA.id()}));
    }

    private long addDuplicateCluster(long nodeId, List<DuplicateCluster> clusters) {
        long propertyId;
        DuplicateCluster cluster = new DuplicateCluster(this.tokenA.id());
        long headPropertyId = propertyId = this.nodeStore.getRecord(nodeId).getNextProp();
        while (propertyId != (long)Record.NO_NEXT_PROPERTY.intValue()) {
            cluster.add(propertyId);
            propertyId = this.propertyStore.getRecord(propertyId).getNextProp();
        }
        clusters.add(cluster);
        return headPropertyId;
    }

    @Test
    public void shouldReuseExistingPropertyKeyTokensWhenThatHaveAlreadyCreatedOnPreviousNodes() throws IOException {
        NonIndexedConflictResolver resolver = new NonIndexedConflictResolver(this.propertyKeyTokenStore, this.propertyStore);
        ArrayList<DuplicateCluster> clusterListA = new ArrayList<DuplicateCluster>();
        long propertyIdA = this.addDuplicateCluster(this.nodeIdA, clusterListA);
        ArrayList<DuplicateCluster> clusterListB = new ArrayList<DuplicateCluster>();
        long propertyIdB = this.addDuplicateCluster(this.nodeIdB, clusterListB);
        resolver.visited(0L, clusterListA);
        resolver.visited(0L, clusterListB);
        Token duplicateTokenA = PropertyDeduplicatorTestUtil.findTokenFor((TokenStore)this.propertyKeyTokenStore, "__DUPLICATE_keyA_1");
        Assert.assertNotNull((Object)duplicateTokenA);
        Set<Integer> propertyKeyIdsA = this.collectPropertyKeyIds(propertyIdA);
        Assert.assertThat(propertyKeyIdsA, (Matcher)Matchers.contains((Object[])new Integer[]{this.tokenA.id(), duplicateTokenA.id()}));
        Set<Integer> propertyKeyIdsB = this.collectPropertyKeyIds(propertyIdB);
        Assert.assertThat(propertyKeyIdsB, (Matcher)Matchers.contains((Object[])new Integer[]{this.tokenA.id(), duplicateTokenA.id()}));
    }

    @Test
    public void shouldCreateNewPropertyKeyTokenWhenItIsNotCreatedOnPreviousNodes() throws IOException {
        NonIndexedConflictResolver resolver = new NonIndexedConflictResolver(this.propertyKeyTokenStore, this.propertyStore);
        ArrayList<DuplicateCluster> clusterListA = new ArrayList<DuplicateCluster>();
        long propertyIdA = this.addDuplicateCluster(this.nodeIdA, clusterListA);
        ArrayList<DuplicateCluster> clusterListC = new ArrayList<DuplicateCluster>();
        long propertyIdC = this.addDuplicateCluster(this.nodeIdC, clusterListC);
        resolver.visited(0L, clusterListA);
        resolver.visited(0L, clusterListC);
        Token duplicateTokenA1 = PropertyDeduplicatorTestUtil.findTokenFor((TokenStore)this.propertyKeyTokenStore, "__DUPLICATE_keyA_1");
        Token duplicateTokenA2 = PropertyDeduplicatorTestUtil.findTokenFor((TokenStore)this.propertyKeyTokenStore, "__DUPLICATE_keyA_2");
        Token duplicateTokenA3 = PropertyDeduplicatorTestUtil.findTokenFor((TokenStore)this.propertyKeyTokenStore, "__DUPLICATE_keyA_3");
        Token duplicateTokenA4 = PropertyDeduplicatorTestUtil.findTokenFor((TokenStore)this.propertyKeyTokenStore, "__DUPLICATE_keyA_4");
        Assert.assertNotNull((Object)duplicateTokenA1);
        Assert.assertNotNull((Object)duplicateTokenA2);
        Assert.assertNotNull((Object)duplicateTokenA3);
        Assert.assertNotNull((Object)duplicateTokenA4);
        Set<Integer> propertyKeyIdsA = this.collectPropertyKeyIds(propertyIdA);
        Assert.assertThat(propertyKeyIdsA, (Matcher)Matchers.contains((Object[])new Integer[]{this.tokenA.id(), duplicateTokenA1.id()}));
        Set<Integer> propertyKeyIdsC = this.collectPropertyKeyIds(propertyIdC);
        Assert.assertThat(propertyKeyIdsC, (Matcher)Matchers.contains((Object[])new Integer[]{this.tokenA.id(), duplicateTokenA1.id(), duplicateTokenA2.id(), duplicateTokenA3.id(), duplicateTokenA4.id()}));
    }

    private Set<Integer> collectPropertyKeyIds(long propertyId) {
        HashSet<Integer> result = new HashSet<Integer>();
        while (propertyId != (long)Record.NO_NEXT_PROPERTY.intValue()) {
            PropertyRecord record = this.propertyStore.getRecord(propertyId);
            for (PropertyBlock propertyBlock : record) {
                int propertyKeyId = propertyBlock.getKeyIndexId();
                Assert.assertTrue((boolean)result.add(propertyKeyId));
            }
            propertyId = record.getNextProp();
        }
        return result;
    }
}

