/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction;

import java.util.Arrays;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseFactoryState;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.EmbeddedGraphDatabase;
import org.neo4j.kernel.InternalAbstractGraphDatabase;
import org.neo4j.kernel.impl.api.index.RemoveOrphanConstraintIndexesOnStartup;
import org.neo4j.kernel.impl.cache.NoCacheProvider;
import org.neo4j.kernel.impl.transaction.TransactionCounters;
import org.neo4j.test.TargetDirectory;

public class CommitContentionTests {
    private static final TargetDirectory target = TargetDirectory.forTest(CommitContentionTests.class);
    final Semaphore semaphore1 = new Semaphore(1);
    final Semaphore semaphore2 = new Semaphore(1);
    final AtomicReference<Exception> reference = new AtomicReference();
    @Rule
    public TargetDirectory.TestDirectory storeLocation = target.testDirectory();
    private GraphDatabaseService db;

    @Before
    public void before() throws Exception {
        this.semaphore1.acquire();
        this.semaphore2.acquire();
        this.db = this.createDb();
    }

    @After
    public void after() throws Exception {
        this.db.shutdown();
    }

    @Test
    public void shouldNotContendOnCommitWhenPushingUpdates() throws Exception {
        Thread thread = this.startFirstTransactionWhichBlocksDuringPushUntilSecondTransactionFinishes();
        this.runAndFinishSecondTransaction();
        thread.join();
        this.assertNoFailures();
    }

    private void assertNoFailures() {
        Exception e = this.reference.get();
        if (e != null) {
            throw new AssertionError((Object)e);
        }
    }

    private void runAndFinishSecondTransaction() {
        this.createNode();
        this.signalSecondTransactionFinished();
    }

    private void createNode() {
        try (Transaction transaction = this.db.beginTx();){
            this.db.createNode();
            transaction.success();
        }
    }

    private Thread startFirstTransactionWhichBlocksDuringPushUntilSecondTransactionFinishes() throws InterruptedException {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                CommitContentionTests.this.createNode();
            }
        });
        thread.start();
        this.waitForFirstTransactionToStartPushing();
        return thread;
    }

    private GraphDatabaseService createDb() {
        GraphDatabaseFactoryState state = new GraphDatabaseFactoryState();
        state.setCacheProviders(Arrays.asList(new NoCacheProvider()));
        return new EmbeddedGraphDatabase(this.storeLocation.absolutePath(), MapUtil.stringMap((String[])new String[]{InternalAbstractGraphDatabase.Configuration.cache_type.name(), "none"}), state.databaseDependencies()){

            protected TransactionCounters createTransactionCounters() {
                return new TransactionCounters(){
                    public boolean skip;

                    public void transactionFinished(boolean successful) {
                        super.transactionFinished(successful);
                        if (this.isTheRemoveOrphanedConstraintIndexesOnStartupTransaction()) {
                            return;
                        }
                        if (successful) {
                            if (this.skip) {
                                return;
                            }
                            this.skip = true;
                            CommitContentionTests.this.signalFirstTransactionStartedPushing();
                            CommitContentionTests.this.waitForSecondTransactionToFinish();
                        }
                    }

                    private boolean isTheRemoveOrphanedConstraintIndexesOnStartupTransaction() {
                        for (StackTraceElement element : Thread.currentThread().getStackTrace()) {
                            if (!element.getClassName().contains(RemoveOrphanConstraintIndexesOnStartup.class.getSimpleName())) continue;
                            return true;
                        }
                        return false;
                    }
                };
            }
        };
    }

    private void waitForFirstTransactionToStartPushing() throws InterruptedException {
        if (!this.semaphore1.tryAcquire(10L, TimeUnit.SECONDS)) {
            throw new IllegalStateException("First transaction never started pushing");
        }
    }

    private void signalFirstTransactionStartedPushing() {
        this.semaphore1.release();
    }

    private void signalSecondTransactionFinished() {
        this.semaphore2.release();
    }

    private void waitForSecondTransactionToFinish() {
        try {
            boolean acquired = this.semaphore2.tryAcquire(10L, TimeUnit.SECONDS);
            if (!acquired) {
                this.reference.set(new IllegalStateException("Second transaction never finished"));
            }
        }
        catch (InterruptedException e) {
            this.reference.set(e);
        }
    }
}

