/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.command;

import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.concurrent.WorkSync;
import org.neo4j.kernel.api.exceptions.index.IndexCapacityExceededException;
import org.neo4j.kernel.api.labelscan.NodeLabelUpdate;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.index.ValidatedIndexUpdates;
import org.neo4j.kernel.impl.core.CacheAccessBackDoor;
import org.neo4j.kernel.impl.store.NodeLabelsField;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.command.IndexTransactionApplier;
import org.neo4j.kernel.impl.util.Providers;
import org.neo4j.unsafe.batchinsert.LabelScanWriter;

public class IndexTransactionApplierTest {
    @Test
    public void shouldProvideLabelScanStoreUpdatesSortedByNodeId() throws Exception {
        IndexingService indexing = (IndexingService)Mockito.mock(IndexingService.class);
        OrderVerifyingLabelScanWriter writer = new OrderVerifyingLabelScanWriter(10L, 15L, 20L);
        WorkSync labelScanSync = new WorkSync((Object)Providers.singletonProvider((Object)writer));
        try (IndexTransactionApplier applier = new IndexTransactionApplier(indexing, ValidatedIndexUpdates.NONE, labelScanSync, (CacheAccessBackDoor)Mockito.mock(CacheAccessBackDoor.class));){
            applier.visitNodeCommand(this.node(15L));
            applier.visitNodeCommand(this.node(20L));
            applier.visitNodeCommand(this.node(10L));
            applier.apply();
        }
    }

    private Command.NodeCommand node(long nodeId) {
        Command.NodeCommand command = new Command.NodeCommand();
        NodeRecord after = new NodeRecord(nodeId, true, false, (long)Record.NO_NEXT_RELATIONSHIP.intValue(), (long)Record.NO_NEXT_PROPERTY.intValue(), 0L);
        NodeLabelsField.parseLabelsField((NodeRecord)after).add(1L, null, null);
        command.init(new NodeRecord(nodeId), after);
        return command;
    }

    private static class OrderVerifyingLabelScanWriter
    implements LabelScanWriter {
        private final long[] expectedNodeIds;
        private int cursor;

        OrderVerifyingLabelScanWriter(long ... expectedNodeIds) {
            this.expectedNodeIds = expectedNodeIds;
        }

        public void write(NodeLabelUpdate update) throws IOException, IndexCapacityExceededException {
            Assert.assertEquals((long)this.expectedNodeIds[this.cursor], (long)update.getNodeId());
            ++this.cursor;
        }

        public void close() throws IOException {
            Assert.assertEquals((long)this.cursor, (long)this.expectedNodeIds.length);
        }
    }
}

