/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.command;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.impl.index.IndexCommand;
import org.neo4j.kernel.impl.transaction.command.PhysicalLogNeoCommandReaderV2_2_4;
import org.neo4j.kernel.impl.transaction.log.CommandWriter;
import org.neo4j.kernel.impl.transaction.log.InMemoryLogChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableLogChannel;
import org.neo4j.kernel.impl.transaction.log.WritableLogChannel;

public class PhysicalLogNeoCommandReaderV2Test {
    @Test
    public void shouldReadIndexCommandHeaderCorrectly() throws Exception {
        PhysicalLogNeoCommandReaderV2_2_4 reader = new PhysicalLogNeoCommandReaderV2_2_4();
        InMemoryLogChannel data = new InMemoryLogChannel();
        CommandWriter writer = new CommandWriter((WritableLogChannel)data);
        IndexCommand.AddRelationshipCommand command = new IndexCommand.AddRelationshipCommand();
        int indexNameId = 12;
        long entityId = 123L;
        int keyId = 1;
        String value = "test value";
        long startNode = 14L;
        long endNode = 15L;
        command.init(indexNameId, entityId, keyId, (Object)value, startNode, endNode);
        writer.visitIndexAddRelationshipCommand(command);
        IndexCommand.AddRelationshipCommand readCommand = (IndexCommand.AddRelationshipCommand)reader.read((ReadableLogChannel)data);
        Assert.assertEquals((long)indexNameId, (long)readCommand.getIndexNameId());
        Assert.assertEquals((long)entityId, (long)readCommand.getEntityId());
        Assert.assertEquals((long)keyId, (long)readCommand.getKeyId());
        Assert.assertEquals((Object)value, (Object)readCommand.getValue());
        Assert.assertEquals((long)startNode, (long)readCommand.getStartNode());
        Assert.assertEquals((long)endNode, (long)readCommand.getEndNode());
    }

    @Test
    public void shouldProperlyMaskIndexIdFieldInIndexHeader() throws Exception {
        PhysicalLogNeoCommandReaderV2_2_4 reader = new PhysicalLogNeoCommandReaderV2_2_4();
        InMemoryLogChannel data = new InMemoryLogChannel();
        CommandWriter writer = new CommandWriter((WritableLogChannel)data);
        IndexCommand.AddRelationshipCommand command = new IndexCommand.AddRelationshipCommand();
        long entityId = 123L;
        int keyId = 1;
        String value = "test value";
        long startNode = 14L;
        long endNode = 15L;
        for (int indexByteId = 0; indexByteId < 63; indexByteId = (int)((byte)(indexByteId + 1))) {
            command.init(indexByteId, entityId, keyId, (Object)value, startNode, endNode);
            writer.visitIndexAddRelationshipCommand(command);
            IndexCommand.AddRelationshipCommand readCommand = (IndexCommand.AddRelationshipCommand)reader.read((ReadableLogChannel)data);
            Assert.assertEquals((long)indexByteId, (long)readCommand.getIndexNameId());
            Assert.assertEquals((long)entityId, (long)readCommand.getEntityId());
            Assert.assertEquals((long)keyId, (long)readCommand.getKeyId());
            Assert.assertEquals((Object)value, (Object)readCommand.getValue());
            Assert.assertEquals((long)startNode, (long)readCommand.getStartNode());
            Assert.assertEquals((long)endNode, (long)readCommand.getEndNode());
            data.reset();
        }
    }
}

