/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.command;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.transaction.command.RelationshipHoles;

public class RelationshipHolesTest {
    private static final int IGNORE = -99;

    @Test
    public void shouldFindEdgeOfHole() throws Exception {
        RelationshipHoles holes = new RelationshipHoles();
        long node = 0L;
        holes.deleted(this.relationship(4L, node, 15L));
        holes.deleted(this.relationship(15L, node, 3L));
        Assert.assertTrue((boolean)holes.accept(4L));
        Assert.assertTrue((boolean)holes.accept(15L));
        Assert.assertFalse((boolean)holes.accept(20L));
        Assert.assertEquals((long)3L, (long)holes.apply(node, 4L));
        Assert.assertEquals((long)3L, (long)holes.apply(node, 15L));
        Assert.assertEquals((long)20L, (long)holes.apply(node, 20L));
    }

    private RelationshipRecord relationship(long id, long node, long next) {
        return new RelationshipRecord(id, false, node, -99L, 0, -99L, next, -99L, -99L, false, false);
    }
}

