/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.entry;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryVersion;

public class LogEntryVersionTest {
    @Test
    public void shouldBeAbleToSelectAnyVersion() throws Exception {
        for (LogEntryVersion version : LogEntryVersion.values()) {
            byte code = version.byteCode();
            byte logHeaderFormatVersion = version.logHeaderFormatVersion();
            System.out.println("trying " + code + ", " + logHeaderFormatVersion);
            LogEntryVersion selectedVersion = LogEntryVersion.byVersion((byte)code, (byte)logHeaderFormatVersion);
            Assert.assertEquals((Object)version, (Object)selectedVersion);
        }
    }

    @Test
    public void shouldDisregardLogHeaderFormatVersionForUniqueVersions() throws Exception {
        Assert.assertEquals((Object)LogEntryVersion.V2_1, (Object)LogEntryVersion.byVersion((byte)LogEntryVersion.V2_1.byteCode(), (byte)99));
    }
}

