/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.impl.store.NeoStoreMocking;
import org.neo4j.kernel.impl.transaction.state.NeoStoreTransactionContext;
import org.neo4j.kernel.impl.transaction.state.NeoStoreTransactionContextSupplier;

public class NeoStoreTransactionContextSupplierTest {
    @Test
    public void shouldReturnTheSameWhenOnlyOneExists() throws Exception {
        NeoStoreTransactionContextSupplier supplier = new NeoStoreTransactionContextSupplier(NeoStoreMocking.mockNeoStore());
        NeoStoreTransactionContext retrieved = (NeoStoreTransactionContext)supplier.acquire();
        retrieved.close();
        Assert.assertEquals((Object)retrieved, (Object)supplier.acquire());
    }

    @Test
    public void shouldCreateNewInstanceWhenNeeded() throws Exception {
        NeoStoreTransactionContextSupplier supplier = new NeoStoreTransactionContextSupplier(NeoStoreMocking.mockNeoStore());
        NeoStoreTransactionContext firstRetrieved = (NeoStoreTransactionContext)supplier.acquire();
        NeoStoreTransactionContext secondRetrieved = (NeoStoreTransactionContext)supplier.acquire();
        Assert.assertNotEquals((Object)firstRetrieved, (Object)secondRetrieved);
    }

    @Test
    public void shouldInstantiateInstancesOnlyWhenNecessary() throws Exception {
        NeoStoreTransactionContextSupplier supplier = new NeoStoreTransactionContextSupplier(NeoStoreMocking.mockNeoStore());
        NeoStoreTransactionContext firstRetrieved = (NeoStoreTransactionContext)supplier.acquire();
        NeoStoreTransactionContext secondRetrieved = (NeoStoreTransactionContext)supplier.acquire();
        firstRetrieved.close();
        NeoStoreTransactionContext thirdRetrieved = (NeoStoreTransactionContext)supplier.acquire();
        Assert.assertEquals((Object)firstRetrieved, (Object)thirdRetrieved);
        Assert.assertNotEquals((Object)firstRetrieved, (Object)secondRetrieved);
    }
}

