/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.helpers.Pair;
import org.neo4j.helpers.Provider;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.DefaultIdGeneratorFactory;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.KernelHealth;
import org.neo4j.kernel.api.TokenNameLookup;
import org.neo4j.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.api.index.NodePropertyUpdate;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.KernelSchemaStateStore;
import org.neo4j.kernel.impl.api.TransactionApplicationMode;
import org.neo4j.kernel.impl.api.TransactionRepresentationCommitProcess;
import org.neo4j.kernel.impl.api.TransactionRepresentationStoreApplier;
import org.neo4j.kernel.impl.api.UpdateableSchemaState;
import org.neo4j.kernel.impl.api.index.IndexMapReference;
import org.neo4j.kernel.impl.api.index.IndexMapSnapshotProvider;
import org.neo4j.kernel.impl.api.index.IndexProxySetup;
import org.neo4j.kernel.impl.api.index.IndexStoreView;
import org.neo4j.kernel.impl.api.index.IndexUpdatesValidator;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.index.SchemaIndexProviderMap;
import org.neo4j.kernel.impl.api.index.TestSchemaIndexProviderDescriptor;
import org.neo4j.kernel.impl.api.index.ValidatedIndexUpdates;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingController;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingControllerFactory;
import org.neo4j.kernel.impl.core.CacheAccessBackDoor;
import org.neo4j.kernel.impl.locking.Lock;
import org.neo4j.kernel.impl.locking.LockGroup;
import org.neo4j.kernel.impl.locking.LockService;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.store.NeoStore;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.SchemaStore;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.UniquenessConstraintRule;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.IndexRule;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.store.record.SchemaRule;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.command.NeoCommandHandler;
import org.neo4j.kernel.impl.transaction.log.LogicalTransactionStore;
import org.neo4j.kernel.impl.transaction.log.PhysicalTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.TransactionAppender;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.impl.transaction.state.DefaultSchemaIndexProviderMap;
import org.neo4j.kernel.impl.transaction.state.IntegrityValidator;
import org.neo4j.kernel.impl.transaction.state.NeoStoreIndexStoreView;
import org.neo4j.kernel.impl.transaction.state.NeoStoreTransactionContext;
import org.neo4j.kernel.impl.transaction.state.NeoStoreTransactionContextSupplier;
import org.neo4j.kernel.impl.transaction.state.PropertyLoader;
import org.neo4j.kernel.impl.transaction.state.TransactionRecordState;
import org.neo4j.kernel.impl.transaction.tracing.CommitEvent;
import org.neo4j.kernel.impl.transaction.tracing.LogAppendEvent;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.logging.Logging;
import org.neo4j.kernel.logging.SingleLoggingService;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.test.PageCacheRule;
import org.neo4j.unsafe.batchinsert.LabelScanWriter;

public class NeoStoreTransactionTest {
    public static final String LONG_STRING = "string value long enough not to be stored as a short string";
    private static final long[] none = new long[0];
    @ClassRule
    public static PageCacheRule pageCacheRule = new PageCacheRule();
    private final DefaultIdGeneratorFactory idGeneratorFactory = new DefaultIdGeneratorFactory();
    private final List<Lock> lockMocks = new ArrayList<Lock>();
    private final CommitEvent commitEvent = CommitEvent.NULL;
    private EphemeralFileSystemAbstraction fs;
    private PageCache pageCache;
    private Config config;
    private NeoStore neoStore;
    private long nextTxId = 2L;
    private LockService locks;
    private CacheAccessBackDoor cacheAccessBackDoor;
    private IndexingService mockIndexing;

    private static void assertRelationshipGroupDoesNotExist(NeoStoreTransactionContext txCtx, NodeRecord node, int type) {
        Assert.assertNull((Object)txCtx.getRelationshipGroup(node, type));
    }

    private static void assertDenseRelationshipCounts(TransactionRecordState tx, NeoStoreTransactionContext txCtx, long nodeId, int type, int outCount, int inCount) {
        RelationshipRecord rel;
        RelationshipGroupRecord group = (RelationshipGroupRecord)txCtx.getRelationshipGroup((NodeRecord)txCtx.getNodeRecords().getOrLoad((Object)nodeId, null).forReadingData(), type).forReadingData();
        Assert.assertNotNull((Object)group);
        long relId = group.getFirstOut();
        if (relId != (long)Record.NO_NEXT_RELATIONSHIP.intValue()) {
            rel = (RelationshipRecord)txCtx.getRelRecords().getOrLoad((Object)relId, null).forReadingData();
            Assert.assertEquals((String)"Stored relationship count for OUTGOING differs", (long)outCount, (long)rel.getFirstPrevRel());
            Assert.assertEquals((String)"Manually counted relationships for OUTGOING differs", (long)outCount, (long)NeoStoreTransactionTest.manuallyCountRelationships(txCtx, nodeId, relId));
        }
        if ((relId = group.getFirstIn()) != (long)Record.NO_NEXT_RELATIONSHIP.intValue()) {
            rel = (RelationshipRecord)txCtx.getRelRecords().getOrLoad((Object)relId, null).forReadingData();
            Assert.assertEquals((String)"Stored relationship count for INCOMING differs", (long)inCount, (long)rel.getSecondPrevRel());
            Assert.assertEquals((String)"Manually counted relationships for INCOMING differs", (long)inCount, (long)NeoStoreTransactionTest.manuallyCountRelationships(txCtx, nodeId, relId));
        }
    }

    private static int manuallyCountRelationships(NeoStoreTransactionContext txCtx, long nodeId, long firstRelId) {
        int count = 0;
        long relId = firstRelId;
        while (relId != (long)Record.NO_NEXT_RELATIONSHIP.intValue()) {
            ++count;
            RelationshipRecord record = (RelationshipRecord)txCtx.getRelRecords().getOrLoad((Object)relId, null).forReadingData();
            relId = record.getFirstNode() == nodeId ? record.getFirstNextRel() : record.getSecondNextRel();
        }
        return count;
    }

    @Test
    public void shouldValidateConstraintIndexAsPartOfPrepare() throws Exception {
        TransactionRecordState writeTransaction = (TransactionRecordState)this.newWriteTransaction().first();
        long indexId = this.neoStore.getSchemaStore().nextId();
        long constraintId = this.neoStore.getSchemaStore().nextId();
        writeTransaction.createSchemaRule((SchemaRule)UniquenessConstraintRule.uniquenessConstraintRule((long)constraintId, (int)1, (int)1, (long)indexId));
        writeTransaction.extractCommands(new ArrayList());
        ((IndexingService)Mockito.verify((Object)this.mockIndexing)).validateIndex(indexId);
    }

    @Test
    public void shouldAddSchemaRuleToCacheWhenApplyingTransactionThatCreatesOne() throws Exception {
        TransactionRecordState writeTransaction = (TransactionRecordState)this.newWriteTransaction().first();
        long ruleId = this.neoStore.getSchemaStore().nextId();
        IndexRule schemaRule = IndexRule.indexRule((long)ruleId, (int)10, (int)8, (SchemaIndexProvider.Descriptor)TestSchemaIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        writeTransaction.createSchemaRule((SchemaRule)schemaRule);
        try (LockGroup locks = new LockGroup();){
            this.commitProcess().commit((TransactionRepresentation)this.transactionRepresentationOf(writeTransaction), locks, this.commitEvent, TransactionApplicationMode.INTERNAL);
        }
        ((CacheAccessBackDoor)Mockito.verify((Object)this.cacheAccessBackDoor)).addSchemaRule((SchemaRule)schemaRule);
    }

    private PhysicalTransactionRepresentation transactionRepresentationOf(TransactionRecordState writeTransaction) throws TransactionFailureException {
        ArrayList commands = new ArrayList();
        writeTransaction.extractCommands(commands);
        return new PhysicalTransactionRepresentation(commands);
    }

    @Test
    public void shouldRemoveSchemaRuleFromCacheWhenApplyingTransactionThatDeletesOne() throws Exception {
        SchemaStore schemaStore = this.neoStore.getSchemaStore();
        int labelId = 10;
        int propertyKey = 10;
        IndexRule rule = IndexRule.indexRule((long)schemaStore.nextId(), (int)labelId, (int)propertyKey, (SchemaIndexProvider.Descriptor)TestSchemaIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        Collection records = schemaStore.allocateFrom((SchemaRule)rule);
        for (DynamicRecord record : records) {
            schemaStore.updateRecord(record);
        }
        long ruleId = ((DynamicRecord)IteratorUtil.first((Iterable)records)).getId();
        TransactionRecordState writeTransaction = (TransactionRecordState)this.newWriteTransaction().first();
        writeTransaction.dropSchemaRule((SchemaRule)rule);
        try (LockGroup locks = new LockGroup();){
            this.commitProcess().commit((TransactionRepresentation)this.transactionRepresentationOf(writeTransaction), locks, this.commitEvent, TransactionApplicationMode.INTERNAL);
        }
        ((CacheAccessBackDoor)Mockito.verify((Object)this.cacheAccessBackDoor)).removeSchemaRuleFromCache(ruleId);
    }

    @Test
    public void shouldMarkDynamicLabelRecordsAsNotInUseWhenLabelsAreReInlined() throws Exception {
        long nodeId = this.neoStore.getNodeStore().nextId();
        TransactionRecordState writeTransaction = (TransactionRecordState)this.newWriteTransaction().first();
        writeTransaction.nodeCreate(nodeId);
        writeTransaction.addLabelToNode(7, nodeId);
        writeTransaction.addLabelToNode(11, nodeId);
        writeTransaction.addLabelToNode(12, nodeId);
        writeTransaction.addLabelToNode(15, nodeId);
        writeTransaction.addLabelToNode(23, nodeId);
        writeTransaction.addLabelToNode(27, nodeId);
        writeTransaction.addLabelToNode(50, nodeId);
        PhysicalTransactionRepresentation transactionCommands = this.transactionRepresentationOf(writeTransaction);
        try (LockGroup locks = new LockGroup();){
            this.commitProcess().commit((TransactionRepresentation)transactionCommands, locks, this.commitEvent, TransactionApplicationMode.INTERNAL);
        }
        writeTransaction = (TransactionRecordState)this.newWriteTransaction().first();
        writeTransaction.removeLabelFromNode(11, nodeId);
        writeTransaction.removeLabelFromNode(23, nodeId);
        transactionCommands = this.transactionRepresentationOf(writeTransaction);
        locks = new LockGroup();
        var6_5 = null;
        try {
            this.commitProcess().commit((TransactionRepresentation)transactionCommands, locks, this.commitEvent, TransactionApplicationMode.INTERNAL);
        }
        catch (Throwable throwable) {
            var6_5 = throwable;
            throw throwable;
        }
        finally {
            if (locks != null) {
                if (var6_5 != null) {
                    try {
                        locks.close();
                    }
                    catch (Throwable x2) {
                        var6_5.addSuppressed(x2);
                    }
                } else {
                    locks.close();
                }
            }
        }
        final AtomicBoolean nodeCommandsExist = new AtomicBoolean(false);
        transactionCommands.accept((Visitor)new NeoCommandHandler.HandlerVisitor((NeoCommandHandler)new NeoCommandHandler.Adapter(){

            public boolean visitNodeCommand(Command.NodeCommand command) throws IOException {
                nodeCommandsExist.set(true);
                Collection beforeDynLabels = command.getAfter().getDynamicLabelRecords();
                Assert.assertThat((Object)beforeDynLabels.size(), (Matcher)org.hamcrest.Matchers.equalTo((Object)1));
                Assert.assertThat((Object)((DynamicRecord)beforeDynLabels.iterator().next()).inUse(), (Matcher)org.hamcrest.Matchers.equalTo((Object)false));
                return false;
            }
        }));
        Assert.assertTrue((String)"No node commands found", (boolean)nodeCommandsExist.get());
    }

    @Test
    public void shouldReUseOriginalDynamicRecordWhenInlinedAndThenExpandedLabelsInSameTx() throws Exception {
        long nodeId = this.neoStore.getNodeStore().nextId();
        TransactionRecordState writeTransaction = (TransactionRecordState)this.newWriteTransaction().first();
        writeTransaction.nodeCreate(nodeId);
        writeTransaction.addLabelToNode(16, nodeId);
        writeTransaction.addLabelToNode(29, nodeId);
        writeTransaction.addLabelToNode(32, nodeId);
        writeTransaction.addLabelToNode(41, nodeId);
        writeTransaction.addLabelToNode(44, nodeId);
        writeTransaction.addLabelToNode(45, nodeId);
        writeTransaction.addLabelToNode(50, nodeId);
        writeTransaction.addLabelToNode(51, nodeId);
        writeTransaction.addLabelToNode(52, nodeId);
        PhysicalTransactionRepresentation transactionCommands = this.transactionRepresentationOf(writeTransaction);
        try (LockGroup locks = new LockGroup();){
            this.commitProcess().commit((TransactionRepresentation)transactionCommands, locks, this.commitEvent, TransactionApplicationMode.INTERNAL);
        }
        writeTransaction = (TransactionRecordState)this.newWriteTransaction().first();
        writeTransaction.removeLabelFromNode(50, nodeId);
        writeTransaction.removeLabelFromNode(51, nodeId);
        writeTransaction.removeLabelFromNode(52, nodeId);
        writeTransaction.addLabelToNode(60, nodeId);
        writeTransaction.addLabelToNode(61, nodeId);
        writeTransaction.addLabelToNode(62, nodeId);
        transactionCommands = this.transactionRepresentationOf(writeTransaction);
        locks = new LockGroup();
        var6_5 = null;
        try {
            this.commitProcess().commit((TransactionRepresentation)transactionCommands, locks, this.commitEvent, TransactionApplicationMode.INTERNAL);
        }
        catch (Throwable throwable) {
            var6_5 = throwable;
            throw throwable;
        }
        finally {
            if (locks != null) {
                if (var6_5 != null) {
                    try {
                        locks.close();
                    }
                    catch (Throwable x2) {
                        var6_5.addSuppressed(x2);
                    }
                } else {
                    locks.close();
                }
            }
        }
        final AtomicBoolean nodeCommandsExist = new AtomicBoolean(false);
        transactionCommands.accept((Visitor)new NeoCommandHandler.HandlerVisitor((NeoCommandHandler)new NeoCommandHandler.Adapter(){

            public boolean visitNodeCommand(Command.NodeCommand command) throws IOException {
                nodeCommandsExist.set(true);
                DynamicRecord before = (DynamicRecord)command.getBefore().getDynamicLabelRecords().iterator().next();
                DynamicRecord after = (DynamicRecord)command.getAfter().getDynamicLabelRecords().iterator().next();
                Assert.assertThat((Object)before.getId(), (Matcher)org.hamcrest.Matchers.equalTo((Object)after.getId()));
                Assert.assertThat((Object)after.inUse(), (Matcher)org.hamcrest.Matchers.equalTo((Object)true));
                return false;
            }
        }));
        Assert.assertTrue((String)"No node commands found", (boolean)nodeCommandsExist.get());
    }

    @Test
    public void shouldRemoveSchemaRuleWhenRollingBackTransaction() throws Exception {
        TransactionRecordState writeTransaction = (TransactionRecordState)this.newWriteTransaction().first();
        long ruleId = this.neoStore.getSchemaStore().nextId();
        writeTransaction.createSchemaRule((SchemaRule)IndexRule.indexRule((long)ruleId, (int)10, (int)7, (SchemaIndexProvider.Descriptor)TestSchemaIndexProviderDescriptor.PROVIDER_DESCRIPTOR));
        this.transactionRepresentationOf(writeTransaction);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.cacheAccessBackDoor});
    }

    @Test
    public void shouldWriteProperBeforeAndAfterPropertyRecordsWhenAddingProperty() throws Exception {
        Visitor<Command, RuntimeException> verifier = new Visitor<Command, RuntimeException>(){

            public boolean visit(Command element) {
                if (element instanceof Command.PropertyCommand) {
                    PropertyRecord before = ((Command.PropertyCommand)element).getBefore();
                    Assert.assertFalse((boolean)before.inUse());
                    Assert.assertFalse((boolean)before.iterator().hasNext());
                    PropertyRecord after = ((Command.PropertyCommand)element).getAfter();
                    Assert.assertTrue((boolean)after.inUse());
                    Assert.assertEquals((long)1L, (long)Iterables.count((Iterable)after));
                }
                return true;
            }
        };
        TransactionRecordState writeTransaction = (TransactionRecordState)this.newWriteTransaction().first();
        int nodeId = 1;
        writeTransaction.nodeCreate((long)nodeId);
        int propertyKey = 1;
        Integer value = 5;
        writeTransaction.nodeAddProperty((long)nodeId, propertyKey, (Object)value);
        this.transactionRepresentationOf(writeTransaction);
    }

    @Test
    public void shouldConvertAddedPropertyToNodePropertyUpdates() throws Exception {
        long nodeId = 0L;
        CapturingIndexingService indexingService = this.createCapturingIndexingService();
        TransactionRecordState writeTransaction = (TransactionRecordState)this.newWriteTransaction(indexingService).first();
        int labelId = 3;
        int propertyKey1 = 1;
        int propertyKey2 = 2;
        String value1 = "first";
        Integer value2 = 4;
        writeTransaction.nodeCreate(nodeId);
        writeTransaction.addLabelToNode(labelId, nodeId);
        writeTransaction.nodeAddProperty(nodeId, propertyKey1, (Object)value1);
        writeTransaction.nodeAddProperty(nodeId, propertyKey2, (Object)value2);
        PhysicalTransactionRepresentation transactionCommands = this.transactionRepresentationOf(writeTransaction);
        try (LockGroup locks = new LockGroup();){
            this.commitProcess(indexingService).commit((TransactionRepresentation)transactionCommands, locks, this.commitEvent, TransactionApplicationMode.INTERNAL);
        }
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new NodePropertyUpdate[]{NodePropertyUpdate.add((long)nodeId, (int)propertyKey1, (Object)value1, (long[])new long[]{labelId}), NodePropertyUpdate.add((long)nodeId, (int)propertyKey2, (Object)value2, (long[])new long[]{labelId})}), (Object)indexingService.updates);
    }

    @Test
    public void shouldConvertChangedPropertyToNodePropertyUpdates() throws Exception {
        int nodeId = 0;
        TransactionRecordState writeTransaction = (TransactionRecordState)this.newWriteTransaction().first();
        int propertyKey1 = 1;
        int propertyKey2 = 2;
        String value1 = "first";
        Integer value2 = 4;
        writeTransaction.nodeCreate((long)nodeId);
        DefinedProperty property1 = writeTransaction.nodeAddProperty((long)nodeId, propertyKey1, (Object)value1);
        DefinedProperty property2 = writeTransaction.nodeAddProperty((long)nodeId, propertyKey2, (Object)value2);
        PhysicalTransactionRepresentation transactionCommands = this.transactionRepresentationOf(writeTransaction);
        try (LockGroup locks = new LockGroup();){
            this.commitProcess().commit((TransactionRepresentation)transactionCommands, locks, this.commitEvent, TransactionApplicationMode.INTERNAL);
        }
        CapturingIndexingService indexingService = this.createCapturingIndexingService();
        String newValue1 = "new";
        String newValue2 = "new 2";
        writeTransaction = (TransactionRecordState)this.newWriteTransaction(indexingService).first();
        writeTransaction.nodeChangeProperty((long)nodeId, property1.propertyKeyId(), (Object)newValue1);
        writeTransaction.nodeChangeProperty((long)nodeId, property2.propertyKeyId(), (Object)newValue2);
        transactionCommands = this.transactionRepresentationOf(writeTransaction);
        try (LockGroup locks = new LockGroup();){
            this.commitProcess(indexingService).commit((TransactionRepresentation)transactionCommands, locks, this.commitEvent, TransactionApplicationMode.INTERNAL);
        }
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new NodePropertyUpdate[]{NodePropertyUpdate.change((long)nodeId, (int)propertyKey1, (Object)value1, (long[])none, (Object)newValue1, (long[])none), NodePropertyUpdate.change((long)nodeId, (int)propertyKey2, (Object)value2, (long[])none, (Object)newValue2, (long[])none)}), (Object)indexingService.updates);
    }

    @Test
    public void shouldConvertRemovedPropertyToNodePropertyUpdates() throws Exception {
        int nodeId = 0;
        TransactionRecordState writeTransaction = (TransactionRecordState)this.newWriteTransaction().first();
        int propertyKey1 = 1;
        int propertyKey2 = 2;
        int labelId = 3;
        String value1 = "first";
        Integer value2 = 4;
        writeTransaction.nodeCreate((long)nodeId);
        writeTransaction.addLabelToNode(labelId, (long)nodeId);
        DefinedProperty property1 = writeTransaction.nodeAddProperty((long)nodeId, propertyKey1, (Object)value1);
        DefinedProperty property2 = writeTransaction.nodeAddProperty((long)nodeId, propertyKey2, (Object)value2);
        PhysicalTransactionRepresentation transactionCommands = this.transactionRepresentationOf(writeTransaction);
        try (LockGroup locks = new LockGroup();){
            this.commitProcess().commit((TransactionRepresentation)transactionCommands, locks, this.commitEvent, TransactionApplicationMode.INTERNAL);
        }
        CapturingIndexingService indexingService = this.createCapturingIndexingService();
        writeTransaction = (TransactionRecordState)this.newWriteTransaction(indexingService).first();
        writeTransaction.nodeRemoveProperty((long)nodeId, property1.propertyKeyId());
        writeTransaction.nodeRemoveProperty((long)nodeId, property2.propertyKeyId());
        transactionCommands = this.transactionRepresentationOf(writeTransaction);
        try (LockGroup locks = new LockGroup();){
            this.commitProcess(indexingService).commit((TransactionRepresentation)transactionCommands, locks, this.commitEvent, TransactionApplicationMode.INTERNAL);
        }
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new NodePropertyUpdate[]{NodePropertyUpdate.remove((long)nodeId, (int)propertyKey1, (Object)value1, (long[])new long[]{labelId}), NodePropertyUpdate.remove((long)nodeId, (int)propertyKey2, (Object)value2, (long[])new long[]{labelId})}), (Object)indexingService.updates);
    }

    @Test
    public void shouldConvertLabelAdditionToNodePropertyUpdates() throws Exception {
        long nodeId = 0L;
        TransactionRecordState writeTransaction = (TransactionRecordState)this.newWriteTransaction().first();
        int propertyKey1 = 1;
        int propertyKey2 = 2;
        int labelId = 3;
        long[] labelIds = new long[]{labelId};
        String value1 = LONG_STRING;
        byte[] value2 = LONG_STRING.getBytes();
        writeTransaction.nodeCreate(nodeId);
        writeTransaction.nodeAddProperty(nodeId, propertyKey1, (Object)value1);
        writeTransaction.nodeAddProperty(nodeId, propertyKey2, (Object)value2);
        PhysicalTransactionRepresentation transactionCommands = this.transactionRepresentationOf(writeTransaction);
        try (LockGroup locks = new LockGroup();){
            this.commitProcess().commit((TransactionRepresentation)transactionCommands, locks, this.commitEvent, TransactionApplicationMode.INTERNAL);
        }
        CapturingIndexingService indexingService = this.createCapturingIndexingService();
        writeTransaction = (TransactionRecordState)this.newWriteTransaction(indexingService).first();
        writeTransaction.addLabelToNode(labelId, nodeId);
        transactionCommands = this.transactionRepresentationOf(writeTransaction);
        try (LockGroup locks = new LockGroup();){
            this.commitProcess(indexingService).commit((TransactionRepresentation)transactionCommands, locks, this.commitEvent, TransactionApplicationMode.INTERNAL);
        }
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new NodePropertyUpdate[]{NodePropertyUpdate.add((long)nodeId, (int)propertyKey1, (Object)value1, (long[])labelIds), NodePropertyUpdate.add((long)nodeId, (int)propertyKey2, (Object)value2, (long[])labelIds)}), (Object)indexingService.updates);
    }

    @Test
    public void shouldConvertMixedLabelAdditionAndSetPropertyToNodePropertyUpdates() throws Exception {
        long nodeId = 0L;
        TransactionRecordState writeTransaction = (TransactionRecordState)this.newWriteTransaction().first();
        int propertyKey1 = 1;
        int propertyKey2 = 2;
        int labelId1 = 3;
        int labelId2 = 4;
        String value1 = "first";
        Integer value2 = 4;
        writeTransaction.nodeCreate(nodeId);
        writeTransaction.nodeAddProperty(nodeId, propertyKey1, (Object)value1);
        writeTransaction.addLabelToNode(labelId1, nodeId);
        PhysicalTransactionRepresentation transactionCommands = this.transactionRepresentationOf(writeTransaction);
        try (LockGroup locks = new LockGroup();){
            this.commitProcess().commit((TransactionRepresentation)transactionCommands, locks, this.commitEvent, TransactionApplicationMode.INTERNAL);
        }
        CapturingIndexingService indexingService = this.createCapturingIndexingService();
        writeTransaction = (TransactionRecordState)this.newWriteTransaction(indexingService).first();
        writeTransaction.nodeAddProperty(nodeId, propertyKey2, (Object)value2);
        writeTransaction.addLabelToNode(labelId2, nodeId);
        transactionCommands = this.transactionRepresentationOf(writeTransaction);
        try (LockGroup locks = new LockGroup();){
            this.commitProcess(indexingService).commit((TransactionRepresentation)transactionCommands, locks, this.commitEvent, TransactionApplicationMode.INTERNAL);
        }
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new NodePropertyUpdate[]{NodePropertyUpdate.add((long)nodeId, (int)propertyKey1, (Object)value1, (long[])new long[]{labelId2}), NodePropertyUpdate.add((long)nodeId, (int)propertyKey2, (Object)value2, (long[])new long[]{labelId2}), NodePropertyUpdate.add((long)nodeId, (int)propertyKey2, (Object)value2, (long[])new long[]{labelId1})}), (Object)indexingService.updates);
    }

    @Test
    public void shouldConvertLabelRemovalToNodePropertyUpdates() throws Exception {
        long nodeId = 0L;
        TransactionRecordState writeTransaction = (TransactionRecordState)this.newWriteTransaction().first();
        int propertyKey1 = 1;
        int propertyKey2 = 2;
        int labelId = 3;
        long[] labelIds = new long[]{labelId};
        String value1 = "first";
        Integer value2 = 4;
        writeTransaction.nodeCreate(nodeId);
        writeTransaction.nodeAddProperty(nodeId, propertyKey1, (Object)value1);
        writeTransaction.nodeAddProperty(nodeId, propertyKey2, (Object)value2);
        writeTransaction.addLabelToNode(labelId, nodeId);
        PhysicalTransactionRepresentation transactionCommands = this.transactionRepresentationOf(writeTransaction);
        try (LockGroup locks = new LockGroup();){
            this.commitProcess().commit((TransactionRepresentation)transactionCommands, locks, this.commitEvent, TransactionApplicationMode.INTERNAL);
        }
        CapturingIndexingService indexingService = this.createCapturingIndexingService();
        writeTransaction = (TransactionRecordState)this.newWriteTransaction(indexingService).first();
        writeTransaction.removeLabelFromNode(labelId, nodeId);
        transactionCommands = this.transactionRepresentationOf(writeTransaction);
        try (LockGroup locks = new LockGroup();){
            this.commitProcess(indexingService).commit((TransactionRepresentation)transactionCommands, locks, this.commitEvent, TransactionApplicationMode.INTERNAL);
        }
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new NodePropertyUpdate[]{NodePropertyUpdate.remove((long)nodeId, (int)propertyKey1, (Object)value1, (long[])labelIds), NodePropertyUpdate.remove((long)nodeId, (int)propertyKey2, (Object)value2, (long[])labelIds)}), (Object)indexingService.updates);
    }

    @Test
    public void shouldConvertMixedLabelRemovalAndRemovePropertyToNodePropertyUpdates() throws Exception {
        long nodeId = 0L;
        TransactionRecordState writeTransaction = (TransactionRecordState)this.newWriteTransaction().first();
        int propertyKey1 = 1;
        int propertyKey2 = 2;
        int labelId1 = 3;
        int labelId2 = 4;
        String value1 = "first";
        Integer value2 = 4;
        writeTransaction.nodeCreate(nodeId);
        DefinedProperty property1 = writeTransaction.nodeAddProperty(nodeId, propertyKey1, (Object)value1);
        writeTransaction.nodeAddProperty(nodeId, propertyKey2, (Object)value2);
        writeTransaction.addLabelToNode(labelId1, nodeId);
        writeTransaction.addLabelToNode(labelId2, nodeId);
        PhysicalTransactionRepresentation transactionCommands = this.transactionRepresentationOf(writeTransaction);
        try (LockGroup locks = new LockGroup();){
            this.commitProcess().commit((TransactionRepresentation)transactionCommands, locks, this.commitEvent, TransactionApplicationMode.INTERNAL);
        }
        CapturingIndexingService indexingService = this.createCapturingIndexingService();
        writeTransaction = (TransactionRecordState)this.newWriteTransaction(indexingService).first();
        writeTransaction.nodeRemoveProperty(nodeId, property1.propertyKeyId());
        writeTransaction.removeLabelFromNode(labelId2, nodeId);
        transactionCommands = this.transactionRepresentationOf(writeTransaction);
        try (LockGroup locks = new LockGroup();){
            this.commitProcess(indexingService).commit((TransactionRepresentation)transactionCommands, locks, this.commitEvent, TransactionApplicationMode.INTERNAL);
        }
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new NodePropertyUpdate[]{NodePropertyUpdate.remove((long)nodeId, (int)propertyKey1, (Object)value1, (long[])new long[]{labelId1, labelId2}), NodePropertyUpdate.remove((long)nodeId, (int)propertyKey2, (Object)value2, (long[])new long[]{labelId2})}), (Object)indexingService.updates);
    }

    @Test
    public void shouldConvertMixedLabelRemovalAndAddPropertyToNodePropertyUpdates() throws Exception {
        long nodeId = 0L;
        TransactionRecordState writeTransaction = (TransactionRecordState)this.newWriteTransaction().first();
        int propertyKey1 = 1;
        int propertyKey2 = 2;
        int labelId1 = 3;
        int labelId2 = 4;
        String value1 = "first";
        Integer value2 = 4;
        writeTransaction.nodeCreate(nodeId);
        writeTransaction.nodeAddProperty(nodeId, propertyKey1, (Object)value1);
        writeTransaction.addLabelToNode(labelId1, nodeId);
        writeTransaction.addLabelToNode(labelId2, nodeId);
        PhysicalTransactionRepresentation transactionCommands = this.transactionRepresentationOf(writeTransaction);
        try (LockGroup locks = new LockGroup();){
            this.commitProcess().commit((TransactionRepresentation)transactionCommands, locks, this.commitEvent, TransactionApplicationMode.INTERNAL);
        }
        CapturingIndexingService indexingService = this.createCapturingIndexingService();
        writeTransaction = (TransactionRecordState)this.newWriteTransaction(indexingService).first();
        writeTransaction.nodeAddProperty(nodeId, propertyKey2, (Object)value2);
        writeTransaction.removeLabelFromNode(labelId2, nodeId);
        transactionCommands = this.transactionRepresentationOf(writeTransaction);
        try (LockGroup locks = new LockGroup();){
            this.commitProcess(indexingService).commit((TransactionRepresentation)transactionCommands, locks, this.commitEvent, TransactionApplicationMode.INTERNAL);
        }
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new NodePropertyUpdate[]{NodePropertyUpdate.add((long)nodeId, (int)propertyKey2, (Object)value2, (long[])new long[]{labelId1}), NodePropertyUpdate.remove((long)nodeId, (int)propertyKey1, (Object)value1, (long[])new long[]{labelId2}), NodePropertyUpdate.remove((long)nodeId, (int)propertyKey2, (Object)value2, (long[])new long[]{labelId2})}), (Object)indexingService.updates);
    }

    @Test
    public void shouldUpdateHighIdsOnExternalTransaction() throws Exception {
        TransactionRecordState tx = (TransactionRecordState)this.newWriteTransaction().first();
        int nodeId = 5;
        int relId = 10;
        int relationshipType = 3;
        int propertyKeyId = 4;
        int ruleId = 8;
        tx.nodeCreate((long)nodeId);
        tx.createRelationshipTypeToken("type", relationshipType);
        tx.relCreate((long)relId, 0, (long)nodeId, (long)nodeId);
        tx.relAddProperty((long)relId, propertyKeyId, (Object)new long[]{0x1000000000000000L, 0x1000000000000000L, 0x1000000000000000L, 0x1000000000000000L, 0x1000000000000000L, 0x1000000000000000L, 0x1000000000000000L, 0x1000000000000000L, 0x1000000000000000L, 0x1000000000000000L});
        tx.createPropertyKeyToken("key", propertyKeyId);
        tx.nodeAddProperty((long)nodeId, propertyKeyId, (Object)"something long and nasty that requires dynamic records for sure I would think and hope. Ok then \u00e5\u00e4\u00f6%!=");
        for (int i = 0; i < 10; ++i) {
            tx.addLabelToNode(10000 + i, (long)nodeId);
        }
        tx.createSchemaRule((SchemaRule)IndexRule.indexRule((long)ruleId, (int)100, (int)propertyKeyId, (SchemaIndexProvider.Descriptor)TestSchemaIndexProviderDescriptor.PROVIDER_DESCRIPTOR));
        PhysicalTransactionRepresentation toCommit = this.transactionRepresentationOf(tx);
        RecoveryCreatingCopyingNeoCommandHandler recoverer = new RecoveryCreatingCopyingNeoCommandHandler();
        toCommit.accept((Visitor)recoverer);
        this.commit(recoverer.getAsRecovered(), TransactionApplicationMode.EXTERNAL);
        Assert.assertEquals((String)"NodeStore", (long)(nodeId + 1), (long)this.neoStore.getNodeStore().getHighId());
        Assert.assertEquals((String)"DynamicNodeLabelStore", (long)2L, (long)this.neoStore.getNodeStore().getDynamicLabelStore().getHighId());
        Assert.assertEquals((String)"RelationshipStore", (long)(relId + 1), (long)this.neoStore.getRelationshipStore().getHighId());
        Assert.assertEquals((String)"RelationshipTypeStore", (long)(relationshipType + 1), (long)this.neoStore.getRelationshipTypeTokenStore().getHighId());
        Assert.assertEquals((String)"RelationshipType NameStore", (long)2L, (long)this.neoStore.getRelationshipTypeTokenStore().getNameStore().getHighId());
        Assert.assertEquals((String)"PropertyStore", (long)2L, (long)this.neoStore.getPropertyStore().getHighId());
        Assert.assertEquals((String)"PropertyStore DynamicStringStore", (long)2L, (long)this.neoStore.getPropertyStore().getStringStore().getHighId());
        Assert.assertEquals((String)"PropertyStore DynamicArrayStore", (long)2L, (long)this.neoStore.getPropertyStore().getArrayStore().getHighId());
        Assert.assertEquals((String)"PropertyIndexStore", (long)(propertyKeyId + 1), (long)this.neoStore.getPropertyKeyTokenStore().getHighId());
        Assert.assertEquals((String)"PropertyKeyToken NameStore", (long)2L, (long)this.neoStore.getPropertyStore().getPropertyKeyTokenStore().getNameStore().getHighId());
        Assert.assertEquals((String)"SchemaStore", (long)(ruleId + 1), (long)this.neoStore.getSchemaStore().getHighId());
    }

    @Test
    public void createdSchemaRuleRecordMustBeWrittenHeavy() throws Exception {
        TransactionRecordState tx = (TransactionRecordState)this.newWriteTransaction().first();
        long ruleId = 0L;
        int labelId = 5;
        int propertyKeyId = 7;
        IndexRule rule = IndexRule.indexRule((long)ruleId, (int)labelId, (int)propertyKeyId, (SchemaIndexProvider.Descriptor)TestSchemaIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        tx.createSchemaRule((SchemaRule)rule);
        PhysicalTransactionRepresentation transactionCommands = this.transactionRepresentationOf(tx);
        transactionCommands.accept((Visitor)new NeoCommandHandler.HandlerVisitor((NeoCommandHandler)new NeoCommandHandler.Adapter(){

            public boolean visitSchemaRuleCommand(Command.SchemaRuleCommand command) throws IOException {
                for (DynamicRecord record : command.getRecordsAfter()) {
                    Assert.assertFalse((String)(record + " should have been heavy"), (boolean)record.isLight());
                }
                return false;
            }
        }));
    }

    @Test
    public void shouldWriteProperPropertyRecordsWhenOnlyChangingLinkage() throws Exception {
        TransactionRecordState tx = (TransactionRecordState)this.newWriteTransaction().first();
        int nodeId = 0;
        tx.nodeCreate((long)nodeId);
        int index = 0;
        tx.nodeAddProperty((long)nodeId, index, (Object)this.string(70));
        try (LockGroup locks = new LockGroup();){
            this.commitProcess().commit((TransactionRepresentation)this.transactionRepresentationOf(tx), locks, this.commitEvent, TransactionApplicationMode.INTERNAL);
        }
        NeoCommandHandler.HandlerVisitor verifier = new NeoCommandHandler.HandlerVisitor((NeoCommandHandler)new NeoCommandHandler.Adapter(){

            public boolean visitPropertyCommand(Command.PropertyCommand command) throws IOException {
                this.verifyPropertyRecord(command.getBefore());
                this.verifyPropertyRecord(command.getAfter());
                return false;
            }

            private void verifyPropertyRecord(PropertyRecord record) {
                if (record.getPrevProp() != (long)Record.NO_NEXT_PROPERTY.intValue()) {
                    for (PropertyBlock block : record) {
                        Assert.assertTrue((boolean)block.isLight());
                    }
                }
            }
        });
        tx = (TransactionRecordState)this.newWriteTransaction(this.mockIndexing).first();
        int index2 = 1;
        tx.nodeAddProperty((long)nodeId, index2, (Object)this.string(40));
        PhysicalTransactionRepresentation representation = this.transactionRepresentationOf(tx);
        representation.accept((Visitor)verifier);
        try (LockGroup locks = new LockGroup();){
            this.commitProcess().commit((TransactionRepresentation)representation, locks, this.commitEvent, TransactionApplicationMode.INTERNAL);
        }
    }

    @Test
    public void shouldCreateEqualNodePropertyUpdatesOnRecoveryOfCreatedNode() throws Exception {
        long nodeId = 0L;
        int labelId = 5;
        int propertyKeyId = 7;
        NodePropertyUpdate expectedUpdate = NodePropertyUpdate.add((long)nodeId, (int)propertyKeyId, (Object)"Neo", (long[])new long[]{labelId});
        long ruleId = 0L;
        TransactionRecordState tx = (TransactionRecordState)this.newWriteTransaction().first();
        IndexRule rule = IndexRule.indexRule((long)ruleId, (int)labelId, (int)propertyKeyId, (SchemaIndexProvider.Descriptor)TestSchemaIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        tx.createSchemaRule((SchemaRule)rule);
        try (LockGroup locks = new LockGroup();){
            this.commitProcess().commit((TransactionRepresentation)this.transactionRepresentationOf(tx), locks, this.commitEvent, TransactionApplicationMode.INTERNAL);
        }
        IteratorCollector<NodePropertyUpdate> indexUpdates = new IteratorCollector<NodePropertyUpdate>(0);
        ((IndexingService)Mockito.doAnswer(indexUpdates).when((Object)this.mockIndexing)).validate((Iterable)Matchers.any(Iterable.class));
        tx = (TransactionRecordState)this.newWriteTransaction().first();
        tx.nodeCreate(nodeId);
        tx.addLabelToNode(labelId, nodeId);
        tx.nodeAddProperty(nodeId, propertyKeyId, (Object)"Neo");
        PhysicalTransactionRepresentation representation = this.transactionRepresentationOf(tx);
        RecoveryCreatingCopyingNeoCommandHandler recoverer = new RecoveryCreatingCopyingNeoCommandHandler();
        representation.accept((Visitor)recoverer);
        try (LockGroup locks = new LockGroup();){
            this.commitProcess().commit((TransactionRepresentation)representation, locks, this.commitEvent, TransactionApplicationMode.INTERNAL);
        }
        ((IndexingService)Mockito.verify((Object)this.mockIndexing, (VerificationMode)Mockito.times((int)1))).validate((Iterable)Matchers.any(Iterable.class));
        indexUpdates.assertContent(expectedUpdate);
        Mockito.reset((Object[])new IndexingService[]{this.mockIndexing});
        indexUpdates = new IteratorCollector(0);
        ((IndexingService)Mockito.doAnswer(indexUpdates).when((Object)this.mockIndexing)).validate((Iterable)Matchers.any(Iterable.class));
        this.commit(recoverer.getAsRecovered(), TransactionApplicationMode.RECOVERY);
        ((IndexingService)Mockito.verify((Object)this.mockIndexing, (VerificationMode)Mockito.times((int)1))).addRecoveredNodeIds(PrimitiveLongCollections.setOf((long[])new long[]{nodeId}));
        ((IndexingService)Mockito.verify((Object)this.mockIndexing, (VerificationMode)Mockito.never())).validate((Iterable)Matchers.any(Iterable.class));
    }

    @Test
    public void shouldLockUpdatedNodes() throws Exception {
        NodeStore nodeStore = this.neoStore.getNodeStore();
        long[] nodes = new long[]{nodeStore.nextId(), nodeStore.nextId(), nodeStore.nextId(), nodeStore.nextId(), nodeStore.nextId(), nodeStore.nextId(), nodeStore.nextId()};
        try (LockGroup lockGroup = new LockGroup();){
            TransactionRecordState tx = (TransactionRecordState)this.newWriteTransaction().first();
            for (int i = 1; i < nodes.length - 1; ++i) {
                tx.nodeCreate(nodes[i]);
            }
            tx.nodeAddProperty(nodes[3], 0, (Object)"old");
            tx.nodeAddProperty(nodes[4], 0, (Object)"old");
            this.commitProcess().commit((TransactionRepresentation)this.transactionRepresentationOf(tx), lockGroup, this.commitEvent, TransactionApplicationMode.INTERNAL);
            Mockito.reset((Object[])new LockService[]{this.locks});
        }
        TransactionRecordState tx = (TransactionRecordState)this.newWriteTransaction().first();
        tx.nodeCreate(nodes[0]);
        tx.addLabelToNode(0, nodes[1]);
        tx.nodeAddProperty(nodes[2], 0, (Object)"value");
        tx.nodeChangeProperty(nodes[3], 0, (Object)"value");
        tx.nodeRemoveProperty(nodes[4], 0);
        tx.nodeDelete(nodes[5]);
        tx.nodeCreate(nodes[6]);
        tx.addLabelToNode(0, nodes[6]);
        tx.nodeAddProperty(nodes[6], 0, (Object)"value");
        try (LockGroup locks = new LockGroup();){
            this.commitProcess().commit((TransactionRepresentation)this.transactionRepresentationOf(tx), locks, this.commitEvent, TransactionApplicationMode.INTERNAL);
        }
        ((LockService)Mockito.verify((Object)this.locks, (VerificationMode)Mockito.times((int)1))).acquireNodeLock(nodes[0], LockService.LockType.WRITE_LOCK);
        ((LockService)Mockito.verify((Object)this.locks, (VerificationMode)Mockito.times((int)1))).acquireNodeLock(nodes[1], LockService.LockType.WRITE_LOCK);
        ((LockService)Mockito.verify((Object)this.locks, (VerificationMode)Mockito.times((int)2))).acquireNodeLock(nodes[2], LockService.LockType.WRITE_LOCK);
        ((LockService)Mockito.verify((Object)this.locks, (VerificationMode)Mockito.times((int)1))).acquireNodeLock(nodes[3], LockService.LockType.WRITE_LOCK);
        ((LockService)Mockito.verify((Object)this.locks, (VerificationMode)Mockito.times((int)2))).acquireNodeLock(nodes[4], LockService.LockType.WRITE_LOCK);
        ((LockService)Mockito.verify((Object)this.locks, (VerificationMode)Mockito.times((int)1))).acquireNodeLock(nodes[5], LockService.LockType.WRITE_LOCK);
        ((LockService)Mockito.verify((Object)this.locks, (VerificationMode)Mockito.times((int)2))).acquireNodeLock(nodes[6], LockService.LockType.WRITE_LOCK);
    }

    @Test
    public void shouldConvertToDenseNodeRepresentationWhenHittingThresholdWithDifferentTypes() throws Exception {
        this.resetFileSystem();
        this.instantiateNeoStore(50);
        Pair<TransactionRecordState, NeoStoreTransactionContext> transactionContextPair = this.newWriteTransaction();
        TransactionRecordState tx = (TransactionRecordState)transactionContextPair.first();
        NeoStoreTransactionContext txCtx = (NeoStoreTransactionContext)transactionContextPair.other();
        long nodeId = this.nextId(IdType.NODE);
        int typeA = 0;
        int typeB = 1;
        int typeC = 2;
        tx.nodeCreate(nodeId);
        tx.createRelationshipTypeToken("A", typeA);
        this.createRelationships(tx, nodeId, typeA, Direction.OUTGOING, 6);
        this.createRelationships(tx, nodeId, typeA, Direction.INCOMING, 7);
        tx.createRelationshipTypeToken("B", typeB);
        this.createRelationships(tx, nodeId, typeB, Direction.OUTGOING, 8);
        this.createRelationships(tx, nodeId, typeB, Direction.INCOMING, 9);
        tx.createRelationshipTypeToken("C", typeC);
        this.createRelationships(tx, nodeId, typeC, Direction.OUTGOING, 10);
        this.createRelationships(tx, nodeId, typeC, Direction.INCOMING, 10);
        Assert.assertFalse((boolean)((NodeRecord)txCtx.getNodeRecords().getOrLoad((Object)nodeId, null).forReadingData()).isDense());
        this.createRelationships(tx, nodeId, typeC, Direction.INCOMING, 1);
        Assert.assertTrue((boolean)((NodeRecord)txCtx.getNodeRecords().getOrLoad((Object)nodeId, null).forReadingData()).isDense());
        NeoStoreTransactionTest.assertDenseRelationshipCounts(tx, txCtx, nodeId, typeA, 6, 7);
        NeoStoreTransactionTest.assertDenseRelationshipCounts(tx, txCtx, nodeId, typeB, 8, 9);
        NeoStoreTransactionTest.assertDenseRelationshipCounts(tx, txCtx, nodeId, typeC, 10, 11);
    }

    @Test
    public void shouldConvertToDenseNodeRepresentationWhenHittingThresholdWithTheSameTypeDifferentDirection() throws Exception {
        this.resetFileSystem();
        this.instantiateNeoStore(49);
        Pair<TransactionRecordState, NeoStoreTransactionContext> transactionContextPair = this.newWriteTransaction();
        TransactionRecordState tx = (TransactionRecordState)transactionContextPair.first();
        NeoStoreTransactionContext txCtx = (NeoStoreTransactionContext)transactionContextPair.other();
        long nodeId = this.nextId(IdType.NODE);
        int typeA = 0;
        tx.nodeCreate(nodeId);
        tx.createRelationshipTypeToken("A", typeA);
        this.createRelationships(tx, nodeId, typeA, Direction.OUTGOING, 24);
        this.createRelationships(tx, nodeId, typeA, Direction.INCOMING, 25);
        Assert.assertFalse((boolean)((NodeRecord)txCtx.getNodeRecords().getOrLoad((Object)nodeId, null).forReadingData()).isDense());
        this.createRelationships(tx, nodeId, typeA, Direction.INCOMING, 1);
        Assert.assertTrue((boolean)((NodeRecord)txCtx.getNodeRecords().getOrLoad((Object)nodeId, null).forReadingData()).isDense());
        NeoStoreTransactionTest.assertDenseRelationshipCounts(tx, txCtx, nodeId, typeA, 24, 26);
    }

    @Test
    public void shouldConvertToDenseNodeRepresentationWhenHittingThresholdWithTheSameTypeSameDirection() throws Exception {
        this.resetFileSystem();
        this.instantiateNeoStore(8);
        Pair<TransactionRecordState, NeoStoreTransactionContext> transactionContextPair = this.newWriteTransaction();
        TransactionRecordState tx = (TransactionRecordState)transactionContextPair.first();
        NeoStoreTransactionContext txCtx = (NeoStoreTransactionContext)transactionContextPair.other();
        long nodeId = this.nextId(IdType.NODE);
        int typeA = 0;
        tx.nodeCreate(nodeId);
        tx.createRelationshipTypeToken("A", typeA);
        this.createRelationships(tx, nodeId, typeA, Direction.OUTGOING, 8);
        Assert.assertFalse((boolean)((NodeRecord)txCtx.getNodeRecords().getOrLoad((Object)nodeId, null).forReadingData()).isDense());
        this.createRelationships(tx, nodeId, typeA, Direction.OUTGOING, 1);
        Assert.assertTrue((boolean)((NodeRecord)txCtx.getNodeRecords().getOrLoad((Object)nodeId, null).forReadingData()).isDense());
        NeoStoreTransactionTest.assertDenseRelationshipCounts(tx, txCtx, nodeId, typeA, 9, 0);
    }

    @Test
    public void shouldMaintainCorrectDataWhenDeletingFromDenseNodeWithOneType() throws Exception {
        this.resetFileSystem();
        this.instantiateNeoStore(13);
        Pair<TransactionRecordState, NeoStoreTransactionContext> transactionContextPair = this.newWriteTransaction();
        TransactionRecordState tx = (TransactionRecordState)transactionContextPair.first();
        NeoStoreTransactionContext txCtx = (NeoStoreTransactionContext)transactionContextPair.other();
        int nodeId = (int)this.nextId(IdType.NODE);
        int typeA = 0;
        tx.nodeCreate((long)nodeId);
        tx.createRelationshipTypeToken("A", typeA);
        long[] relationshipsCreated = this.createRelationships(tx, nodeId, typeA, Direction.INCOMING, 15);
        this.deleteRelationship(tx, relationshipsCreated[0]);
        NeoStoreTransactionTest.assertDenseRelationshipCounts(tx, txCtx, nodeId, typeA, 0, 14);
    }

    @Test
    public void shouldMaintainCorrectDataWhenDeletingFromDenseNodeWithManyTypes() throws Exception {
        this.resetFileSystem();
        this.instantiateNeoStore(1);
        Pair<TransactionRecordState, NeoStoreTransactionContext> transactionAndContextPair = this.newWriteTransaction();
        TransactionRecordState tx = (TransactionRecordState)transactionAndContextPair.first();
        NeoStoreTransactionContext txCtx = (NeoStoreTransactionContext)transactionAndContextPair.other();
        long nodeId = this.nextId(IdType.NODE);
        int typeA = 0;
        int typeB = 12;
        int typeC = 600;
        tx.nodeCreate(nodeId);
        tx.createRelationshipTypeToken("A", typeA);
        long[] relationshipsCreatedAIncoming = this.createRelationships(tx, nodeId, typeA, Direction.INCOMING, 1);
        long[] relationshipsCreatedAOutgoing = this.createRelationships(tx, nodeId, typeA, Direction.OUTGOING, 1);
        tx.createRelationshipTypeToken("B", typeB);
        long[] relationshipsCreatedBIncoming = this.createRelationships(tx, nodeId, typeB, Direction.INCOMING, 1);
        long[] relationshipsCreatedBOutgoing = this.createRelationships(tx, nodeId, typeB, Direction.OUTGOING, 1);
        tx.createRelationshipTypeToken("C", typeC);
        long[] relationshipsCreatedCIncoming = this.createRelationships(tx, nodeId, typeC, Direction.INCOMING, 1);
        long[] relationshipsCreatedCOutgoing = this.createRelationships(tx, nodeId, typeC, Direction.OUTGOING, 1);
        this.deleteRelationship(tx, relationshipsCreatedAIncoming[0]);
        NeoStoreTransactionTest.assertDenseRelationshipCounts(tx, txCtx, nodeId, typeA, 1, 0);
        NeoStoreTransactionTest.assertDenseRelationshipCounts(tx, txCtx, nodeId, typeB, 1, 1);
        NeoStoreTransactionTest.assertDenseRelationshipCounts(tx, txCtx, nodeId, typeC, 1, 1);
        this.deleteRelationship(tx, relationshipsCreatedAOutgoing[0]);
        NeoStoreTransactionTest.assertRelationshipGroupDoesNotExist(txCtx, (NodeRecord)txCtx.getNodeRecords().getOrLoad((Object)nodeId, null).forReadingData(), typeA);
        NeoStoreTransactionTest.assertDenseRelationshipCounts(tx, txCtx, nodeId, typeB, 1, 1);
        NeoStoreTransactionTest.assertDenseRelationshipCounts(tx, txCtx, nodeId, typeC, 1, 1);
        this.deleteRelationship(tx, relationshipsCreatedBIncoming[0]);
        NeoStoreTransactionTest.assertRelationshipGroupDoesNotExist(txCtx, (NodeRecord)txCtx.getNodeRecords().getOrLoad((Object)nodeId, null).forReadingData(), typeA);
        NeoStoreTransactionTest.assertDenseRelationshipCounts(tx, txCtx, nodeId, typeB, 1, 0);
        NeoStoreTransactionTest.assertDenseRelationshipCounts(tx, txCtx, nodeId, typeC, 1, 1);
        this.deleteRelationship(tx, relationshipsCreatedBOutgoing[0]);
        NeoStoreTransactionTest.assertRelationshipGroupDoesNotExist(txCtx, (NodeRecord)txCtx.getNodeRecords().getOrLoad((Object)nodeId, null).forReadingData(), typeA);
        NeoStoreTransactionTest.assertRelationshipGroupDoesNotExist(txCtx, (NodeRecord)txCtx.getNodeRecords().getOrLoad((Object)nodeId, null).forReadingData(), typeB);
        NeoStoreTransactionTest.assertDenseRelationshipCounts(tx, txCtx, nodeId, typeC, 1, 1);
        this.deleteRelationship(tx, relationshipsCreatedCIncoming[0]);
        NeoStoreTransactionTest.assertRelationshipGroupDoesNotExist(txCtx, (NodeRecord)txCtx.getNodeRecords().getOrLoad((Object)nodeId, null).forReadingData(), typeA);
        NeoStoreTransactionTest.assertRelationshipGroupDoesNotExist(txCtx, (NodeRecord)txCtx.getNodeRecords().getOrLoad((Object)nodeId, null).forReadingData(), typeB);
        NeoStoreTransactionTest.assertDenseRelationshipCounts(tx, txCtx, nodeId, typeC, 1, 0);
        this.deleteRelationship(tx, relationshipsCreatedCOutgoing[0]);
        NeoStoreTransactionTest.assertRelationshipGroupDoesNotExist(txCtx, (NodeRecord)txCtx.getNodeRecords().getOrLoad((Object)nodeId, null).forReadingData(), typeA);
        NeoStoreTransactionTest.assertRelationshipGroupDoesNotExist(txCtx, (NodeRecord)txCtx.getNodeRecords().getOrLoad((Object)nodeId, null).forReadingData(), typeB);
        NeoStoreTransactionTest.assertRelationshipGroupDoesNotExist(txCtx, (NodeRecord)txCtx.getNodeRecords().getOrLoad((Object)nodeId, null).forReadingData(), typeC);
    }

    @Test
    public void movingBilaterallyOfTheDenseNodeThresholdIsConsistent() throws Exception {
        long[] relationshipsOfTypeB;
        this.resetFileSystem();
        this.instantiateNeoStore(10);
        long nodeId = this.neoStore.getNodeStore().nextId();
        TransactionRecordState writeTransaction = (TransactionRecordState)this.newWriteTransaction().first();
        writeTransaction.nodeCreate(nodeId);
        int typeA = (int)this.neoStore.getRelationshipTypeTokenStore().nextId();
        writeTransaction.createRelationshipTypeToken("A", typeA);
        this.createRelationships(writeTransaction, nodeId, typeA, Direction.INCOMING, 20);
        try (LockGroup locks = new LockGroup();){
            this.commitProcess().commit((TransactionRepresentation)this.transactionRepresentationOf(writeTransaction), locks, this.commitEvent, TransactionApplicationMode.INTERNAL);
        }
        writeTransaction = (TransactionRecordState)this.newWriteTransaction().first();
        int typeB = 1;
        writeTransaction.createRelationshipTypeToken("B", typeB);
        for (long relationshipToDelete : relationshipsOfTypeB = this.createRelationships(writeTransaction, nodeId, typeB, Direction.OUTGOING, 5)) {
            this.deleteRelationship(writeTransaction, relationshipToDelete);
        }
        PhysicalTransactionRepresentation tx = this.transactionRepresentationOf(writeTransaction);
        try (LockGroup locks = new LockGroup();){
            this.commitProcess().commit((TransactionRepresentation)tx, locks, this.commitEvent, TransactionApplicationMode.INTERNAL);
        }
        final AtomicBoolean foundRelationshipGroupInUse = new AtomicBoolean();
        tx.accept((Visitor)new NeoCommandHandler.HandlerVisitor((NeoCommandHandler)new NeoCommandHandler.Adapter(){

            public boolean visitRelationshipGroupCommand(Command.RelationshipGroupCommand command) throws IOException {
                if (command.getRecord().inUse()) {
                    if (!foundRelationshipGroupInUse.get()) {
                        foundRelationshipGroupInUse.set(true);
                    } else {
                        Assert.fail();
                    }
                }
                return false;
            }
        }));
        Assert.assertTrue((String)"Did not create relationship group command", (boolean)foundRelationshipGroupInUse.get());
    }

    @Test
    public void shouldSortRelationshipGroups() throws Exception {
        long otherNodeId;
        TransactionRecordState tx;
        this.resetFileSystem();
        this.instantiateNeoStore(1);
        int type5 = 5;
        int type10 = 10;
        int type15 = 15;
        try (LockGroup locks = new LockGroup();){
            TransactionRecordState tx2 = (TransactionRecordState)this.newWriteTransaction().first();
            this.neoStore.getRelationshipTypeTokenStore().setHighId(16L);
            tx2.createRelationshipTypeToken("5", type5);
            tx2.createRelationshipTypeToken("10", type10);
            tx2.createRelationshipTypeToken("15", type15);
            this.commitProcess().commit((TransactionRepresentation)this.transactionRepresentationOf(tx2), locks, this.commitEvent, TransactionApplicationMode.INTERNAL);
        }
        long nodeId = this.neoStore.getNodeStore().nextId();
        try (LockGroup locks = new LockGroup();){
            tx = (TransactionRecordState)this.newWriteTransaction().first();
            long otherNode1Id = this.neoStore.getNodeStore().nextId();
            long otherNode2Id = this.neoStore.getNodeStore().nextId();
            tx.nodeCreate(nodeId);
            tx.nodeCreate(otherNode1Id);
            tx.nodeCreate(otherNode2Id);
            tx.relCreate(this.neoStore.getRelationshipStore().nextId(), type10, nodeId, otherNode1Id);
            tx.relCreate(this.neoStore.getRelationshipStore().nextId(), type10, nodeId, otherNode2Id);
            this.commitProcess().commit((TransactionRepresentation)this.transactionRepresentationOf(tx), locks, this.commitEvent, TransactionApplicationMode.INTERNAL);
            this.assertRelationshipGroupsInOrder(nodeId, type10);
        }
        locks = new LockGroup();
        var7_11 = null;
        try {
            tx = (TransactionRecordState)this.newWriteTransaction().first();
            otherNodeId = this.neoStore.getNodeStore().nextId();
            tx.nodeCreate(otherNodeId);
            tx.relCreate(this.neoStore.getRelationshipStore().nextId(), type5, nodeId, otherNodeId);
            this.commitProcess().commit((TransactionRepresentation)this.transactionRepresentationOf(tx), locks, this.commitEvent, TransactionApplicationMode.INTERNAL);
        }
        catch (Throwable x2) {
            var7_11 = x2;
            throw x2;
        }
        finally {
            if (locks != null) {
                if (var7_11 != null) {
                    try {
                        locks.close();
                    }
                    catch (Throwable x2) {
                        var7_11.addSuppressed(x2);
                    }
                } else {
                    locks.close();
                }
            }
        }
        this.assertRelationshipGroupsInOrder(nodeId, type5, type10);
        locks = new LockGroup();
        var7_11 = null;
        try {
            tx = (TransactionRecordState)this.newWriteTransaction().first();
            otherNodeId = this.neoStore.getNodeStore().nextId();
            tx.nodeCreate(otherNodeId);
            tx.relCreate(this.neoStore.getRelationshipStore().nextId(), type15, nodeId, otherNodeId);
            this.commitProcess().commit((TransactionRepresentation)this.transactionRepresentationOf(tx), locks, this.commitEvent, TransactionApplicationMode.INTERNAL);
        }
        catch (Throwable throwable) {
            var7_11 = throwable;
            throw throwable;
        }
        finally {
            if (locks != null) {
                if (var7_11 != null) {
                    try {
                        locks.close();
                    }
                    catch (Throwable x2) {
                        var7_11.addSuppressed(x2);
                    }
                } else {
                    locks.close();
                }
            }
        }
        this.assertRelationshipGroupsInOrder(nodeId, type5, type10, type15);
    }

    private void assertRelationshipGroupsInOrder(long nodeId, int ... types) {
        NodeRecord node = this.neoStore.getNodeStore().getRecord(nodeId);
        Assert.assertTrue((String)("Node should be dense, is " + node), (boolean)node.isDense());
        long groupId = node.getNextRel();
        int cursor = 0;
        ArrayList<RelationshipGroupRecord> seen = new ArrayList<RelationshipGroupRecord>();
        while (groupId != (long)Record.NO_NEXT_RELATIONSHIP.intValue()) {
            RelationshipGroupRecord group = this.neoStore.getRelationshipGroupStore().getRecord(groupId);
            seen.add(group);
            Assert.assertEquals((String)("Invalid type, seen groups so far " + seen), (long)types[cursor++], (long)group.getType());
            groupId = group.getNext();
        }
        Assert.assertEquals((String)("Not enough relationship group records found in chain for " + node), (long)types.length, (long)cursor);
    }

    private long nextId(IdType type) {
        return this.idGeneratorFactory.get(type).nextId();
    }

    private long[] createRelationships(TransactionRecordState tx, long nodeId, int type, Direction direction, int count) {
        long[] result = new long[count];
        for (int i = 0; i < count; ++i) {
            long relId;
            long otherNodeId = this.nextId(IdType.NODE);
            tx.nodeCreate(otherNodeId);
            long first = direction == Direction.OUTGOING ? nodeId : otherNodeId;
            long other = direction == Direction.INCOMING ? nodeId : otherNodeId;
            result[i] = relId = this.nextId(IdType.RELATIONSHIP);
            tx.relCreate(relId, type, first, other);
        }
        return result;
    }

    private void deleteRelationship(TransactionRecordState tx, long relId) {
        tx.relDelete(relId);
    }

    private String string(int length) {
        StringBuilder result = new StringBuilder();
        int ch = 97;
        for (int i = 0; i < length; ++i) {
            result.append((char)(ch + i % 10));
        }
        return result.toString();
    }

    @Before
    public void before() throws Exception {
        this.fs = new EphemeralFileSystemAbstraction();
        this.pageCache = pageCacheRule.getPageCache((FileSystemAbstraction)this.fs);
        this.instantiateNeoStore(Integer.parseInt(GraphDatabaseSettings.dense_node_threshold.getDefaultValue()));
    }

    private void instantiateNeoStore(int denseNodeThreshold) throws Exception {
        this.config = new Config(MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.dense_node_threshold.name(), "" + denseNodeThreshold}));
        File storeDir = new File("dir");
        this.config = StoreFactory.configForStoreDir((Config)this.config, (File)storeDir);
        StoreFactory storeFactory = new StoreFactory(this.config, (IdGeneratorFactory)this.idGeneratorFactory, this.pageCache, (FileSystemAbstraction)this.fs, StringLogger.DEV_NULL, new Monitors());
        this.neoStore = storeFactory.createNeoStore();
        this.neoStore.rebuildCountStoreIfNeeded();
        this.lockMocks.clear();
        this.locks = (LockService)Mockito.mock(LockService.class, (Answer)new Answer(){

            public synchronized Object answer(InvocationOnMock invocation) throws Throwable {
                if (invocation.getMethod().getName().equals("acquireNodeLock")) {
                    Lock mock = (Lock)Mockito.mock(Lock.class, (Answer)new Answer(){

                        public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
                            return null;
                        }
                    });
                    NeoStoreTransactionTest.this.lockMocks.add(mock);
                    return mock;
                }
                return null;
            }
        });
        this.cacheAccessBackDoor = (CacheAccessBackDoor)Mockito.mock(CacheAccessBackDoor.class);
        this.mockIndexing = (IndexingService)Mockito.mock(IndexingService.class);
        ((IndexingService)Mockito.doReturn((Object)ValidatedIndexUpdates.NONE).when((Object)this.mockIndexing)).validate((Iterable)Matchers.any(Iterable.class));
    }

    private TransactionRepresentationCommitProcess commitProcess() throws IOException {
        return this.commitProcess(this.mockIndexing);
    }

    private TransactionRepresentationCommitProcess commitProcess(IndexingService indexing) throws IOException {
        return this.commitProcess(indexing, TransactionApplicationMode.INTERNAL);
    }

    private TransactionRepresentationCommitProcess commitProcess(IndexingService indexing, TransactionApplicationMode mode) throws IOException {
        TransactionAppender appenderMock = (TransactionAppender)Mockito.mock(TransactionAppender.class);
        Mockito.when((Object)appenderMock.append((TransactionRepresentation)Matchers.any(), (LogAppendEvent)Matchers.any(LogAppendEvent.class))).thenReturn((Object)this.nextTxId++);
        LogicalTransactionStore txStoreMock = (LogicalTransactionStore)Mockito.mock(LogicalTransactionStore.class);
        Mockito.when((Object)txStoreMock.getAppender()).thenReturn((Object)appenderMock);
        Provider labelScanStore = (Provider)Mockito.mock(Provider.class);
        Mockito.when((Object)labelScanStore.instance()).thenReturn(Mockito.mock(LabelScanWriter.class));
        TransactionRepresentationStoreApplier applier = new TransactionRepresentationStoreApplier(indexing, labelScanStore, this.neoStore, this.cacheAccessBackDoor, this.locks, null, null, null);
        this.neoStore.nextCommittingTransactionId();
        PropertyLoader propertyLoader = new PropertyLoader(this.neoStore);
        return new TransactionRepresentationCommitProcess(txStoreMock, (KernelHealth)Mockito.mock(KernelHealth.class), (TransactionIdStore)this.neoStore, applier, new IndexUpdatesValidator(this.neoStore, propertyLoader, indexing));
    }

    @After
    public void shouldReleaseAllLocks() {
        for (Lock lock : this.lockMocks) {
            ((Lock)Mockito.verify((Object)lock)).release();
        }
        this.neoStore.close();
    }

    public void resetFileSystem() {
        if (this.neoStore != null) {
            this.neoStore.close();
        }
        this.fs = new EphemeralFileSystemAbstraction();
        this.pageCache = pageCacheRule.getPageCache((FileSystemAbstraction)this.fs);
    }

    private Pair<TransactionRecordState, NeoStoreTransactionContext> newWriteTransaction() {
        return this.newWriteTransaction(this.mockIndexing);
    }

    private Pair<TransactionRecordState, NeoStoreTransactionContext> newWriteTransaction(IndexingService indexing) {
        NeoStoreTransactionContext context = new NeoStoreTransactionContext((NeoStoreTransactionContextSupplier)Mockito.mock(NeoStoreTransactionContextSupplier.class), this.neoStore);
        context.bind((Locks.Client)Mockito.mock(Locks.Client.class));
        TransactionRecordState result = new TransactionRecordState(this.neoStore, new IntegrityValidator(this.neoStore, indexing), context);
        return Pair.of((Object)result, (Object)context);
    }

    private void commit(TransactionRepresentation recoveredTx, TransactionApplicationMode mode) throws Exception {
        LabelScanStore labelScanStore = (LabelScanStore)Mockito.mock(LabelScanStore.class);
        Mockito.when((Object)labelScanStore.newWriter()).thenReturn(Mockito.mock(LabelScanWriter.class));
        try (LockGroup locks = new LockGroup();){
            this.commitProcess().commit(recoveredTx, locks, CommitEvent.NULL, mode);
        }
    }

    private CapturingIndexingService createCapturingIndexingService() {
        NeoStoreIndexStoreView storeView = new NeoStoreIndexStoreView(this.locks, this.neoStore);
        DefaultSchemaIndexProviderMap providerMap = new DefaultSchemaIndexProviderMap(SchemaIndexProvider.NO_INDEX_PROVIDER);
        SingleLoggingService logging = new SingleLoggingService(StringLogger.DEV_NULL);
        IndexingService.Monitor monitor = IndexingService.NO_MONITOR;
        KernelSchemaStateStore schemaState = new KernelSchemaStateStore(logging.getMessagesLog(KernelSchemaStateStore.class));
        IndexSamplingConfig samplingConfig = new IndexSamplingConfig(new Config());
        TokenNameLookup tokenNameLookup = (TokenNameLookup)Mockito.mock(TokenNameLookup.class);
        IndexMapReference indexMapRef = new IndexMapReference();
        IndexSamplingControllerFactory samplingFactory = new IndexSamplingControllerFactory(samplingConfig, (IndexStoreView)storeView, null, tokenNameLookup, (Logging)logging);
        IndexProxySetup proxySetup = new IndexProxySetup(samplingConfig, (IndexStoreView)storeView, (SchemaIndexProviderMap)providerMap, (UpdateableSchemaState)schemaState, null, null, (Logging)logging);
        IndexSamplingController samplingController = samplingFactory.create((IndexMapSnapshotProvider)indexMapRef);
        return new CapturingIndexingService(proxySetup, (SchemaIndexProviderMap)providerMap, indexMapRef, (IndexStoreView)storeView, Collections.emptyList(), samplingController, (Logging)logging, monitor);
    }

    private class IteratorCollector<T>
    implements Answer<Object> {
        private final int arg;
        private final List<T> elements = new ArrayList<T>();

        public IteratorCollector(int arg) {
            this.arg = arg;
        }

        @SafeVarargs
        public final void assertContent(T ... expected) {
            Assert.assertEquals(Arrays.asList(expected), this.elements);
        }

        public Object answer(InvocationOnMock invocation) throws Throwable {
            Iterator iterator = invocation.getArguments()[this.arg];
            if (iterator instanceof Iterable) {
                iterator = ((Iterable)((Object)iterator)).iterator();
            }
            if (iterator instanceof Iterator) {
                this.collect(iterator);
            }
            return ValidatedIndexUpdates.NONE;
        }

        private void collect(Iterator<T> iterator) {
            while (iterator.hasNext()) {
                this.elements.add(iterator.next());
            }
        }
    }

    private class CapturingIndexingService
    extends IndexingService {
        private final Set<NodePropertyUpdate> updates;

        public CapturingIndexingService(IndexProxySetup proxySetup, SchemaIndexProviderMap providerMap, IndexMapReference indexMapRef, IndexStoreView storeView, Iterable<IndexRule> indexRules, IndexSamplingController samplingController, Logging logging, IndexingService.Monitor monitor) {
            super(proxySetup, providerMap, indexMapRef, storeView, indexRules, samplingController, null, logging, monitor);
            this.updates = new HashSet<NodePropertyUpdate>();
        }

        public ValidatedIndexUpdates validate(Iterable<NodePropertyUpdate> indexUpdates) {
            this.updates.addAll(IteratorUtil.asCollection(indexUpdates));
            return ValidatedIndexUpdates.NONE;
        }
    }

    public static class RecoveryCreatingCopyingNeoCommandHandler
    implements Visitor<Command, IOException> {
        private final List<Command> commands = new LinkedList<Command>();

        public boolean visit(Command element) throws IOException {
            this.commands.add(element);
            return false;
        }

        public TransactionRepresentation getAsRecovered() {
            return new PhysicalTransactionRepresentation(this.commands);
        }
    }
}

