/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.traversal;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PathExpanders;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.impl.traversal.TraversalTestBase;

public class TestConstantDirectionExpander
extends TraversalTestBase {
    private Transaction tx;

    @Before
    public void createGraph() {
        this.createGraph("l A m", "m A n", "o A n", "p B o", "q B p");
        this.tx = this.beginTx();
    }

    @After
    public void tearDown() {
        this.tx.close();
    }

    @Test
    public void pathWithConstantDirection() {
        Node l = this.getNodeWithName("l");
        this.expectPaths(this.getGraphDb().traversalDescription().expand(PathExpanders.forConstantDirectionWithTypes((RelationshipType[])new RelationshipType[]{Types.A})).traverse(l), "l", "l,m", "l,m,n");
        Node n = this.getNodeWithName("n");
        this.expectPaths(this.getGraphDb().traversalDescription().expand(PathExpanders.forConstantDirectionWithTypes((RelationshipType[])new RelationshipType[]{Types.A})).traverse(n), "n", "n,m", "n,m,l", "n,o");
        Node q = this.getNodeWithName("q");
        this.expectPaths(this.getGraphDb().traversalDescription().expand(PathExpanders.forConstantDirectionWithTypes((RelationshipType[])new RelationshipType[]{Types.B})).traverse(q), "q", "q,p", "q,p,o");
    }

    private static enum Types implements RelationshipType
    {
        A,
        B;

    }
}

