/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.traversal;

import java.util.Iterator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipExpander;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.OrderedByTypeExpander;
import org.neo4j.kernel.StandardExpander;
import org.neo4j.kernel.Traversal;
import org.neo4j.kernel.impl.traversal.TraversalTestBase;

public class TestOrderByTypeExpander
extends TraversalTestBase {
    private final RelationshipType next = DynamicRelationshipType.withName((String)"NEXT");
    private final RelationshipType firstComment = DynamicRelationshipType.withName((String)"FIRST_COMMENT");
    private final RelationshipType comment = DynamicRelationshipType.withName((String)"COMMENT");

    @Before
    public void setup() {
        this.createGraph("A1 NEXT A2", "A2 NEXT A3", "A1 FIRST_COMMENT C1", "C1 COMMENT C2", "C2 COMMENT C3", "A2 FIRST_COMMENT C4", "C4 COMMENT C5", "C5 COMMENT C6", "A3 FIRST_COMMENT C7", "C7 COMMENT C8", "C8 COMMENT C9");
    }

    @Test
    public void makeSureNodesAreTraversedInCorrectOrder() {
        StandardExpander expander = new OrderedByTypeExpander().add(this.firstComment).add(this.comment).add(this.next);
        ResourceIterator itr = Traversal.traversal().depthFirst().expand((RelationshipExpander)expander).traverse(this.node("A1")).nodes().iterator();
        this.assertOrder((Iterator<Node>)itr, "A1", "C1", "C2", "C3", "A2", "C4", "C5", "C6", "A3", "C7", "C8", "C9");
        expander = new OrderedByTypeExpander().add(this.next).add(this.firstComment).add(this.comment);
        itr = Traversal.traversal().depthFirst().expand((RelationshipExpander)expander).traverse(this.node("A1")).nodes().iterator();
        this.assertOrder((Iterator<Node>)itr, "A1", "A2", "A3", "C7", "C8", "C9", "C4", "C5", "C6", "C1", "C2", "C3");
    }

    @Test
    public void evenDifferentDirectionsKeepsOrder() throws Exception {
        StandardExpander expander = new OrderedByTypeExpander().add(this.next, Direction.INCOMING).add(this.firstComment).add(this.comment).add(this.next, Direction.OUTGOING);
        ResourceIterator itr = Traversal.traversal().depthFirst().expand((RelationshipExpander)expander).traverse(this.node("A2")).nodes().iterator();
        this.assertOrder((Iterator<Node>)itr, "A2", "A1", "C1", "C2", "C3", "C4", "C5", "C6", "A3", "C7", "C8", "C9");
    }

    private void assertOrder(Iterator<Node> itr, String ... names) {
        Transaction tx = this.beginTx();
        for (String name : names) {
            Node node = itr.next();
            Assert.assertEquals((String)("expected " + name + ", was " + node.getProperty("name")), (Object)this.getNodeWithName(name), (Object)node);
        }
        Assert.assertFalse((boolean)itr.hasNext());
        tx.success();
        tx.finish();
    }
}

