/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.neo4j.cursor.Cursor;
import org.neo4j.graphdb.Direction;
import org.neo4j.kernel.impl.util.register.NeoRegister;
import org.neo4j.register.Register;

public class ExpandTestUtils {
    public static List<Row> rows(Cursor cursor, NeoRegister.RelationshipRegister relId, NeoRegister.RelTypeRegister relType, Register.ObjectRegister<Direction> direction, NeoRegister.NodeRegister startId, NeoRegister.NodeRegister neighborId) {
        ArrayList<Row> result = new ArrayList<Row>();
        while (cursor.next()) {
            result.add(ExpandTestUtils.row(relId.read(), relType.read(), (Direction)direction.read(), startId.read(), neighborId.read()));
        }
        Collections.sort(result, new Comparator<Row>(){

            @Override
            public int compare(Row o1, Row o2) {
                if (o1.relId == o2.relId) {
                    return (int)(o1.neighborId - o2.neighborId);
                }
                return (int)(o1.relId - o2.relId);
            }
        });
        return result;
    }

    public static Row row(long relId, int relType, Direction direction, long startId, long neighborId) {
        return new Row(relId, relType, direction, startId, neighborId);
    }

    public static class Row {
        public final long relId;
        public final int type;
        public final Direction direction;
        public final long startId;
        public final long neighborId;

        public Row(long relId, int type, Direction direction, long startId, long neighborId) {
            this.relId = relId;
            this.type = type;
            this.direction = direction;
            this.startId = startId;
            this.neighborId = neighborId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Row row = (Row)o;
            if (this.neighborId != row.neighborId) {
                return false;
            }
            if (this.relId != row.relId) {
                return false;
            }
            if (this.type != row.type) {
                return false;
            }
            if (this.startId != row.startId) {
                return false;
            }
            return this.direction == row.direction;
        }

        public int hashCode() {
            int result = (int)(this.relId ^ this.relId >>> 32);
            result = 31 * result + this.type;
            result = 31 * result + (this.direction != null ? this.direction.hashCode() : 0);
            result = 31 * result + (int)(this.startId ^ this.startId >>> 32);
            result = 31 * result + (int)(this.neighborId ^ this.neighborId >>> 32);
            return result;
        }

        public String toString() {
            return "row( " + this.relId + ", " + this.type + ", " + this.direction + ", " + this.startId + ", " + this.neighborId + ')';
        }
    }
}

