/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.impl.util.HexPrinter;

public class HexPrinterTest {
    @Test
    public void shouldPrintACoupleOfLines() throws Exception {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(outStream);
        HexPrinter printer = new HexPrinter(out, 2, 8);
        for (byte value = 0; value < 20; value = (byte)(value + 1)) {
            printer.append(value);
        }
        out.flush();
        Assert.assertEquals((Object)String.format("00 00 01 02 03 04 05 06 07%n01 08 09 0A 0B 0C 0D 0E 0F%n02 10 11 12 13", new Object[0]), (Object)outStream.toString());
    }

    @Test
    public void shouldMakeClearEightByteBorders() throws Exception {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(outStream);
        HexPrinter printer = new HexPrinter(out, 3, 12);
        for (byte value = 0; value < 30; value = (byte)(value + 1)) {
            printer.append(value);
        }
        out.flush();
        Assert.assertEquals((Object)String.format("000 00 01 02 03 04 05 06 07  08 09 0A 0B%n001 0C 0D 0E 0F 10 11 12 13  14 15 16 17%n002 18 19 1A 1B 1C 1D", new Object[0]), (Object)outStream.toString());
    }
}

