/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.util.HashMap;
import java.util.Map;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.impl.util.TestLogger;
import org.neo4j.kernel.logging.ConsoleLogger;
import org.neo4j.kernel.logging.Logging;

public class TestLogging
implements Logging {
    private Map<Class, TestLogger> messageLoggers = new HashMap<Class, TestLogger>();
    private Map<Class, TestLogger> consoleLoggers = new HashMap<Class, TestLogger>();

    public TestLogger getMessagesLog(Class loggingClass) {
        if (!this.messageLoggers.containsKey(loggingClass)) {
            this.messageLoggers.put(loggingClass, new TestLogger());
        }
        return this.messageLoggers.get(loggingClass);
    }

    public ConsoleLogger getConsoleLog(Class loggingClass) {
        if (!this.consoleLoggers.containsKey(loggingClass)) {
            this.consoleLoggers.put(loggingClass, new TestLogger());
        }
        return new ConsoleLogger((StringLogger)this.consoleLoggers.get(loggingClass));
    }

    public TestLogger getDelegatedConsoleLog(Class loggingClass) {
        return this.consoleLoggers.get(loggingClass);
    }

    public void init() throws Throwable {
    }

    public void start() throws Throwable {
    }

    public void stop() throws Throwable {
    }

    public void shutdown() throws Throwable {
    }

    private void visitLog(TestLogger logger, Visitor<TestLogger.LogCall, RuntimeException> logVisitor) {
        if (logger != null) {
            logger.visitLogCalls(logVisitor);
        }
    }

    public void visitMessagesLog(Class loggingClass, Visitor<TestLogger.LogCall, RuntimeException> logVisitor) {
        this.visitLog(this.messageLoggers.get(loggingClass), logVisitor);
    }

    public void visitConsoleLog(Class loggingClass, Visitor<TestLogger.LogCall, RuntimeException> logVisitor) {
        this.visitLog(this.consoleLoggers.get(loggingClass), logVisitor);
    }
}

