/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.info;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.info.CannedJvmMetadataRepository;
import org.neo4j.kernel.info.JvmChecker;
import org.neo4j.kernel.info.JvmMetadataRepository;
import org.neo4j.kernel.logging.BufferingLogger;

public class JVMCheckerTest {
    @Test
    public void shouldNotIssueWarningWhenUsingHotspotServerVmVersion7() throws Exception {
        BufferingLogger bufferingLogger = new BufferingLogger();
        new JvmChecker((StringLogger)bufferingLogger, (JvmMetadataRepository)new CannedJvmMetadataRepository("Java HotSpot(TM) 64-Bit Server VM", "1.7.0-b147")).checkJvmCompatibilityAndIssueWarning();
        Assert.assertTrue((boolean)bufferingLogger.toString().isEmpty());
    }

    @Test
    public void shouldNotIssueWarningWhenUsingHotspotServerVmVersion8() throws Exception {
        BufferingLogger bufferingLogger = new BufferingLogger();
        new JvmChecker((StringLogger)bufferingLogger, (JvmMetadataRepository)new CannedJvmMetadataRepository("Java HotSpot(TM) 64-Bit Server VM", "1.8.0_45")).checkJvmCompatibilityAndIssueWarning();
        Assert.assertTrue((boolean)bufferingLogger.toString().isEmpty());
    }

    @Test
    public void shouldNotIssueWarningWhenUsingHotspotServerVmVersion7InThe32BitVersion() throws Exception {
        BufferingLogger bufferingLogger = new BufferingLogger();
        new JvmChecker((StringLogger)bufferingLogger, (JvmMetadataRepository)new CannedJvmMetadataRepository("Java HotSpot(TM) Server VM", "1.7.0_25-b15")).checkJvmCompatibilityAndIssueWarning();
        Assert.assertTrue((boolean)bufferingLogger.toString().isEmpty());
    }

    @Test
    public void shouldNotIssueWarningWhenUsingOpenJDKServerVmVersion7() throws Exception {
        BufferingLogger bufferingLogger = new BufferingLogger();
        new JvmChecker((StringLogger)bufferingLogger, (JvmMetadataRepository)new CannedJvmMetadataRepository("OpenJDK 64-Bit Server VM", "1.7.0-b147")).checkJvmCompatibilityAndIssueWarning();
        Assert.assertTrue((boolean)bufferingLogger.toString().isEmpty());
    }

    @Test
    public void shouldNotIssueWarningWhenUsingOpenJDKClientVmVersion7() throws Exception {
        BufferingLogger bufferingLogger = new BufferingLogger();
        new JvmChecker((StringLogger)bufferingLogger, (JvmMetadataRepository)new CannedJvmMetadataRepository("OpenJDK Client VM", "1.7.0-b147")).checkJvmCompatibilityAndIssueWarning();
        Assert.assertTrue((boolean)bufferingLogger.toString().isEmpty());
    }

    @Test
    public void shouldIssueWarningWhenUsingUnsupportedJvm() throws Exception {
        BufferingLogger bufferingLogger = new BufferingLogger();
        new JvmChecker((StringLogger)bufferingLogger, (JvmMetadataRepository)new CannedJvmMetadataRepository("MyOwnJDK 64-Bit Awesome VM", "1.7")).checkJvmCompatibilityAndIssueWarning();
        Assert.assertThat((Object)bufferingLogger.toString().trim(), (Matcher)Is.is((Object)"You are using an unsupported Java runtime. Please use Oracle(R) Java(TM) Runtime Environment 7 or 8 or OpenJDK(TM) 7 or 8."));
    }

    @Test
    public void shouldIssueWarningWhenUsingUnsupportedJvmVersion() throws Exception {
        BufferingLogger bufferingLogger = new BufferingLogger();
        new JvmChecker((StringLogger)bufferingLogger, (JvmMetadataRepository)new CannedJvmMetadataRepository("Java HotSpot(TM) 64-Bit Server VM", "1.6.42_87")).checkJvmCompatibilityAndIssueWarning();
        Assert.assertThat((Object)bufferingLogger.toString().trim(), (Matcher)Is.is((Object)"You are using an unsupported version of the Java runtime. Please use Oracle(R) Java(TM) Runtime Environment 7 or 8 or OpenJDK(TM) 7 or 8."));
    }
}

