/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import org.neo4j.helpers.Function;

public abstract class AlgebraicFunction<FROM, TO>
implements Function<FROM, TO> {
    private final String repr;

    public <NEXT> AlgebraicFunction<FROM, NEXT> then(final Function<TO, NEXT> function) {
        return new AlgebraicFunction<FROM, NEXT>(this.repr + " then " + function.toString()){

            public NEXT apply(FROM from) {
                return function.apply(AlgebraicFunction.this.apply(from));
            }
        };
    }

    public AlgebraicFunction() {
        String repr = this.getClass().getSimpleName();
        if (this.getClass().isAnonymousClass()) {
            for (StackTraceElement trace : Thread.currentThread().getStackTrace()) {
                if (trace.getClassName().equals(Thread.class.getName()) && trace.getMethodName().equals("getStackTrace") || trace.getClassName().equals(AlgebraicFunction.class.getName()) || trace.getClassName().equals(this.getClass().getName())) continue;
                repr = trace.getMethodName();
                break;
            }
        }
        this.repr = repr;
    }

    private AlgebraicFunction(String repr) {
        this.repr = repr;
    }

    public String toString() {
        return this.repr;
    }
}

