/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import org.hamcrest.Matcher;
import org.junit.Test;
import org.mockito.ArgumentMatcher;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.kernel.impl.api.CountsAccessor;
import org.neo4j.unsafe.impl.batchimport.RelationshipCountsProcessor;
import org.neo4j.unsafe.impl.batchimport.cache.NodeLabelsCache;
import org.neo4j.unsafe.impl.batchimport.cache.NumberArrayFactory;

public class RelationshipCountsProcessorTest {
    @Test
    public void shouldHandleBigNumberOfLabelsAndRelationshipTypes() throws Exception {
        int relTypeCount = 256;
        int labelCount = 0x400000;
        NumberArrayFactory numberArrayFactory = (NumberArrayFactory)Mockito.mock(NumberArrayFactory.class);
        new RelationshipCountsProcessor((NodeLabelsCache)Mockito.mock(NodeLabelsCache.class), labelCount, relTypeCount, (CountsAccessor.Updater)Mockito.mock(CountsAccessor.Updater.class), numberArrayFactory);
        ((NumberArrayFactory)Mockito.verify((Object)numberArrayFactory, (VerificationMode)Mockito.times((int)1))).newLongArray(Matchers.longThat((Matcher)new IsNonNegativeLong()), Matchers.anyLong());
    }

    private class IsNonNegativeLong
    extends ArgumentMatcher<Long> {
        private IsNonNegativeLong() {
        }

        public boolean matches(Object theLong) {
            return theLong != null && (Long)theLong >= 0L;
        }
    }
}

