/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.input;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import junit.framework.TestCase;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.collection.primitive.PrimitiveLongSet;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.test.EphemeralFileSystemRule;
import org.neo4j.unsafe.impl.batchimport.input.BadCollector;
import org.neo4j.unsafe.impl.batchimport.input.InputException;
import org.neo4j.unsafe.impl.batchimport.input.InputRelationship;

public class BadCollectorTest {
    @Rule
    public final EphemeralFileSystemRule fs = new EphemeralFileSystemRule();

    @Test
    public void shouldCollectBadRelationshipsEvenIfThresholdNeverReached() throws IOException {
        int tolerance = 5;
        BadCollector badCollector = new BadCollector(this.badOutputFile(), tolerance, 3);
        badCollector.collectBadRelationship(InputRelationshipBuilder.inputRelationship().build(), (Object)2);
        Assert.assertEquals((long)1L, (long)badCollector.badEntries());
    }

    @Test
    public void shouldThrowExceptionIfNoToleranceThresholdIsExceeded() throws IOException {
        int tolerance = 0;
        BadCollector badCollector = new BadCollector(this.badOutputFile(), tolerance, 3);
        try {
            badCollector.collectBadRelationship(InputRelationshipBuilder.inputRelationship().build(), (Object)2);
            TestCase.fail((String)"Should have thrown an InputException");
        }
        catch (InputException inputException) {
            // empty catch block
        }
    }

    @Test
    public void shouldThrowExceptionIfDuplicateNodeTipsUsOverTheToleranceEdge() throws IOException {
        int tolerance = 1;
        BadCollector badCollector = new BadCollector(this.badOutputFile(), tolerance, 3);
        badCollector.collectBadRelationship(InputRelationshipBuilder.inputRelationship().build(), (Object)2);
        try {
            badCollector.collectDuplicateNode((Object)1, 1L, "group", "source", "otherSource");
            TestCase.fail((String)"Should have thrown an InputException");
        }
        catch (InputException inputException) {
            // empty catch block
        }
    }

    @Test
    public void shouldThrowExceptionIfBadRelationshipsTipsUsOverTheToleranceEdge() throws IOException {
        int tolerance = 1;
        BadCollector badCollector = new BadCollector(this.badOutputFile(), tolerance, 3);
        badCollector.collectDuplicateNode((Object)1, 1L, "group", "source", "otherSource");
        try {
            badCollector.collectBadRelationship(InputRelationshipBuilder.inputRelationship().build(), (Object)2);
            TestCase.fail((String)"Should have thrown an InputException");
        }
        catch (InputException inputException) {
            // empty catch block
        }
    }

    @Test
    public void shouldNotCollectBadRelationshipsIfWeShouldOnlyBeCollectingNodes() throws IOException {
        int tolerance = 1;
        BadCollector badCollector = new BadCollector(this.badOutputFile(), tolerance, 2);
        badCollector.collectDuplicateNode((Object)1, 1L, "group", "source", "otherSource");
        try {
            badCollector.collectBadRelationship(InputRelationshipBuilder.inputRelationship().build(), (Object)2);
        }
        catch (InputException ignored) {
            Assert.assertEquals((long)1L, (long)badCollector.badEntries());
        }
    }

    @Test
    public void shouldNotCollectBadNodesIfWeShouldOnlyBeCollectingRelationships() throws IOException {
        int tolerance = 1;
        BadCollector badCollector = new BadCollector(this.badOutputFile(), tolerance, 1);
        badCollector.collectBadRelationship(InputRelationshipBuilder.inputRelationship().build(), (Object)2);
        try {
            badCollector.collectDuplicateNode((Object)1, 1L, "group", "source", "otherSource");
        }
        catch (InputException ignored) {
            Assert.assertEquals((long)1L, (long)badCollector.badEntries());
        }
    }

    @Test
    public void shouldBeAbleToRetrieveDuplicateNodeIds() throws IOException {
        int tolerance = 15;
        BadCollector badCollector = new BadCollector(this.badOutputFile(), tolerance, 3);
        for (int i = 0; i < 15; ++i) {
            badCollector.collectDuplicateNode((Object)i, (long)i, "group", "source" + i, "otherSource" + i);
        }
        Assert.assertEquals((long)15L, (long)PrimitiveLongCollections.count((PrimitiveLongIterator)badCollector.leftOverDuplicateNodesIds()));
        PrimitiveLongSet longs = PrimitiveLongCollections.asSet((PrimitiveLongIterator)badCollector.leftOverDuplicateNodesIds());
        for (int i = 0; i < 15; ++i) {
            Assert.assertTrue((boolean)longs.contains((long)i));
        }
    }

    private OutputStream badOutputFile() throws IOException {
        File badDataPath = new File("/tmp/foo2").getAbsoluteFile();
        EphemeralFileSystemAbstraction fileSystem = this.fs.get();
        File badDataFile = this.badDataFile((FileSystemAbstraction)fileSystem, badDataPath);
        return fileSystem.openAsOutputStream(badDataFile, true);
    }

    private File badDataFile(FileSystemAbstraction fileSystem, File badDataPath) throws IOException {
        fileSystem.mkdir(badDataPath.getParentFile());
        fileSystem.create(badDataPath);
        return badDataPath;
    }

    static class InputRelationshipBuilder {
        private String sourceDescription = "foo";
        private int lineNumber = 1;
        private int position = 1;
        private Object[] properties = new Object[0];
        private long firstPropertyId = -1L;
        private Object startNode = null;
        private Object endNode = null;
        private String friend = "FRIEND";
        private int typeId = 1;

        InputRelationshipBuilder() {
        }

        public static InputRelationshipBuilder inputRelationship() {
            return new InputRelationshipBuilder();
        }

        InputRelationship build() {
            return new InputRelationship(this.sourceDescription, (long)this.lineNumber, (long)this.position, this.properties, Long.valueOf(this.firstPropertyId), this.startNode, this.endNode, this.friend, Integer.valueOf(this.typeId));
        }
    }
}

