/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.input.csv;

import java.io.Reader;
import java.io.StringReader;
import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.csv.reader.BufferedCharSeeker;
import org.neo4j.csv.reader.CharSeeker;
import org.neo4j.csv.reader.Configuration;
import org.neo4j.csv.reader.Extractor;
import org.neo4j.csv.reader.Extractors;
import org.neo4j.csv.reader.Readables;
import org.neo4j.function.Function;
import org.neo4j.function.Functions;
import org.neo4j.helpers.ArrayUtil;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.test.TargetDirectory;
import org.neo4j.unsafe.impl.batchimport.InputIterator;
import org.neo4j.unsafe.impl.batchimport.input.Collectors;
import org.neo4j.unsafe.impl.batchimport.input.DataException;
import org.neo4j.unsafe.impl.batchimport.input.Group;
import org.neo4j.unsafe.impl.batchimport.input.Groups;
import org.neo4j.unsafe.impl.batchimport.input.InputEntity;
import org.neo4j.unsafe.impl.batchimport.input.InputEntityDecorators;
import org.neo4j.unsafe.impl.batchimport.input.InputException;
import org.neo4j.unsafe.impl.batchimport.input.InputNode;
import org.neo4j.unsafe.impl.batchimport.input.InputRelationship;
import org.neo4j.unsafe.impl.batchimport.input.csv.Configuration;
import org.neo4j.unsafe.impl.batchimport.input.csv.CsvInput;
import org.neo4j.unsafe.impl.batchimport.input.csv.Data;
import org.neo4j.unsafe.impl.batchimport.input.csv.DataFactories;
import org.neo4j.unsafe.impl.batchimport.input.csv.DataFactory;
import org.neo4j.unsafe.impl.batchimport.input.csv.Header;
import org.neo4j.unsafe.impl.batchimport.input.csv.IdType;
import org.neo4j.unsafe.impl.batchimport.input.csv.Type;

public class CsvInputTest {
    private static final org.neo4j.csv.reader.Configuration SEEKER_CONFIG = new Configuration.Overridden((org.neo4j.csv.reader.Configuration)new Configuration.Default()){

        public int bufferSize() {
            return 1000;
        }
    };
    @Rule
    public final TargetDirectory.TestDirectory directory = TargetDirectory.testDirForTest(this.getClass());
    private final Extractors extractors = new Extractors(',');

    @Test
    public void shouldProvideNodesFromCsvInput() throws Exception {
        IdType idType = IdType.ACTUAL;
        Iterable data = this.dataIterable(CsvInputTest.data("123,Mattias Persson,HACKER"));
        CsvInput input = new CsvInput(data, this.header(this.entry(null, Type.ID, idType.extractor(this.extractors)), this.entry("name", Type.PROPERTY, this.extractors.string()), this.entry("labels", Type.LABEL, this.extractors.string())), null, null, idType, Configuration.COMMAS, Collectors.badCollector((int)0));
        InputIterator nodes = input.nodes().iterator();
        this.assertNode((InputNode)nodes.next(), 123L, this.properties("name", "Mattias Persson"), this.labels("HACKER"));
        Assert.assertFalse((boolean)nodes.hasNext());
    }

    @Test
    public void shouldProvideRelationshipsFromCsvInput() throws Exception {
        IdType idType = IdType.STRING;
        Iterable data = this.dataIterable(CsvInputTest.data("node1,node2,KNOWS,1234567\nnode2,node10,HACKS,987654"));
        CsvInput input = new CsvInput(null, null, data, this.header(this.entry("from", Type.START_ID, idType.extractor(this.extractors)), this.entry("to", Type.END_ID, idType.extractor(this.extractors)), this.entry("type", Type.TYPE, this.extractors.string()), this.entry("since", Type.PROPERTY, (Extractor<?>)this.extractors.long_())), idType, Configuration.COMMAS, Collectors.badCollector((int)0));
        InputIterator relationships = input.relationships().iterator();
        this.assertRelationship((InputRelationship)relationships.next(), "node1", "node2", "KNOWS", this.properties("since", 1234567L));
        this.assertRelationship((InputRelationship)relationships.next(), "node2", "node10", "HACKS", this.properties("since", 987654L));
    }

    @Test
    public void shouldCloseDataIteratorsInTheEnd() throws Exception {
        CharSeeker nodeData = (CharSeeker)Mockito.spy((Object)CsvInputTest.charSeeker("1"));
        CharSeeker relationshipData = (CharSeeker)Mockito.spy((Object)CsvInputTest.charSeeker("1,1"));
        IdType idType = IdType.STRING;
        Iterable nodeDataIterable = this.dataIterable(this.given(nodeData));
        Iterable relationshipDataIterable = this.dataIterable(this.data(relationshipData, InputEntityDecorators.defaultRelationshipType((String)"TYPE")));
        CsvInput input = new CsvInput(nodeDataIterable, this.header(this.entry(null, Type.ID, idType.extractor(this.extractors))), relationshipDataIterable, this.header(this.entry(null, Type.START_ID, idType.extractor(this.extractors)), this.entry(null, Type.END_ID, idType.extractor(this.extractors))), idType, Configuration.COMMAS, Collectors.badCollector((int)0));
        try (InputIterator iterator = input.nodes().iterator();){
            iterator.next();
        }
        iterator = input.relationships().iterator();
        var8_8 = null;
        try {
            iterator.next();
        }
        catch (Throwable throwable) {
            var8_8 = throwable;
            throw throwable;
        }
        finally {
            if (iterator != null) {
                if (var8_8 != null) {
                    try {
                        iterator.close();
                    }
                    catch (Throwable x2) {
                        var8_8.addSuppressed(x2);
                    }
                } else {
                    iterator.close();
                }
            }
        }
        ((CharSeeker)Mockito.verify((Object)nodeData, (VerificationMode)Mockito.times((int)1))).close();
        ((CharSeeker)Mockito.verify((Object)relationshipData, (VerificationMode)Mockito.times((int)1))).close();
    }

    @Test
    public void shouldCopeWithLinesThatHasTooFewValuesButStillValidates() throws Exception {
        Iterable data = this.dataIterable(CsvInputTest.data("1,ultralisk,ZERG,10\n2,corruptor,ZERG\n3,mutalisk,ZERG,3"));
        CsvInput input = new CsvInput(data, this.header(this.entry(null, Type.ID, (Extractor<?>)this.extractors.long_()), this.entry("unit", Type.PROPERTY, this.extractors.string()), this.entry("type", Type.LABEL, this.extractors.string()), this.entry("kills", Type.PROPERTY, (Extractor<?>)this.extractors.int_())), null, null, IdType.ACTUAL, Configuration.COMMAS, Collectors.badCollector((int)0));
        try (InputIterator nodes = input.nodes().iterator();){
            this.assertNode((InputNode)nodes.next(), 1L, new Object[]{"unit", "ultralisk", "kills", 10}, this.labels("ZERG"));
            this.assertNode((InputNode)nodes.next(), 2L, new Object[]{"unit", "corruptor"}, this.labels("ZERG"));
            this.assertNode((InputNode)nodes.next(), 3L, new Object[]{"unit", "mutalisk", "kills", 3}, this.labels("ZERG"));
            Assert.assertFalse((boolean)nodes.hasNext());
        }
    }

    @Test
    public void shouldIgnoreValuesAfterHeaderEntries() throws Exception {
        Iterable data = this.dataIterable(CsvInputTest.data("1,zergling,bubble,bobble\n2,scv,pun,intended"));
        CsvInput input = new CsvInput(data, this.header(this.entry(null, Type.ID, (Extractor<?>)this.extractors.long_()), this.entry("name", Type.PROPERTY, this.extractors.string())), null, null, IdType.ACTUAL, Configuration.COMMAS, Collectors.badCollector((int)0));
        try (InputIterator nodes = input.nodes().iterator();){
            this.assertNode((InputNode)nodes.next(), 1L, new Object[]{"name", "zergling"}, this.labels(new String[0]));
            this.assertNode((InputNode)nodes.next(), 2L, new Object[]{"name", "scv"}, this.labels(new String[0]));
            Assert.assertFalse((boolean)nodes.hasNext());
        }
    }

    @Test
    public void shouldHandleMultipleInputGroups() throws Exception {
        DataFactory group1 = CsvInputTest.data(":ID,name,kills:int,health:int\n1,Jim,10,100\n2,Abathur,0,200\n");
        DataFactory group2 = CsvInputTest.data(":ID,type\n3,zergling\n4,csv\n");
        Iterable data = this.dataIterable(group1, group2);
        CsvInput input = new CsvInput(data, DataFactories.defaultFormatNodeFileHeader(), null, null, IdType.STRING, Configuration.COMMAS, Collectors.badCollector((int)0));
        InputIterator nodes = input.nodes().iterator();
        this.assertNode((InputNode)nodes.next(), "1", this.properties("name", "Jim", "kills", 10, "health", 100), this.labels(new String[0]));
        this.assertNode((InputNode)nodes.next(), "2", this.properties("name", "Abathur", "kills", 0, "health", 200), this.labels(new String[0]));
        this.assertNode((InputNode)nodes.next(), "3", this.properties("type", "zergling"), this.labels(new String[0]));
        this.assertNode((InputNode)nodes.next(), "4", this.properties("type", "csv"), this.labels(new String[0]));
        Assert.assertFalse((boolean)nodes.hasNext());
    }

    @Test
    public void shouldProvideAdditiveLabels() throws Exception {
        Object[] addedLabels = new String[]{"Two", "AddTwo"};
        DataFactory data = CsvInputTest.data(":ID,name,:LABEL\n0,First,\n1,Second,One\n2,Third,One;Two", InputEntityDecorators.additiveLabels((String[])addedLabels));
        Iterable dataIterable = this.dataIterable(data);
        CsvInput input = new CsvInput(dataIterable, DataFactories.defaultFormatNodeFileHeader(), null, null, IdType.ACTUAL, Configuration.COMMAS, Collectors.badCollector((int)0));
        try (InputIterator nodes = input.nodes().iterator();){
            this.assertNode((InputNode)nodes.next(), 0L, this.properties("name", "First"), this.labels((String[])addedLabels));
            this.assertNode((InputNode)nodes.next(), 1L, this.properties("name", "Second"), this.labels((String[])ArrayUtil.union((Object[])new String[]{"One"}, (Object[])addedLabels)));
            this.assertNode((InputNode)nodes.next(), 2L, this.properties("name", "Third"), this.labels((String[])ArrayUtil.union((Object[])new String[]{"One"}, (Object[])addedLabels)));
            Assert.assertFalse((boolean)nodes.hasNext());
        }
    }

    @Test
    public void shouldProvideDefaultRelationshipType() throws Exception {
        String defaultType = "DEFAULT";
        String customType = "CUSTOM";
        DataFactory data = CsvInputTest.data(":START_ID,:END_ID,:TYPE\n0,1,\n1,2," + customType + "\n" + "2,1," + defaultType, InputEntityDecorators.defaultRelationshipType((String)defaultType));
        Iterable dataIterable = this.dataIterable(data);
        CsvInput input = new CsvInput(null, null, dataIterable, DataFactories.defaultFormatRelationshipFileHeader(), IdType.ACTUAL, Configuration.COMMAS, Collectors.badCollector((int)0));
        try (InputIterator relationships = input.relationships().iterator();){
            this.assertRelationship((InputRelationship)relationships.next(), 0L, 1L, defaultType, InputEntity.NO_PROPERTIES);
            this.assertRelationship((InputRelationship)relationships.next(), 1L, 2L, customType, InputEntity.NO_PROPERTIES);
            this.assertRelationship((InputRelationship)relationships.next(), 2L, 1L, defaultType, InputEntity.NO_PROPERTIES);
            Assert.assertFalse((boolean)relationships.hasNext());
        }
    }

    @Test
    public void shouldFailOnMissingRelationshipType() throws Exception {
        String type = "CUSTOM";
        DataFactory data = CsvInputTest.data(":START_ID,:END_ID,:TYPE\n0,1," + type + "\n" + "1,2,");
        Iterable dataIterable = this.dataIterable(data);
        CsvInput input = new CsvInput(null, null, dataIterable, DataFactories.defaultFormatRelationshipFileHeader(), IdType.ACTUAL, Configuration.COMMAS, Collectors.badCollector((int)0));
        try (InputIterator relationships = input.relationships().iterator();){
            this.assertRelationship((InputRelationship)relationships.next(), 0L, 1L, type, InputEntity.NO_PROPERTIES);
            try {
                relationships.next();
                Assert.fail((String)"Should have failed");
            }
            catch (DataException e) {
                Assert.assertTrue((boolean)e.getMessage().contains(Type.TYPE.name()));
            }
        }
    }

    @Test
    public void shouldAllowNodesWithoutIdHeader() throws Exception {
        DataFactory data = CsvInputTest.data("name:string,level:int\nMattias,1\nJohan,2\n");
        Iterable dataIterable = this.dataIterable(data);
        CsvInput input = new CsvInput(dataIterable, DataFactories.defaultFormatNodeFileHeader(), null, null, IdType.STRING, Configuration.COMMAS, Collectors.badCollector((int)0));
        try (InputIterator nodes = input.nodes().iterator();){
            this.assertNode((InputNode)nodes.next(), null, new Object[]{"name", "Mattias", "level", 1}, this.labels(new String[0]));
            this.assertNode((InputNode)nodes.next(), null, new Object[]{"name", "Johan", "level", 2}, this.labels(new String[0]));
            Assert.assertFalse((boolean)nodes.hasNext());
        }
    }

    @Test
    public void shouldAllowSomeNodesToBeAnonymous() throws Exception {
        DataFactory data = CsvInputTest.data(":ID,name:string,level:int\nabc,Mattias,1\n,Johan,2\n");
        Iterable dataIterable = this.dataIterable(data);
        CsvInput input = new CsvInput(dataIterable, DataFactories.defaultFormatNodeFileHeader(), null, null, IdType.STRING, Configuration.COMMAS, Collectors.badCollector((int)0));
        try (InputIterator nodes = input.nodes().iterator();){
            this.assertNode((InputNode)nodes.next(), "abc", new Object[]{"name", "Mattias", "level", 1}, this.labels(new String[0]));
            this.assertNode((InputNode)nodes.next(), null, new Object[]{"name", "Johan", "level", 2}, this.labels(new String[0]));
            Assert.assertFalse((boolean)nodes.hasNext());
        }
    }

    @Test
    public void shouldAllowNodesToBeAnonymousEvenIfIdHeaderIsNamed() throws Exception {
        DataFactory data = CsvInputTest.data("id:ID,name:string,level:int\nabc,Mattias,1\n,Johan,2\n");
        Iterable dataIterable = this.dataIterable(data);
        CsvInput input = new CsvInput(dataIterable, DataFactories.defaultFormatNodeFileHeader(), null, null, IdType.STRING, Configuration.COMMAS, Collectors.badCollector((int)0));
        try (InputIterator nodes = input.nodes().iterator();){
            this.assertNode((InputNode)nodes.next(), "abc", new Object[]{"id", "abc", "name", "Mattias", "level", 1}, this.labels(new String[0]));
            this.assertNode((InputNode)nodes.next(), null, new Object[]{"name", "Johan", "level", 2}, this.labels(new String[0]));
            Assert.assertFalse((boolean)nodes.hasNext());
        }
    }

    @Test
    public void shouldHaveIdSetAsPropertyIfIdHeaderEntryIsNamed() throws Exception {
        DataFactory data = CsvInputTest.data("myId:ID,name:string,level:int\nabc,Mattias,1\ndef,Johan,2\n");
        Iterable dataIterable = this.dataIterable(data);
        CsvInput input = new CsvInput(dataIterable, DataFactories.defaultFormatNodeFileHeader(), null, null, IdType.STRING, Configuration.COMMAS, Collectors.badCollector((int)0));
        try (InputIterator nodes = input.nodes().iterator();){
            this.assertNode((InputNode)nodes.next(), "abc", new Object[]{"myId", "abc", "name", "Mattias", "level", 1}, this.labels(new String[0]));
            this.assertNode((InputNode)nodes.next(), "def", new Object[]{"myId", "def", "name", "Johan", "level", 2}, this.labels(new String[0]));
            Assert.assertFalse((boolean)nodes.hasNext());
        }
    }

    @Test
    public void shouldNotHaveIdSetAsPropertyIfIdHeaderEntryIsNamedForActualIds() throws Exception {
        DataFactory data = CsvInputTest.data("myId:ID,name:string,level:int\n0,Mattias,1\n1,Johan,2\n");
        Iterable dataIterable = this.dataIterable(data);
        CsvInput input = new CsvInput(dataIterable, DataFactories.defaultFormatNodeFileHeader(), null, null, IdType.ACTUAL, Configuration.COMMAS, Collectors.badCollector((int)0));
        try (InputIterator nodes = input.nodes().iterator();){
            this.assertNode((InputNode)nodes.next(), 0L, new Object[]{"name", "Mattias", "level", 1}, this.labels(new String[0]));
            this.assertNode((InputNode)nodes.next(), 1L, new Object[]{"name", "Johan", "level", 2}, this.labels(new String[0]));
            Assert.assertFalse((boolean)nodes.hasNext());
        }
    }

    @Test
    public void shouldIgnoreEmptyPropertyValues() throws Exception {
        DataFactory data = CsvInputTest.data(":ID,name,extra\n0,Mattias,\n1,Johan,Additional\n");
        Iterable dataIterable = this.dataIterable(data);
        CsvInput input = new CsvInput(dataIterable, DataFactories.defaultFormatNodeFileHeader(), null, null, IdType.ACTUAL, Configuration.COMMAS, Collectors.badCollector((int)0));
        try (InputIterator nodes = input.nodes().iterator();){
            this.assertNode((InputNode)nodes.next(), 0L, new Object[]{"name", "Mattias"}, this.labels(new String[0]));
            this.assertNode((InputNode)nodes.next(), 1L, new Object[]{"name", "Johan", "extra", "Additional"}, this.labels(new String[0]));
            Assert.assertFalse((boolean)nodes.hasNext());
        }
    }

    @Test
    public void shouldIgnoreEmptyIntPropertyValues() throws Exception {
        DataFactory data = CsvInputTest.data(":ID,name,extra:int\n0,Mattias,\n1,Johan,10\n");
        Iterable dataIterable = this.dataIterable(data);
        CsvInput input = new CsvInput(dataIterable, DataFactories.defaultFormatNodeFileHeader(), null, null, IdType.ACTUAL, Configuration.COMMAS, Collectors.badCollector((int)0));
        try (InputIterator nodes = input.nodes().iterator();){
            this.assertNode((InputNode)nodes.next(), 0L, new Object[]{"name", "Mattias"}, this.labels(new String[0]));
            this.assertNode((InputNode)nodes.next(), 1L, new Object[]{"name", "Johan", "extra", 10}, this.labels(new String[0]));
            Assert.assertFalse((boolean)nodes.hasNext());
        }
    }

    @Test
    public void shouldFailOnArrayDelimiterBeingSameAsDelimiter() throws Exception {
        try {
            new CsvInput(null, null, null, null, IdType.ACTUAL, this.customConfig(',', ',', '\"'), Collectors.badCollector((int)0));
            Assert.fail((String)"Should not be possible");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("array delimiter"));
        }
    }

    @Test
    public void shouldFailOnQuotationCharacterBeingSameAsDelimiter() throws Exception {
        try {
            new CsvInput(null, null, null, null, IdType.ACTUAL, this.customConfig(',', ';', ','), Collectors.badCollector((int)0));
            Assert.fail((String)"Should not be possible");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("delimiter"));
            Assert.assertTrue((boolean)e.getMessage().contains("quotation"));
        }
    }

    @Test
    public void shouldFailOnQuotationCharacterBeingSameAsArrayDelimiter() throws Exception {
        try {
            new CsvInput(null, null, null, null, IdType.ACTUAL, this.customConfig(',', ';', ';'), Collectors.badCollector((int)0));
            Assert.fail((String)"Should not be possible");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("array delimiter"));
            Assert.assertTrue((boolean)e.getMessage().contains("quotation"));
        }
    }

    @Test
    public void shouldHaveNodesBelongToGroupSpecifiedInHeader() throws Exception {
        IdType idType = IdType.ACTUAL;
        Iterable data = this.dataIterable(CsvInputTest.data("123,one\n456,two"));
        Groups groups = new Groups();
        Group group = groups.getOrCreate("MyGroup");
        CsvInput input = new CsvInput(data, this.header(this.entry(null, Type.ID, group.name(), idType.extractor(this.extractors)), this.entry("name", Type.PROPERTY, this.extractors.string())), null, null, idType, Configuration.COMMAS, Collectors.badCollector((int)0));
        InputIterator nodes = input.nodes().iterator();
        this.assertNode((InputNode)nodes.next(), group, 123L, this.properties("name", "one"), this.labels(new String[0]));
        this.assertNode((InputNode)nodes.next(), group, 456L, this.properties("name", "two"), this.labels(new String[0]));
        Assert.assertFalse((boolean)nodes.hasNext());
    }

    @Test
    public void shouldHaveRelationshipsSpecifyStartEndNodeIdGroupsInHeader() throws Exception {
        IdType idType = IdType.ACTUAL;
        Iterable data = this.dataIterable(CsvInputTest.data("123,TYPE,234\n345,TYPE,456"));
        Groups groups = new Groups();
        Group startNodeGroup = groups.getOrCreate("StartGroup");
        Group endNodeGroup = groups.getOrCreate("EndGroup");
        CsvInput input = new CsvInput(null, null, data, this.header(this.entry(null, Type.START_ID, startNodeGroup.name(), idType.extractor(this.extractors)), this.entry(null, Type.TYPE, this.extractors.string()), this.entry(null, Type.END_ID, endNodeGroup.name(), idType.extractor(this.extractors))), idType, Configuration.COMMAS, Collectors.badCollector((int)0));
        InputIterator relationships = input.relationships().iterator();
        this.assertRelationship((InputRelationship)relationships.next(), startNodeGroup, 123L, endNodeGroup, 234L, "TYPE", this.properties(new Object[0]));
        this.assertRelationship((InputRelationship)relationships.next(), startNodeGroup, 345L, endNodeGroup, 456L, "TYPE", this.properties(new Object[0]));
        Assert.assertFalse((boolean)relationships.hasNext());
    }

    @Test
    public void shouldDoWithoutRelationshipTypeHeaderIfDefaultSupplied() throws Exception {
        String defaultType = "HERE";
        DataFactory data = CsvInputTest.data(":START_ID,:END_ID,name\n0,1,First\n2,3,Second\n", InputEntityDecorators.defaultRelationshipType((String)defaultType));
        Iterable dataIterable = this.dataIterable(data);
        CsvInput input = new CsvInput(null, null, dataIterable, DataFactories.defaultFormatRelationshipFileHeader(), IdType.ACTUAL, Configuration.COMMAS, Collectors.badCollector((int)0));
        try (InputIterator relationships = input.relationships().iterator();){
            this.assertRelationship((InputRelationship)relationships.next(), 0L, 1L, defaultType, this.properties("name", "First"));
            this.assertRelationship((InputRelationship)relationships.next(), 2L, 3L, defaultType, this.properties("name", "Second"));
            Assert.assertFalse((boolean)relationships.hasNext());
        }
    }

    @Test
    public void shouldIncludeDataSourceInformationOnBadFieldValueOrLine() throws Exception {
        Iterable data = DataFactories.nodeData((DataFactory[])new DataFactory[]{CsvInputTest.data(":ID,name,other:int\n1,Mattias,10\n2,Johan,abc\n3,Emil,12")});
        CsvInput input = new CsvInput(data, DataFactories.defaultFormatNodeFileHeader(), null, null, IdType.INTEGER, Configuration.COMMAS, Collectors.badCollector((int)0));
        try (InputIterator nodes = input.nodes().iterator();){
            this.assertNode((InputNode)nodes.next(), 1L, new Object[]{"name", "Mattias", "other", 10}, this.labels(new String[0]));
            try {
                nodes.next();
                Assert.fail((String)"Should have failed");
            }
            catch (InputException e) {
                Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"other"));
                Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"abc"));
            }
        }
    }

    @Test
    public void shouldIgnoreNodeEntriesMarkedIgnoreUsingHeader() throws Exception {
        Iterable data = DataFactories.nodeData((DataFactory[])new DataFactory[]{CsvInputTest.data(":ID,name:IGNORE,other:int,:LABEL\n1,Mattias,10,Person\n2,Johan,111,Person\n3,Emil,12,Person")});
        CsvInput input = new CsvInput(data, DataFactories.defaultFormatNodeFileHeader(), null, null, IdType.INTEGER, Configuration.COMMAS, Collectors.badCollector((int)0));
        try (InputIterator nodes = input.nodes().iterator();){
            this.assertNode((InputNode)nodes.next(), 1L, new Object[]{"other", 10}, this.labels("Person"));
            this.assertNode((InputNode)nodes.next(), 2L, new Object[]{"other", 111}, this.labels("Person"));
            this.assertNode((InputNode)nodes.next(), 3L, new Object[]{"other", 12}, this.labels("Person"));
            Assert.assertFalse((boolean)nodes.hasNext());
        }
    }

    @Test
    public void shouldIgnoreRelationshipEntriesMarkedIgnoreUsingHeader() throws Exception {
        Iterable data = DataFactories.relationshipData((DataFactory[])new DataFactory[]{CsvInputTest.data(":START_ID,:TYPE,:END_ID,prop:IGNORE,other:int\n1,KNOWS,2,Mattias,10\n2,KNOWS,3,Johan,111\n3,KNOWS,4,Emil,12")});
        CsvInput input = new CsvInput(null, null, data, DataFactories.defaultFormatRelationshipFileHeader(), IdType.INTEGER, Configuration.COMMAS, Collectors.badCollector((int)0));
        try (InputIterator relationships = input.relationships().iterator();){
            this.assertRelationship((InputRelationship)relationships.next(), 1L, 2L, "KNOWS", new Object[]{"other", 10});
            this.assertRelationship((InputRelationship)relationships.next(), 2L, 3L, "KNOWS", new Object[]{"other", 111});
            this.assertRelationship((InputRelationship)relationships.next(), 3L, 4L, "KNOWS", new Object[]{"other", 12});
            Assert.assertFalse((boolean)relationships.hasNext());
        }
    }

    @Test
    public void shouldPropagateExceptionFromFailingDecorator() throws Exception {
        RuntimeException failure = new RuntimeException("FAILURE");
        Iterable data = DataFactories.nodeData((DataFactory[])new DataFactory[]{CsvInputTest.data(":ID,name\n1,Mattias", new FailingNodeDecorator(failure))});
        CsvInput input = new CsvInput(data, DataFactories.defaultFormatNodeFileHeader(), null, null, IdType.INTEGER, Configuration.COMMAS, Collectors.badCollector((int)0));
        try (InputIterator nodes = input.nodes().iterator();){
            nodes.next();
        }
        catch (RuntimeException e) {
            Assert.assertTrue((e == failure ? 1 : 0) != 0);
        }
    }

    @Test
    public void shouldNotIncludeEmptyArraysInEntities() throws Exception {
        Iterable data = DataFactories.nodeData((DataFactory[])new DataFactory[]{CsvInputTest.data(":ID,sprop:String[],lprop:long[]\n1,,\n2,a;b,10;20")});
        CsvInput input = new CsvInput(data, DataFactories.defaultFormatNodeFileHeader(), null, null, IdType.INTEGER, Configuration.COMMAS, Collectors.badCollector((int)0));
        try (InputIterator nodes = input.nodes().iterator();){
            this.assertNode((InputNode)nodes.next(), 1L, InputEntity.NO_PROPERTIES, this.labels(new String[0]));
            this.assertNode((InputNode)nodes.next(), 2L, this.properties("sprop", new String[]{"a", "b"}, "lprop", new long[]{10L, 20L}), this.labels(new String[0]));
            Assert.assertFalse((boolean)nodes.hasNext());
        }
    }

    @Test
    public void shouldFailOnRelationshipWithMissingStartIdField() throws Exception {
        Iterable data = DataFactories.relationshipData((DataFactory[])new DataFactory[]{CsvInputTest.data(":START_ID,:END_ID,:TYPE\n,1,")});
        CsvInput input = new CsvInput(null, null, data, DataFactories.defaultFormatRelationshipFileHeader(), IdType.INTEGER, Configuration.COMMAS, Collectors.badCollector((int)0));
        try (InputIterator relationships = input.relationships().iterator();){
            relationships.next();
            Assert.fail((String)"Should have failed");
        }
        catch (InputException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)Type.START_ID.name()));
        }
    }

    @Test
    public void shouldFailOnRelationshipWithMissingEndIdField() throws Exception {
        Iterable data = DataFactories.relationshipData((DataFactory[])new DataFactory[]{CsvInputTest.data(":START_ID,:END_ID,:TYPE\n1,,")});
        CsvInput input = new CsvInput(null, null, data, DataFactories.defaultFormatRelationshipFileHeader(), IdType.INTEGER, Configuration.COMMAS, Collectors.badCollector((int)0));
        try (InputIterator relationships = input.relationships().iterator();){
            relationships.next();
            Assert.fail((String)"Should have failed");
        }
        catch (InputException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)Type.END_ID.name()));
        }
    }

    private Configuration customConfig(final char delimiter, final char arrayDelimiter, final char quote) {
        return new Configuration.Default(){

            public char quotationCharacter() {
                return quote;
            }

            public char delimiter() {
                return delimiter;
            }

            public char arrayDelimiter() {
                return arrayDelimiter;
            }
        };
    }

    private <ENTITY extends InputEntity> DataFactory<ENTITY> given(final CharSeeker data) {
        return new DataFactory<ENTITY>(){

            public Data<ENTITY> create(Configuration config) {
                return CsvInputTest.dataItem(data, Functions.identity());
            }
        };
    }

    private <ENTITY extends InputEntity> DataFactory<ENTITY> data(final CharSeeker data, final Function<ENTITY, ENTITY> decorator) {
        return new DataFactory<ENTITY>(){

            public Data<ENTITY> create(Configuration config) {
                return CsvInputTest.dataItem(data, decorator);
            }
        };
    }

    private static <ENTITY extends InputEntity> Data<ENTITY> dataItem(final CharSeeker data, final Function<ENTITY, ENTITY> decorator) {
        return new Data<ENTITY>(){

            public CharSeeker stream() {
                return data;
            }

            public Function<ENTITY, ENTITY> decorator() {
                return decorator;
            }
        };
    }

    private void assertRelationship(InputRelationship relationship, Object startNode, Object endNode, String type, Object[] properties) {
        this.assertRelationship(relationship, Group.GLOBAL, startNode, Group.GLOBAL, endNode, type, properties);
    }

    private void assertRelationship(InputRelationship relationship, Group startNodeGroup, Object startNode, Group endNodeGroup, Object endNode, String type, Object[] properties) {
        Assert.assertFalse((boolean)relationship.hasSpecificId());
        Assert.assertEquals((Object)startNodeGroup, (Object)relationship.startNodeGroup());
        Assert.assertEquals((Object)startNode, (Object)relationship.startNode());
        Assert.assertEquals((long)endNodeGroup.id(), (long)relationship.endNodeGroup().id());
        Assert.assertEquals((Object)endNode, (Object)relationship.endNode());
        Assert.assertEquals((Object)type, (Object)relationship.type());
        Assert.assertArrayEquals((Object[])properties, (Object[])relationship.properties());
    }

    private void assertNode(InputNode node, Object id, Object[] properties, Set<String> labels) {
        this.assertNode(node, Group.GLOBAL, id, properties, labels);
    }

    private void assertNode(InputNode node, Group group, Object id, Object[] properties, Set<String> labels) {
        Assert.assertEquals((long)group.id(), (long)node.group().id());
        Assert.assertEquals((Object)id, (Object)node.id());
        Assert.assertArrayEquals((Object[])properties, (Object[])node.properties());
        Assert.assertEquals(labels, (Object)IteratorUtil.asSet((Object[])node.labels()));
    }

    private Object[] properties(Object ... keysAndValues) {
        return keysAndValues;
    }

    private Set<String> labels(String ... labels) {
        return IteratorUtil.asSet((Object[])labels);
    }

    private Header.Factory header(final Header.Entry ... entries) {
        return new Header.Factory(){

            public Header create(CharSeeker from, Configuration configuration, IdType idType) {
                return new Header(entries);
            }
        };
    }

    private Header.Entry entry(String name, Type type, Extractor<?> extractor) {
        return this.entry(name, type, null, extractor);
    }

    private Header.Entry entry(String name, Type type, String groupName, Extractor<?> extractor) {
        return new Header.Entry(name, type, groupName, extractor);
    }

    private static <ENTITY extends InputEntity> DataFactory<ENTITY> data(String data) {
        return CsvInputTest.data(data, Functions.identity());
    }

    private static <ENTITY extends InputEntity> DataFactory<ENTITY> data(final String data, final Function<ENTITY, ENTITY> decorator) {
        return new DataFactory<ENTITY>(){

            public Data<ENTITY> create(Configuration config) {
                return CsvInputTest.dataItem(CsvInputTest.charSeeker(data), decorator);
            }
        };
    }

    private static CharSeeker charSeeker(String data) {
        return new BufferedCharSeeker(Readables.wrap((Reader)new StringReader(data)), SEEKER_CONFIG);
    }

    private <ENTITY extends InputEntity> Iterable<DataFactory<ENTITY>> dataIterable(DataFactory ... data) {
        return Iterables.iterable((Object[])data);
    }

    private static class FailingNodeDecorator
    implements Function<InputNode, InputNode> {
        private final RuntimeException failure;

        FailingNodeDecorator(RuntimeException failure) {
            this.failure = failure;
        }

        public InputNode apply(InputNode from) throws RuntimeException {
            throw this.failure;
        }
    }
}

