/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.neo4j.collection.primitive.PrimitiveIntCollections;
import org.neo4j.collection.primitive.PrimitiveIntIterator;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.cursor.Cursor;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Resource;
import org.neo4j.helpers.Predicate;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.api.EntityType;
import org.neo4j.kernel.api.LegacyIndex;
import org.neo4j.kernel.api.LegacyIndexHits;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.constraints.UniquenessConstraint;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.exceptions.LabelNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.PropertyKeyIdNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.RelationshipTypeIdNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.legacyindex.LegacyIndexNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.schema.ConstraintVerificationFailedKernelException;
import org.neo4j.kernel.api.exceptions.schema.CreateConstraintFailureException;
import org.neo4j.kernel.api.exceptions.schema.DropIndexFailureException;
import org.neo4j.kernel.api.exceptions.schema.IllegalTokenNameException;
import org.neo4j.kernel.api.exceptions.schema.IndexBrokenKernelException;
import org.neo4j.kernel.api.exceptions.schema.SchemaRuleNotFoundException;
import org.neo4j.kernel.api.exceptions.schema.TooManyLabelsException;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.api.index.InternalIndexState;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.api.properties.PropertyKeyIdIterator;
import org.neo4j.kernel.api.txstate.ReadableTxState;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.api.LegacyPropertyTrackers;
import org.neo4j.kernel.impl.api.LookupFilter;
import org.neo4j.kernel.impl.api.RelationshipVisitor;
import org.neo4j.kernel.impl.api.operations.CountsOperations;
import org.neo4j.kernel.impl.api.operations.EntityOperations;
import org.neo4j.kernel.impl.api.operations.KeyReadOperations;
import org.neo4j.kernel.impl.api.operations.KeyWriteOperations;
import org.neo4j.kernel.impl.api.operations.LegacyIndexReadOperations;
import org.neo4j.kernel.impl.api.operations.LegacyIndexWriteOperations;
import org.neo4j.kernel.impl.api.operations.SchemaReadOperations;
import org.neo4j.kernel.impl.api.operations.SchemaWriteOperations;
import org.neo4j.kernel.impl.api.state.AugmentWithLocalStateExpandCursor;
import org.neo4j.kernel.impl.api.state.ConstraintIndexCreator;
import org.neo4j.kernel.impl.api.store.StoreReadLayer;
import org.neo4j.kernel.impl.core.Token;
import org.neo4j.kernel.impl.index.IndexEntityType;
import org.neo4j.kernel.impl.index.LegacyIndexStore;
import org.neo4j.kernel.impl.store.SchemaStorage;
import org.neo4j.kernel.impl.util.PrimitiveLongResourceIterator;
import org.neo4j.kernel.impl.util.diffsets.ReadableDiffSets;
import org.neo4j.kernel.impl.util.register.NeoRegister;
import org.neo4j.register.Register;

public class StateHandlingStatementOperations
implements KeyReadOperations,
KeyWriteOperations,
EntityOperations,
SchemaReadOperations,
SchemaWriteOperations,
CountsOperations,
LegacyIndexReadOperations,
LegacyIndexWriteOperations {
    private final StoreReadLayer storeLayer;
    private final LegacyPropertyTrackers legacyPropertyTrackers;
    private final ConstraintIndexCreator constraintIndexCreator;
    private final LegacyIndexStore legacyIndexStore;

    public StateHandlingStatementOperations(StoreReadLayer storeLayer, LegacyPropertyTrackers propertyTrackers, ConstraintIndexCreator constraintIndexCreator, LegacyIndexStore legacyIndexStore) {
        this.storeLayer = storeLayer;
        this.legacyPropertyTrackers = propertyTrackers;
        this.constraintIndexCreator = constraintIndexCreator;
        this.legacyIndexStore = legacyIndexStore;
    }

    @Override
    public long nodeCreate(KernelStatement state) {
        long nodeId = this.storeLayer.reserveNode();
        state.txState().nodeDoCreate(nodeId);
        return nodeId;
    }

    @Override
    public void nodeDelete(KernelStatement state, long nodeId) throws EntityNotFoundException {
        this.assertNodeExists(state, nodeId);
        this.legacyPropertyTrackers.nodeDelete(nodeId);
        state.txState().nodeDoDelete(nodeId);
    }

    private void assertNodeExists(KernelStatement state, long nodeId) throws EntityNotFoundException {
        if (!this.nodeExists(state, nodeId)) {
            throw new EntityNotFoundException(EntityType.NODE, nodeId);
        }
    }

    @Override
    public long relationshipCreate(KernelStatement state, int relationshipTypeId, long startNodeId, long endNodeId) throws EntityNotFoundException {
        this.assertNodeExists(state, startNodeId);
        this.assertNodeExists(state, endNodeId);
        long id = this.storeLayer.reserveRelationship();
        state.txState().relationshipDoCreate(id, relationshipTypeId, startNodeId, endNodeId);
        return id;
    }

    @Override
    public void relationshipDelete(KernelStatement state, long relationshipId) throws EntityNotFoundException {
        this.assertRelationshipExists(state, relationshipId);
        this.legacyPropertyTrackers.relationshipDelete(relationshipId);
        final TransactionState txState = state.txState();
        if (txState.relationshipIsAddedInThisTx(relationshipId)) {
            txState.relationshipDoDeleteAddedInThisTx(relationshipId);
        } else {
            try {
                this.storeLayer.relationshipVisit(relationshipId, new RelationshipVisitor<RuntimeException>(){

                    @Override
                    public void visit(long relId, int type, long startNode, long endNode) {
                        txState.relationshipDoDelete(relId, type, startNode, endNode);
                    }
                });
            }
            catch (EntityNotFoundException e) {
                return;
            }
        }
    }

    private void assertRelationshipExists(KernelStatement state, long relationshipId) throws EntityNotFoundException {
        if (!this.relationshipExists(state, relationshipId)) {
            throw new EntityNotFoundException(EntityType.RELATIONSHIP, relationshipId);
        }
    }

    @Override
    public boolean nodeExists(KernelStatement state, long nodeId) {
        if (state.hasTxStateWithChanges()) {
            if (state.txState().nodeIsDeletedInThisTx(nodeId)) {
                return false;
            }
            if (state.txState().nodeIsAddedInThisTx(nodeId)) {
                return true;
            }
        }
        return this.storeLayer.nodeExists(nodeId);
    }

    @Override
    public boolean relationshipExists(KernelStatement state, long relId) {
        if (state.hasTxStateWithChanges()) {
            if (state.txState().relationshipIsDeletedInThisTx(relId)) {
                return false;
            }
            if (state.txState().relationshipIsAddedInThisTx(relId)) {
                return true;
            }
        }
        return this.storeLayer.relationshipExists(relId);
    }

    @Override
    public boolean nodeHasLabel(KernelStatement state, long nodeId, int labelId) throws EntityNotFoundException {
        if (state.hasTxStateWithChanges()) {
            if (state.txState().nodeIsDeletedInThisTx(nodeId)) {
                return false;
            }
            switch (state.txState().labelState(nodeId, labelId)) {
                case ADDED: {
                    return true;
                }
                case REMOVED: {
                    return false;
                }
            }
            if (state.txState().nodeIsAddedInThisTx(nodeId)) {
                return false;
            }
        }
        return this.storeLayer.nodeHasLabel(nodeId, labelId);
    }

    @Override
    public PrimitiveIntIterator nodeGetLabels(KernelStatement state, long nodeId) throws EntityNotFoundException {
        if (state.hasTxStateWithChanges()) {
            return StateHandlingStatementOperations.nodeGetLabels(this.storeLayer, state.txState(), nodeId);
        }
        return this.storeLayer.nodeGetLabels(nodeId);
    }

    public static PrimitiveIntIterator nodeGetLabels(StoreReadLayer storeLayer, ReadableTxState txState, long nodeId) throws EntityNotFoundException {
        if (txState.nodeIsDeletedInThisTx(nodeId)) {
            return PrimitiveIntCollections.emptyIterator();
        }
        if (txState.nodeIsAddedInThisTx(nodeId)) {
            return PrimitiveIntCollections.toPrimitiveIterator(txState.nodeStateLabelDiffSets(nodeId).getAdded().iterator());
        }
        return txState.nodeStateLabelDiffSets(nodeId).augment(storeLayer.nodeGetLabels(nodeId));
    }

    @Override
    public PrimitiveLongIterator nodesGetAll(KernelStatement state) {
        return state.txState().augmentNodesGetAll(this.storeLayer.nodesGetAll());
    }

    @Override
    public PrimitiveLongIterator relationshipsGetAll(KernelStatement state) {
        return state.txState().augmentRelationshipsGetAll(this.storeLayer.relationshipsGetAll());
    }

    @Override
    public boolean nodeAddLabel(KernelStatement state, long nodeId, int labelId) throws EntityNotFoundException {
        if (this.nodeHasLabel(state, nodeId, labelId)) {
            return false;
        }
        state.txState().nodeDoAddLabel(labelId, nodeId);
        Iterator<DefinedProperty> properties = this.nodeGetAllProperties(state, nodeId);
        while (properties.hasNext()) {
            DefinedProperty property = properties.next();
            this.indexUpdateProperty(state, nodeId, labelId, property.propertyKeyId(), null, property);
        }
        return true;
    }

    @Override
    public boolean nodeRemoveLabel(KernelStatement state, long nodeId, int labelId) throws EntityNotFoundException {
        if (!this.nodeHasLabel(state, nodeId, labelId)) {
            return false;
        }
        state.txState().nodeDoRemoveLabel(labelId, nodeId);
        Iterator<DefinedProperty> properties = this.nodeGetAllProperties(state, nodeId);
        while (properties.hasNext()) {
            DefinedProperty property = properties.next();
            this.indexUpdateProperty(state, nodeId, labelId, property.propertyKeyId(), property, null);
        }
        return true;
    }

    @Override
    public PrimitiveLongIterator nodesGetForLabel(KernelStatement state, int labelId) {
        if (state.hasTxStateWithChanges()) {
            PrimitiveLongIterator wLabelChanges = state.txState().nodesWithLabelChanged(labelId).augment(this.storeLayer.nodesGetForLabel(state, labelId));
            return state.txState().addedAndRemovedNodes().augmentWithRemovals(wLabelChanges);
        }
        return this.storeLayer.nodesGetForLabel(state, labelId);
    }

    @Override
    public IndexDescriptor indexCreate(KernelStatement state, int labelId, int propertyKey) {
        IndexDescriptor rule = new IndexDescriptor(labelId, propertyKey);
        state.txState().indexRuleDoAdd(rule);
        return rule;
    }

    @Override
    public void indexDrop(KernelStatement state, IndexDescriptor descriptor) throws DropIndexFailureException {
        state.txState().indexDoDrop(descriptor);
    }

    @Override
    public void uniqueIndexDrop(KernelStatement state, IndexDescriptor descriptor) throws DropIndexFailureException {
        state.txState().constraintIndexDoDrop(descriptor);
    }

    @Override
    public UniquenessConstraint uniquenessConstraintCreate(KernelStatement state, int labelId, int propertyKeyId) throws CreateConstraintFailureException {
        UniquenessConstraint constraint = new UniquenessConstraint(labelId, propertyKeyId);
        try {
            IndexDescriptor index = new IndexDescriptor(labelId, propertyKeyId);
            if (state.txState().constraintIndexDoUnRemove(index)) {
                if (!state.txState().constraintDoUnRemove(constraint)) {
                    state.txState().constraintDoAdd(constraint, state.txState().indexCreatedForConstraint(constraint));
                }
            } else {
                Iterator<UniquenessConstraint> it = this.storeLayer.constraintsGetForLabelAndPropertyKey(labelId, propertyKeyId);
                while (it.hasNext()) {
                    if (!it.next().equals(labelId, propertyKeyId)) continue;
                    return constraint;
                }
                long indexId = this.constraintIndexCreator.createUniquenessConstraintIndex(state, this, labelId, propertyKeyId);
                state.txState().constraintDoAdd(constraint, indexId);
            }
            return constraint;
        }
        catch (TransactionFailureException | ConstraintVerificationFailedKernelException | DropIndexFailureException e) {
            throw new CreateConstraintFailureException(constraint, (Throwable)e);
        }
    }

    @Override
    public Iterator<UniquenessConstraint> constraintsGetForLabelAndPropertyKey(KernelStatement state, int labelId, int propertyKeyId) {
        return this.applyConstraintsDiff(state, this.storeLayer.constraintsGetForLabelAndPropertyKey(labelId, propertyKeyId), labelId, propertyKeyId);
    }

    @Override
    public Iterator<UniquenessConstraint> constraintsGetForLabel(KernelStatement state, int labelId) {
        return this.applyConstraintsDiff(state, this.storeLayer.constraintsGetForLabel(labelId), labelId);
    }

    @Override
    public Iterator<UniquenessConstraint> constraintsGetAll(KernelStatement state) {
        return this.applyConstraintsDiff(state, this.storeLayer.constraintsGetAll());
    }

    private Iterator<UniquenessConstraint> applyConstraintsDiff(KernelStatement state, Iterator<UniquenessConstraint> constraints, int labelId, int propertyKeyId) {
        if (state.hasTxStateWithChanges()) {
            return state.txState().constraintsChangesForLabelAndProperty(labelId, propertyKeyId).apply(constraints);
        }
        return constraints;
    }

    private Iterator<UniquenessConstraint> applyConstraintsDiff(KernelStatement state, Iterator<UniquenessConstraint> constraints, int labelId) {
        if (state.hasTxStateWithChanges()) {
            return state.txState().constraintsChangesForLabel(labelId).apply(constraints);
        }
        return constraints;
    }

    private Iterator<UniquenessConstraint> applyConstraintsDiff(KernelStatement state, Iterator<UniquenessConstraint> constraints) {
        if (state.hasTxStateWithChanges()) {
            return state.txState().constraintsChanges().apply(constraints);
        }
        return constraints;
    }

    @Override
    public void constraintDrop(KernelStatement state, UniquenessConstraint constraint) {
        state.txState().constraintDoDrop(constraint);
    }

    @Override
    public IndexDescriptor indexesGetForLabelAndPropertyKey(KernelStatement state, int labelId, int propertyKey) {
        IndexDescriptor indexDescriptor = this.storeLayer.indexesGetForLabelAndPropertyKey(labelId, propertyKey);
        Iterator<IndexDescriptor> rules = IteratorUtil.iterator(indexDescriptor);
        if (state.hasTxStateWithChanges()) {
            rules = this.filterByPropertyKeyId(state.txState().indexDiffSetsByLabel(labelId).apply(rules), propertyKey);
        }
        return IteratorUtil.singleOrNull(rules);
    }

    private Iterator<IndexDescriptor> filterByPropertyKeyId(Iterator<IndexDescriptor> descriptorIterator, final int propertyKey) {
        Predicate<IndexDescriptor> predicate = new Predicate<IndexDescriptor>(){

            @Override
            public boolean accept(IndexDescriptor item) {
                return item.getPropertyKeyId() == propertyKey;
            }
        };
        return Iterables.filter(predicate, descriptorIterator);
    }

    @Override
    public InternalIndexState indexGetState(KernelStatement state, IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        if (state.hasTxStateWithChanges()) {
            if (this.checkIndexState(descriptor, state.txState().indexDiffSetsByLabel(descriptor.getLabelId()))) {
                return InternalIndexState.POPULATING;
            }
            ReadableDiffSets<IndexDescriptor> changes = state.txState().constraintIndexDiffSetsByLabel(descriptor.getLabelId());
            if (this.checkIndexState(descriptor, changes)) {
                return InternalIndexState.POPULATING;
            }
        }
        return this.storeLayer.indexGetState(descriptor);
    }

    private boolean checkIndexState(IndexDescriptor indexRule, ReadableDiffSets<IndexDescriptor> diffSet) throws IndexNotFoundKernelException {
        if (diffSet.isAdded(indexRule)) {
            return true;
        }
        if (diffSet.isRemoved(indexRule)) {
            throw new IndexNotFoundKernelException(String.format("Index for label id %d on property id %d has been dropped in this transaction.", indexRule.getLabelId(), indexRule.getPropertyKeyId()));
        }
        return false;
    }

    @Override
    public Iterator<IndexDescriptor> indexesGetForLabel(KernelStatement state, int labelId) {
        if (state.hasTxStateWithChanges()) {
            return state.txState().indexDiffSetsByLabel(labelId).apply(this.storeLayer.indexesGetForLabel(labelId));
        }
        return this.storeLayer.indexesGetForLabel(labelId);
    }

    @Override
    public Iterator<IndexDescriptor> indexesGetAll(KernelStatement state) {
        if (state.hasTxStateWithChanges()) {
            return state.txState().indexChanges().apply(this.storeLayer.indexesGetAll());
        }
        return this.storeLayer.indexesGetAll();
    }

    @Override
    public Iterator<IndexDescriptor> uniqueIndexesGetForLabel(KernelStatement state, int labelId) {
        if (state.hasTxStateWithChanges()) {
            return state.txState().constraintIndexDiffSetsByLabel(labelId).apply(this.storeLayer.uniqueIndexesGetForLabel(labelId));
        }
        return this.storeLayer.uniqueIndexesGetForLabel(labelId);
    }

    @Override
    public Iterator<IndexDescriptor> uniqueIndexesGetAll(KernelStatement state) {
        if (state.hasTxStateWithChanges()) {
            return state.txState().constraintIndexChanges().apply(this.storeLayer.uniqueIndexesGetAll());
        }
        return this.storeLayer.uniqueIndexesGetAll();
    }

    @Override
    public long nodeGetUniqueFromIndexLookup(KernelStatement state, IndexDescriptor index, Object value) throws IndexNotFoundKernelException, IndexBrokenKernelException {
        PrimitiveLongResourceIterator committed = this.storeLayer.nodeGetUniqueFromIndexLookup(state, index, value);
        PrimitiveLongIterator exactMatches = this.filterExactIndexMatches(state, index, value, committed);
        PrimitiveLongIterator changeFilteredMatches = this.filterIndexStateChanges(state, index, value, exactMatches);
        return PrimitiveLongCollections.single((PrimitiveLongIterator)IteratorUtil.resourceIterator(changeFilteredMatches, (Resource)committed), (long)-1L);
    }

    @Override
    public PrimitiveLongIterator nodesGetFromIndexLookup(KernelStatement state, IndexDescriptor index, Object value) throws IndexNotFoundKernelException {
        PrimitiveLongResourceIterator committed = this.storeLayer.nodesGetFromIndexLookup(state, index, value);
        PrimitiveLongIterator exactMatches = this.filterExactIndexMatches(state, index, value, committed);
        PrimitiveLongIterator changeFilteredMatches = this.filterIndexStateChanges(state, index, value, exactMatches);
        return IteratorUtil.resourceIterator(changeFilteredMatches, (Resource)committed);
    }

    private PrimitiveLongIterator filterExactIndexMatches(KernelStatement state, IndexDescriptor index, Object value, PrimitiveLongResourceIterator committed) {
        return LookupFilter.exactIndexMatches(this, state, committed, index.getPropertyKeyId(), value);
    }

    private PrimitiveLongIterator filterIndexStateChanges(KernelStatement state, IndexDescriptor index, Object value, PrimitiveLongIterator nodeIds) {
        if (state.hasTxStateWithChanges()) {
            ReadableDiffSets<Long> labelPropertyChanges = state.txState().indexUpdates(index, value);
            ReadableDiffSets<Long> nodes = state.txState().addedAndRemovedNodes();
            return nodes.augmentWithRemovals(labelPropertyChanges.augment(nodeIds));
        }
        return nodeIds;
    }

    @Override
    public Property nodeSetProperty(KernelStatement state, long nodeId, DefinedProperty property) throws EntityNotFoundException {
        Property existingProperty = this.nodeGetProperty(state, nodeId, property.propertyKeyId());
        if (!existingProperty.isDefined()) {
            this.legacyPropertyTrackers.nodeAddStoreProperty(nodeId, property);
        } else {
            this.legacyPropertyTrackers.nodeChangeStoreProperty(nodeId, (DefinedProperty)existingProperty, property);
        }
        state.txState().nodeDoReplaceProperty(nodeId, existingProperty, property);
        this.indexesUpdateProperty(state, nodeId, property.propertyKeyId(), existingProperty instanceof DefinedProperty ? (DefinedProperty)existingProperty : null, property);
        return existingProperty;
    }

    @Override
    public Property relationshipSetProperty(KernelStatement state, long relationshipId, DefinedProperty property) throws EntityNotFoundException {
        Property existingProperty = this.relationshipGetProperty(state, relationshipId, property.propertyKeyId());
        if (!existingProperty.isDefined()) {
            this.legacyPropertyTrackers.relationshipAddStoreProperty(relationshipId, property);
        } else {
            this.legacyPropertyTrackers.relationshipChangeStoreProperty(relationshipId, (DefinedProperty)existingProperty, property);
        }
        state.txState().relationshipDoReplaceProperty(relationshipId, existingProperty, property);
        return existingProperty;
    }

    @Override
    public Property graphSetProperty(KernelStatement state, DefinedProperty property) {
        Property existingProperty = this.graphGetProperty(state, property.propertyKeyId());
        state.txState().graphDoReplaceProperty(existingProperty, property);
        return existingProperty;
    }

    @Override
    public Property nodeRemoveProperty(KernelStatement state, long nodeId, int propertyKeyId) throws EntityNotFoundException {
        Property existingProperty = this.nodeGetProperty(state, nodeId, propertyKeyId);
        if (existingProperty.isDefined()) {
            this.legacyPropertyTrackers.nodeRemoveStoreProperty(nodeId, (DefinedProperty)existingProperty);
            state.txState().nodeDoRemoveProperty(nodeId, (DefinedProperty)existingProperty);
            this.indexesUpdateProperty(state, nodeId, propertyKeyId, (DefinedProperty)existingProperty, null);
        }
        return existingProperty;
    }

    @Override
    public Property relationshipRemoveProperty(KernelStatement state, long relationshipId, int propertyKeyId) throws EntityNotFoundException {
        Property existingProperty = this.relationshipGetProperty(state, relationshipId, propertyKeyId);
        if (existingProperty.isDefined()) {
            this.legacyPropertyTrackers.relationshipRemoveStoreProperty(relationshipId, (DefinedProperty)existingProperty);
            state.txState().relationshipDoRemoveProperty(relationshipId, (DefinedProperty)existingProperty);
        }
        return existingProperty;
    }

    @Override
    public Property graphRemoveProperty(KernelStatement state, int propertyKeyId) {
        Property existingProperty = this.graphGetProperty(state, propertyKeyId);
        if (existingProperty.isDefined()) {
            state.txState().graphDoRemoveProperty((DefinedProperty)existingProperty);
        }
        return existingProperty;
    }

    private void indexesUpdateProperty(KernelStatement state, long nodeId, int propertyKey, DefinedProperty before, DefinedProperty after) throws EntityNotFoundException {
        PrimitiveIntIterator labels = this.nodeGetLabels(state, nodeId);
        while (labels.hasNext()) {
            this.indexUpdateProperty(state, nodeId, labels.next(), propertyKey, before, after);
        }
    }

    private void indexUpdateProperty(KernelStatement state, long nodeId, int labelId, int propertyKey, DefinedProperty before, DefinedProperty after) {
        IndexDescriptor descriptor = this.indexesGetForLabelAndPropertyKey(state, labelId, propertyKey);
        if (descriptor != null) {
            state.txState().indexDoUpdateProperty(descriptor, nodeId, before, after);
        }
    }

    @Override
    public PrimitiveLongIterator nodeGetPropertyKeys(KernelStatement state, long nodeId) throws EntityNotFoundException {
        if (state.hasTxStateWithChanges()) {
            return new PropertyKeyIdIterator(this.nodeGetAllProperties(state, nodeId));
        }
        return this.storeLayer.nodeGetPropertyKeys(nodeId);
    }

    @Override
    public Property nodeGetProperty(KernelStatement state, long nodeId, int propertyKeyId) throws EntityNotFoundException {
        if (state.hasTxStateWithChanges()) {
            Iterator<DefinedProperty> properties = this.nodeGetAllProperties(state, nodeId);
            while (properties.hasNext()) {
                Property property = properties.next();
                if (property.propertyKeyId() != propertyKeyId) continue;
                return property;
            }
            return Property.noNodeProperty(nodeId, propertyKeyId);
        }
        return this.storeLayer.nodeGetProperty(nodeId, propertyKeyId);
    }

    @Override
    public Iterator<DefinedProperty> nodeGetAllProperties(KernelStatement state, long nodeId) throws EntityNotFoundException {
        if (state.hasTxStateWithChanges()) {
            if (state.txState().nodeIsAddedInThisTx(nodeId)) {
                return state.txState().addedAndChangedNodeProperties(nodeId);
            }
            if (state.txState().nodeIsDeletedInThisTx(nodeId)) {
                throw new IllegalStateException("Node " + nodeId + " has been deleted");
            }
            return state.txState().augmentNodeProperties(nodeId, this.storeLayer.nodeGetAllProperties(nodeId));
        }
        return this.storeLayer.nodeGetAllProperties(nodeId);
    }

    @Override
    public PrimitiveLongIterator relationshipGetPropertyKeys(KernelStatement state, long relationshipId) throws EntityNotFoundException {
        if (state.hasTxStateWithChanges()) {
            return new PropertyKeyIdIterator(this.relationshipGetAllProperties(state, relationshipId));
        }
        return this.storeLayer.relationshipGetPropertyKeys(relationshipId);
    }

    @Override
    public Property relationshipGetProperty(KernelStatement state, long relationshipId, int propertyKeyId) throws EntityNotFoundException {
        if (state.hasTxStateWithChanges()) {
            Iterator<DefinedProperty> properties = this.relationshipGetAllProperties(state, relationshipId);
            while (properties.hasNext()) {
                Property property = properties.next();
                if (property.propertyKeyId() != propertyKeyId) continue;
                return property;
            }
            return Property.noRelationshipProperty(relationshipId, propertyKeyId);
        }
        return this.storeLayer.relationshipGetProperty(relationshipId, propertyKeyId);
    }

    @Override
    public Iterator<DefinedProperty> relationshipGetAllProperties(KernelStatement state, long relationshipId) throws EntityNotFoundException {
        if (state.hasTxStateWithChanges()) {
            if (state.txState().relationshipIsAddedInThisTx(relationshipId)) {
                return state.txState().addedAndChangedRelationshipProperties(relationshipId);
            }
            if (state.txState().relationshipIsDeletedInThisTx(relationshipId)) {
                throw new IllegalStateException("Relationship " + relationshipId + " has been deleted");
            }
            return state.txState().augmentRelationshipProperties(relationshipId, this.storeLayer.relationshipGetAllProperties(relationshipId));
        }
        return this.storeLayer.relationshipGetAllProperties(relationshipId);
    }

    @Override
    public PrimitiveLongIterator graphGetPropertyKeys(KernelStatement state) {
        if (state.hasTxStateWithChanges()) {
            return new PropertyKeyIdIterator(this.graphGetAllProperties(state));
        }
        return this.storeLayer.graphGetPropertyKeys(state);
    }

    @Override
    public Property graphGetProperty(KernelStatement state, int propertyKeyId) {
        Iterator<DefinedProperty> properties = this.graphGetAllProperties(state);
        while (properties.hasNext()) {
            Property property = properties.next();
            if (property.propertyKeyId() != propertyKeyId) continue;
            return property;
        }
        return Property.noGraphProperty(propertyKeyId);
    }

    @Override
    public Iterator<DefinedProperty> graphGetAllProperties(KernelStatement state) {
        if (state.hasTxStateWithChanges()) {
            return state.txState().augmentGraphProperties(this.storeLayer.graphGetAllProperties());
        }
        return this.storeLayer.graphGetAllProperties();
    }

    @Override
    public long countsForNode(KernelStatement statement, int labelId) {
        return this.storeLayer.countsForNode(labelId);
    }

    @Override
    public long countsForRelationship(KernelStatement statement, int startLabelId, int typeId, int endLabelId) {
        return this.storeLayer.countsForRelationship(startLabelId, typeId, endLabelId);
    }

    @Override
    public double indexUniqueValuesPercentage(KernelStatement statement, IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        return this.storeLayer.indexUniqueValuesPercentage(descriptor);
    }

    @Override
    public PrimitiveLongIterator nodeGetRelationships(KernelStatement state, long nodeId, Direction direction, int[] relTypes) throws EntityNotFoundException {
        relTypes = StateHandlingStatementOperations.deduplicate(relTypes);
        if (state.hasTxStateWithChanges()) {
            TransactionState txState = state.txState();
            PrimitiveLongIterator stored = txState.nodeIsAddedInThisTx(nodeId) ? PrimitiveLongCollections.emptyIterator() : this.storeLayer.nodeListRelationships(nodeId, direction, relTypes);
            return txState.augmentRelationships(nodeId, direction, relTypes, stored);
        }
        return this.storeLayer.nodeListRelationships(nodeId, direction, relTypes);
    }

    @Override
    public Cursor nodeGetRelationships(KernelStatement state, long nodeId, Direction direction, int[] types, RelationshipVisitor<? extends RuntimeException> visitor) throws EntityNotFoundException {
        return new RelationshipCursor(state, this.nodeGetRelationships(state, nodeId, direction, types), visitor);
    }

    @Override
    public PrimitiveLongIterator nodeGetRelationships(KernelStatement state, long nodeId, Direction direction) throws EntityNotFoundException {
        if (state.hasTxStateWithChanges()) {
            TransactionState txState = state.txState();
            PrimitiveLongIterator stored = txState.nodeIsAddedInThisTx(nodeId) ? PrimitiveLongCollections.emptyIterator() : this.storeLayer.nodeListRelationships(nodeId, direction);
            return txState.augmentRelationships(nodeId, direction, stored);
        }
        return this.storeLayer.nodeListRelationships(nodeId, direction);
    }

    @Override
    public Cursor nodeGetRelationships(KernelStatement state, long nodeId, Direction direction, RelationshipVisitor<? extends RuntimeException> visitor) throws EntityNotFoundException {
        return new RelationshipCursor(state, this.nodeGetRelationships(state, nodeId, direction), visitor);
    }

    @Override
    public int nodeGetDegree(KernelStatement state, long nodeId, Direction direction, int relType) throws EntityNotFoundException {
        if (state.hasTxStateWithChanges()) {
            int degree = 0;
            if (state.txState().nodeIsDeletedInThisTx(nodeId)) {
                return 0;
            }
            if (!state.txState().nodeIsAddedInThisTx(nodeId)) {
                degree = this.storeLayer.nodeGetDegree(nodeId, direction, relType);
            }
            return state.txState().augmentNodeDegree(nodeId, degree, direction, relType);
        }
        return this.storeLayer.nodeGetDegree(nodeId, direction, relType);
    }

    @Override
    public int nodeGetDegree(KernelStatement state, long nodeId, Direction direction) throws EntityNotFoundException {
        if (state.hasTxStateWithChanges()) {
            int degree = 0;
            if (state.txState().nodeIsDeletedInThisTx(nodeId)) {
                return 0;
            }
            if (!state.txState().nodeIsAddedInThisTx(nodeId)) {
                degree = this.storeLayer.nodeGetDegree(nodeId, direction);
            }
            return state.txState().augmentNodeDegree(nodeId, degree, direction);
        }
        return this.storeLayer.nodeGetDegree(nodeId, direction);
    }

    @Override
    public PrimitiveIntIterator nodeGetRelationshipTypes(KernelStatement state, long nodeId) throws EntityNotFoundException {
        if (state.hasTxStateWithChanges() && state.txState().nodeModifiedInThisTx(nodeId)) {
            TransactionState tx = state.txState();
            if (tx.nodeIsDeletedInThisTx(nodeId)) {
                return PrimitiveIntCollections.emptyIterator();
            }
            if (tx.nodeIsAddedInThisTx(nodeId)) {
                return tx.nodeRelationshipTypes(nodeId);
            }
            HashSet<Integer> types = new HashSet<Integer>();
            PrimitiveIntIterator typesInTx = tx.nodeRelationshipTypes(nodeId);
            while (typesInTx.hasNext()) {
                types.add(typesInTx.next());
            }
            PrimitiveIntIterator committedTypes = this.storeLayer.nodeGetRelationshipTypes(nodeId);
            while (committedTypes.hasNext()) {
                int current = committedTypes.next();
                if (types.contains(current) || this.nodeGetDegree(state, nodeId, Direction.BOTH, current) <= 0) continue;
                types.add(current);
            }
            return PrimitiveIntCollections.toPrimitiveIterator(types.iterator());
        }
        return this.storeLayer.nodeGetRelationshipTypes(nodeId);
    }

    @Override
    public Long indexGetOwningUniquenessConstraintId(KernelStatement state, IndexDescriptor index) throws SchemaRuleNotFoundException {
        return this.storeLayer.indexGetOwningUniquenessConstraintId(index);
    }

    @Override
    public long indexGetCommittedId(KernelStatement state, IndexDescriptor index, SchemaStorage.IndexRuleKind kind) throws SchemaRuleNotFoundException {
        return this.storeLayer.indexGetCommittedId(index, kind);
    }

    @Override
    public String indexGetFailure(Statement state, IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        return this.storeLayer.indexGetFailure(descriptor);
    }

    @Override
    public int labelGetForName(Statement state, String labelName) {
        return this.storeLayer.labelGetForName(labelName);
    }

    @Override
    public String labelGetName(Statement state, int labelId) throws LabelNotFoundKernelException {
        return this.storeLayer.labelGetName(labelId);
    }

    @Override
    public int propertyKeyGetForName(Statement state, String propertyKeyName) {
        return this.storeLayer.propertyKeyGetForName(propertyKeyName);
    }

    @Override
    public String propertyKeyGetName(Statement state, int propertyKeyId) throws PropertyKeyIdNotFoundKernelException {
        return this.storeLayer.propertyKeyGetName(propertyKeyId);
    }

    @Override
    public Iterator<Token> propertyKeyGetAllTokens(Statement state) {
        return this.storeLayer.propertyKeyGetAllTokens();
    }

    @Override
    public Iterator<Token> labelsGetAllTokens(Statement state) {
        return this.storeLayer.labelsGetAllTokens();
    }

    @Override
    public int relationshipTypeGetForName(Statement state, String relationshipTypeName) {
        return this.storeLayer.relationshipTypeGetForName(relationshipTypeName);
    }

    @Override
    public String relationshipTypeGetName(Statement state, int relationshipTypeId) throws RelationshipTypeIdNotFoundKernelException {
        return this.storeLayer.relationshipTypeGetName(relationshipTypeId);
    }

    @Override
    public int labelGetOrCreateForName(Statement state, String labelName) throws IllegalTokenNameException, TooManyLabelsException {
        return this.storeLayer.labelGetOrCreateForName(labelName);
    }

    @Override
    public int propertyKeyGetOrCreateForName(Statement state, String propertyKeyName) throws IllegalTokenNameException {
        return this.storeLayer.propertyKeyGetOrCreateForName(propertyKeyName);
    }

    @Override
    public int relationshipTypeGetOrCreateForName(Statement state, String relationshipTypeName) throws IllegalTokenNameException {
        return this.storeLayer.relationshipTypeGetOrCreateForName(relationshipTypeName);
    }

    @Override
    public void labelCreateForName(KernelStatement state, String labelName, int id) throws IllegalTokenNameException, TooManyLabelsException {
        state.txState().labelDoCreateForName(labelName, id);
    }

    @Override
    public void propertyKeyCreateForName(KernelStatement state, String propertyKeyName, int id) throws IllegalTokenNameException {
        state.txState().propertyKeyDoCreateForName(propertyKeyName, id);
    }

    @Override
    public void relationshipTypeCreateForName(KernelStatement state, String relationshipTypeName, int id) throws IllegalTokenNameException {
        state.txState().relationshipTypeDoCreateForName(relationshipTypeName, id);
    }

    private static int[] deduplicate(int[] types) {
        int unique = 0;
        for (int i = 0; i < types.length; ++i) {
            int type = types[i];
            for (int j = 0; j < unique; ++j) {
                if (type != types[j]) continue;
                type = -1;
                break;
            }
            if (type == -1) continue;
            types[unique++] = types[i];
        }
        if (unique < types.length) {
            types = Arrays.copyOf(types, unique);
        }
        return types;
    }

    @Override
    public <EXCEPTION extends Exception> void relationshipVisit(KernelStatement statement, long relId, RelationshipVisitor<EXCEPTION> visitor) throws EntityNotFoundException, EXCEPTION {
        if (statement.hasTxStateWithChanges() && statement.txState().relationshipVisit(relId, visitor)) {
            return;
        }
        this.storeLayer.relationshipVisit(relId, visitor);
    }

    @Override
    public Cursor expand(KernelStatement statement, Cursor inputCursor, NeoRegister.Node.In nodeId, Register.Object.In<int[]> types, Register.Object.In<Direction> expandDirection, NeoRegister.Relationship.Out relId, NeoRegister.RelType.Out relType, Register.Object.Out<Direction> direction, NeoRegister.Node.Out startNodeId, NeoRegister.Node.Out neighborNodeId) {
        if (statement.hasTxStateWithChanges()) {
            return new AugmentWithLocalStateExpandCursor(this.storeLayer, statement.txState(), inputCursor, nodeId, types, expandDirection, relId, relType, direction, startNodeId, neighborNodeId);
        }
        return this.storeLayer.expand(inputCursor, nodeId, types, expandDirection, relId, relType, direction, startNodeId, neighborNodeId);
    }

    @Override
    public LegacyIndexHits nodeLegacyIndexGet(KernelStatement statement, String indexName, String key, Object value) throws LegacyIndexNotFoundKernelException {
        return statement.legacyIndexTxState().nodeChanges(indexName).get(key, value);
    }

    @Override
    public LegacyIndexHits nodeLegacyIndexQuery(KernelStatement statement, String indexName, String key, Object queryOrQueryObject) throws LegacyIndexNotFoundKernelException {
        return statement.legacyIndexTxState().nodeChanges(indexName).query(key, queryOrQueryObject);
    }

    @Override
    public LegacyIndexHits nodeLegacyIndexQuery(KernelStatement statement, String indexName, Object queryOrQueryObject) throws LegacyIndexNotFoundKernelException {
        return statement.legacyIndexTxState().nodeChanges(indexName).query(queryOrQueryObject);
    }

    @Override
    public LegacyIndexHits relationshipLegacyIndexGet(KernelStatement statement, String indexName, String key, Object value, long startNode, long endNode) throws LegacyIndexNotFoundKernelException {
        LegacyIndex index = statement.legacyIndexTxState().relationshipChanges(indexName);
        if (startNode != -1L || endNode != -1L) {
            return index.get(key, value, startNode, endNode);
        }
        return index.get(key, value);
    }

    @Override
    public LegacyIndexHits relationshipLegacyIndexQuery(KernelStatement statement, String indexName, String key, Object queryOrQueryObject, long startNode, long endNode) throws LegacyIndexNotFoundKernelException {
        LegacyIndex index = statement.legacyIndexTxState().relationshipChanges(indexName);
        if (startNode != -1L || endNode != -1L) {
            return index.query(key, queryOrQueryObject, startNode, endNode);
        }
        return index.query(key, queryOrQueryObject);
    }

    @Override
    public LegacyIndexHits relationshipLegacyIndexQuery(KernelStatement statement, String indexName, Object queryOrQueryObject, long startNode, long endNode) throws LegacyIndexNotFoundKernelException {
        LegacyIndex index = statement.legacyIndexTxState().relationshipChanges(indexName);
        if (startNode != -1L || endNode != -1L) {
            return index.query(queryOrQueryObject, startNode, endNode);
        }
        return index.query(queryOrQueryObject);
    }

    @Override
    public void nodeLegacyIndexCreateLazily(KernelStatement statement, String indexName, Map<String, String> customConfig) {
        this.legacyIndexStore.getOrCreateNodeIndexConfig(indexName, customConfig);
    }

    @Override
    public void nodeLegacyIndexCreate(KernelStatement statement, String indexName, Map<String, String> customConfig) {
        statement.txState().nodeLegacyIndexDoCreate(indexName, customConfig);
    }

    @Override
    public void relationshipLegacyIndexCreateLazily(KernelStatement statement, String indexName, Map<String, String> customConfig) {
        this.legacyIndexStore.getOrCreateRelationshipIndexConfig(indexName, customConfig);
    }

    @Override
    public void relationshipLegacyIndexCreate(KernelStatement statement, String indexName, Map<String, String> customConfig) {
        statement.txState().relationshipLegacyIndexDoCreate(indexName, customConfig);
    }

    @Override
    public void nodeAddToLegacyIndex(KernelStatement statement, String indexName, long node, String key, Object value) throws LegacyIndexNotFoundKernelException {
        statement.legacyIndexTxState().nodeChanges(indexName).addNode(node, key, value);
    }

    @Override
    public void nodeRemoveFromLegacyIndex(KernelStatement statement, String indexName, long node, String key, Object value) throws LegacyIndexNotFoundKernelException {
        statement.legacyIndexTxState().nodeChanges(indexName).remove(node, key, value);
    }

    @Override
    public void nodeRemoveFromLegacyIndex(KernelStatement statement, String indexName, long node, String key) throws LegacyIndexNotFoundKernelException {
        statement.legacyIndexTxState().nodeChanges(indexName).remove(node, key);
    }

    @Override
    public void nodeRemoveFromLegacyIndex(KernelStatement statement, String indexName, long node) throws LegacyIndexNotFoundKernelException {
        statement.legacyIndexTxState().nodeChanges(indexName).remove(node);
    }

    @Override
    public void relationshipAddToLegacyIndex(final KernelStatement statement, final String indexName, final long relationship, final String key, final Object value) throws EntityNotFoundException, LegacyIndexNotFoundKernelException {
        this.relationshipVisit(statement, relationship, new RelationshipVisitor<LegacyIndexNotFoundKernelException>(){

            @Override
            public void visit(long relId, int type, long startNode, long endNode) throws LegacyIndexNotFoundKernelException {
                statement.legacyIndexTxState().relationshipChanges(indexName).addRelationship(relationship, key, value, startNode, endNode);
            }
        });
    }

    @Override
    public void relationshipRemoveFromLegacyIndex(final KernelStatement statement, final String indexName, long relationship, final String key, final Object value) throws LegacyIndexNotFoundKernelException, EntityNotFoundException {
        try {
            this.relationshipVisit(statement, relationship, new RelationshipVisitor<LegacyIndexNotFoundKernelException>(){

                @Override
                public void visit(long relId, int type, long startNode, long endNode) throws LegacyIndexNotFoundKernelException {
                    statement.legacyIndexTxState().relationshipChanges(indexName).removeRelationship(relId, key, value, startNode, endNode);
                }
            });
        }
        catch (EntityNotFoundException e) {
            // empty catch block
        }
    }

    @Override
    public void relationshipRemoveFromLegacyIndex(final KernelStatement statement, final String indexName, long relationship, final String key) throws EntityNotFoundException, LegacyIndexNotFoundKernelException {
        try {
            this.relationshipVisit(statement, relationship, new RelationshipVisitor<LegacyIndexNotFoundKernelException>(){

                @Override
                public void visit(long relId, int type, long startNode, long endNode) throws LegacyIndexNotFoundKernelException {
                    statement.legacyIndexTxState().relationshipChanges(indexName).removeRelationship(relId, key, startNode, endNode);
                }
            });
        }
        catch (EntityNotFoundException e) {
            // empty catch block
        }
    }

    @Override
    public void relationshipRemoveFromLegacyIndex(final KernelStatement statement, final String indexName, long relationship) throws LegacyIndexNotFoundKernelException, EntityNotFoundException {
        try {
            this.relationshipVisit(statement, relationship, new RelationshipVisitor<LegacyIndexNotFoundKernelException>(){

                @Override
                public void visit(long relId, int type, long startNode, long endNode) throws LegacyIndexNotFoundKernelException {
                    statement.legacyIndexTxState().relationshipChanges(indexName).removeRelationship(relId, startNode, endNode);
                }
            });
        }
        catch (EntityNotFoundException e) {
            statement.legacyIndexTxState().relationshipChanges(indexName).remove(relationship);
        }
    }

    @Override
    public void nodeLegacyIndexDrop(KernelStatement statement, String indexName) throws LegacyIndexNotFoundKernelException {
        statement.legacyIndexTxState().nodeChanges(indexName).drop();
        statement.legacyIndexTxState().deleteIndex(IndexEntityType.Node, indexName);
    }

    @Override
    public void relationshipLegacyIndexDrop(KernelStatement statement, String indexName) throws LegacyIndexNotFoundKernelException {
        statement.legacyIndexTxState().relationshipChanges(indexName).drop();
        statement.legacyIndexTxState().deleteIndex(IndexEntityType.Relationship, indexName);
    }

    @Override
    public String nodeLegacyIndexSetConfiguration(KernelStatement statement, String indexName, String key, String value) throws LegacyIndexNotFoundKernelException {
        return this.legacyIndexStore.setNodeIndexConfiguration(indexName, key, value);
    }

    @Override
    public String relationshipLegacyIndexSetConfiguration(KernelStatement statement, String indexName, String key, String value) throws LegacyIndexNotFoundKernelException {
        return this.legacyIndexStore.setRelationshipIndexConfiguration(indexName, key, value);
    }

    @Override
    public String nodeLegacyIndexRemoveConfiguration(KernelStatement statement, String indexName, String key) throws LegacyIndexNotFoundKernelException {
        return this.legacyIndexStore.removeNodeIndexConfiguration(indexName, key);
    }

    @Override
    public String relationshipLegacyIndexRemoveConfiguration(KernelStatement statement, String indexName, String key) throws LegacyIndexNotFoundKernelException {
        return this.legacyIndexStore.removeRelationshipIndexConfiguration(indexName, key);
    }

    @Override
    public Map<String, String> nodeLegacyIndexGetConfiguration(KernelStatement statement, String indexName) throws LegacyIndexNotFoundKernelException {
        return this.legacyIndexStore.getNodeIndexConfiguration(indexName);
    }

    @Override
    public Map<String, String> relationshipLegacyIndexGetConfiguration(KernelStatement statement, String indexName) throws LegacyIndexNotFoundKernelException {
        return this.legacyIndexStore.getRelationshipIndexConfiguration(indexName);
    }

    @Override
    public String[] nodeLegacyIndexesGetAll(KernelStatement statement) {
        return this.legacyIndexStore.getAllNodeIndexNames();
    }

    @Override
    public String[] relationshipLegacyIndexesGetAll(KernelStatement statement) {
        return this.legacyIndexStore.getAllRelationshipIndexNames();
    }

    private class RelationshipCursor
    implements Cursor {
        private final PrimitiveLongIterator relationships;
        private final KernelStatement state;
        private final RelationshipVisitor<? extends RuntimeException> visitor;

        public RelationshipCursor(KernelStatement state, PrimitiveLongIterator relationships, RelationshipVisitor<? extends RuntimeException> visitor) {
            this.relationships = relationships;
            this.state = state;
            this.visitor = visitor;
        }

        public boolean next() {
            while (this.relationships.hasNext()) {
                try {
                    StateHandlingStatementOperations.this.relationshipVisit(this.state, this.relationships.next(), this.visitor);
                }
                catch (EntityNotFoundException e) {
                    continue;
                }
                return true;
            }
            return false;
        }

        public void reset() {
            throw new UnsupportedOperationException();
        }

        public void close() {
        }
    }
}

