/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.command;

import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveLongObjectMap;
import org.neo4j.collection.primitive.PrimitiveLongSet;
import org.neo4j.collection.primitive.PrimitiveLongVisitor;
import org.neo4j.function.primitive.FunctionFromPrimitiveLongLongToPrimitiveLong;
import org.neo4j.function.primitive.PrimitiveLongPredicate;
import org.neo4j.kernel.impl.core.CacheAccessBackDoor;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.transaction.state.RelationshipChainLoader;

public class RelationshipHoles
implements PrimitiveLongPredicate,
FunctionFromPrimitiveLongLongToPrimitiveLong<RuntimeException> {
    private final PrimitiveLongSet nodes = Primitive.longSet((int)8);
    private final PrimitiveLongObjectMap<RelationshipRecord> relationships = Primitive.longObjectMap((int)32);

    public void deleted(RelationshipRecord deletedRelationship) {
        this.nodes.add(deletedRelationship.getFirstNode());
        this.nodes.add(deletedRelationship.getSecondNode());
        this.relationships.put(deletedRelationship.getId(), (Object)deletedRelationship);
    }

    public boolean accept(long relationshipId) {
        return this.relationships.containsKey(relationshipId);
    }

    public long apply(long nodeId, long deletedRelationshipId) throws RuntimeException {
        long relationshipId = deletedRelationshipId;
        RelationshipRecord relationship;
        while ((relationship = (RelationshipRecord)this.relationships.get(relationshipId)) != null) {
            relationshipId = RelationshipChainLoader.followRelationshipChain(nodeId, relationship);
        }
        return relationshipId;
    }

    public void apply(final CacheAccessBackDoor cacheAccess) {
        this.nodes.visitKeys((PrimitiveLongVisitor)new PrimitiveLongVisitor<RuntimeException>(){

            public boolean visited(long nodeId) {
                cacheAccess.patchDeletedRelationshipNodes(nodeId, RelationshipHoles.this);
                return false;
            }
        });
    }
}

